/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.list;

import buildcraft.BuildCraftCore;
import buildcraft.api.lists.ListMatchHandler;
import buildcraft.core.ItemList;
import buildcraft.core.lib.gui.AdvancedSlot;
import buildcraft.core.lib.gui.GuiAdvancedInterface;
import buildcraft.core.lib.gui.buttons.GuiImageButton;
import buildcraft.core.lib.gui.buttons.IButtonClickEventListener;
import buildcraft.core.lib.gui.buttons.IButtonClickEventTrigger;
import buildcraft.core.lib.inventory.StackHelper;
import buildcraft.core.list.ContainerList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class GuiList
extends GuiAdvancedInterface
implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE_BASE = new ResourceLocation("buildcraftcore:textures/gui/list_new.png");
    private static final int BUTTON_COUNT = 3;
    private final Map<Integer, Map<ListMatchHandler.Type, List<ItemStack>>> exampleCache = new HashMap<Integer, Map<ListMatchHandler.Type, List<ItemStack>>>();
    private GuiTextField textField;
    private EntityPlayer player;

    public GuiList(EntityPlayer iPlayer) {
        super(new ContainerList(iPlayer), (IInventory)iPlayer.field_71071_by, TEXTURE_BASE);
        this.field_146999_f = 176;
        this.field_147000_g = 191;
        this.player = iPlayer;
    }

    private void clearExamplesCache(int lineId) {
        Map<ListMatchHandler.Type, List<ItemStack>> exampleList = this.exampleCache.get(lineId);
        if (exampleList != null) {
            exampleList.clear();
        }
    }

    private List<ItemStack> getExamplesList(int lineId, ListMatchHandler.Type type) {
        Map<ListMatchHandler.Type, List<ItemStack>> exampleList = this.exampleCache.get(lineId);
        if (exampleList == null) {
            exampleList = new EnumMap<ListMatchHandler.Type, List<ItemStack>>(ListMatchHandler.Type.class);
            this.exampleCache.put(lineId, exampleList);
        }
        ContainerList container = (ContainerList)this.getContainer();
        if (!exampleList.containsKey((Object)type)) {
            List<ItemStack> examples = container.lines[lineId].getExamples();
            ItemStack input = container.lines[lineId].stacks[0];
            if (input != null) {
                ArrayList<ItemStack> repetitions = new ArrayList<ItemStack>();
                for (ItemStack is : examples) {
                    if (!StackHelper.isMatchingItem(input, is, true, false)) continue;
                    repetitions.add(is);
                }
                examples.removeAll(repetitions);
            }
            exampleList.put(type, examples);
        }
        return exampleList.get((Object)type);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.exampleCache.clear();
        this.slots.clear();
        this.field_146292_n.clear();
        for (int sy = 0; sy < 2; ++sy) {
            for (int sx = 0; sx < 9; ++sx) {
                this.slots.add(new ListSlot(this, 8 + sx * 18, 32 + sy * 34, sy, sx));
            }
            int bOff = sy * 3;
            int bOffX = this.field_147003_i + 8 + 162 - 33;
            int bOffY = this.field_147009_r + 32 + sy * 34 + 18;
            this.field_146292_n.add(new GuiImageButton(bOff + 0, bOffX, bOffY, 11, TEXTURE_BASE, 176, 16, 176, 28));
            this.field_146292_n.add(new GuiImageButton(bOff + 1, bOffX + 11, bOffY, 11, TEXTURE_BASE, 176, 16, 185, 28));
            this.field_146292_n.add(new GuiImageButton(bOff + 2, bOffX + 22, bOffY, 11, TEXTURE_BASE, 176, 16, 194, 28));
        }
        for (Object o : this.field_146292_n) {
            GuiImageButton b = (GuiImageButton)o;
            int lineId = b.field_146127_k / 3;
            int buttonId = b.field_146127_k % 3;
            if (((ContainerList)this.getContainer()).lines[lineId].getOption(buttonId)) {
                b.activate();
            }
            b.registerListener(this);
        }
        this.textField = new GuiTextField(6, this.field_146289_q, 10, 10, 156, 12);
        this.textField.func_146203_f(32);
        this.textField.func_146180_a(BuildCraftCore.listItem.getLabel(this.player.func_71045_bC()));
        this.textField.func_146195_b(false);
    }

    @Override
    protected void func_146976_a(float f, int x, int y) {
        super.func_146976_a(f, x, y);
        ContainerList containerL = (ContainerList)this.getContainer();
        for (int i = 0; i < 2; ++i) {
            if (!containerL.lines[i].isOneStackMode()) continue;
            this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 30 + i * 33, 0, this.field_147000_g, 20, 20);
        }
        this.drawBackgroundSlots(x, y);
        GlStateManager.func_179084_k();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        this.textField.func_146194_f();
        this.drawTooltipForSlotAt(par1, par2);
    }

    private boolean isCarryingNonEmptyList() {
        ItemStack stack = this.field_146297_k.field_71439_g.field_71071_by.func_70445_o();
        return stack != null && stack.func_77973_b() instanceof ItemList && stack.func_77978_p() != null;
    }

    private boolean hasListEquipped() {
        return this.field_146297_k.field_71439_g.func_71045_bC() != null && this.field_146297_k.field_71439_g.func_71045_bC().func_77973_b() instanceof ItemList;
    }

    @Override
    protected void func_73864_a(int x, int y, int b) throws IOException {
        super.func_73864_a(x, y, b);
        if (this.isCarryingNonEmptyList() || !this.hasListEquipped()) {
            return;
        }
        AdvancedSlot slot = this.getSlotAtLocation(x, y);
        ContainerList container = (ContainerList)this.getContainer();
        if (slot instanceof ListSlot) {
            container.setStack(((ListSlot)slot).lineIndex, ((ListSlot)slot).slotIndex, this.field_146297_k.field_71439_g.field_71071_by.func_70445_o());
            this.clearExamplesCache(((ListSlot)slot).lineIndex);
        }
        this.textField.func_146192_a(x - this.field_147003_i, y - this.field_147009_r, b);
    }

    @Override
    public void handleButtonClick(IButtonClickEventTrigger sender, int id) {
        int buttonId = id % 3;
        int lineId = id / 3;
        ContainerList container = (ContainerList)this.getContainer();
        container.switchButton(lineId, buttonId);
        this.clearExamplesCache(lineId);
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.textField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.textField.func_146195_b(false);
            } else {
                this.textField.func_146201_a(c, i);
                ((ContainerList)this.container).setLabel(this.textField.func_146179_b());
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    private static class ListSlot
    extends AdvancedSlot {
        public int lineIndex;
        public int slotIndex;

        public ListSlot(GuiAdvancedInterface gui, int x, int y, int iLineIndex, int iSlotIndex) {
            super(gui, x, y);
            this.lineIndex = iLineIndex;
            this.slotIndex = iSlotIndex;
        }

        @Override
        public ItemStack getItemStack() {
            ContainerList container = (ContainerList)this.gui.getContainer();
            if (this.slotIndex == 0 || !container.lines[this.lineIndex].isOneStackMode()) {
                return container.lines[this.lineIndex].getStack(this.slotIndex);
            }
            List data = ((GuiList)this.gui).getExamplesList(this.lineIndex, container.lines[this.lineIndex].getSortingType());
            if (data.size() >= this.slotIndex) {
                return (ItemStack)data.get(this.slotIndex - 1);
            }
            return null;
        }

        @Override
        public void drawSprite(int cornerX, int cornerY) {
            if (!this.shouldDrawHighlight()) {
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE_BASE);
                this.gui.func_73729_b(cornerX + this.x, cornerY + this.y, 176, 0, 16, 16);
            }
            super.drawSprite(cornerX, cornerY);
        }

        @Override
        public boolean shouldDrawHighlight() {
            ContainerList container = (ContainerList)this.gui.getContainer();
            return this.slotIndex == 0 || !container.lines[this.lineIndex].isOneStackMode();
        }
    }
}

