/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.core.lib.utils.MathUtils;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;

public final class NetworkUtils {
    private NetworkUtils() {
    }

    public static void writeUTF(ByteBuf data, String str) {
        try {
            if (str == null || str.length() == 0) {
                data.writeInt(0);
                return;
            }
            byte[] b = str.getBytes("UTF-8");
            data.writeInt(b.length);
            data.writeBytes(b);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            data.writeInt(0);
        }
    }

    public static String readUTF(ByteBuf data) {
        try {
            int len = data.readInt();
            if (len == 0) {
                return "";
            }
            byte[] b = new byte[len];
            data.readBytes(b);
            return new String(b, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeNBT(ByteBuf data, NBTTagCompound nbt) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)baos);
            byte[] compressed = baos.toByteArray();
            data.writeInt(compressed.length);
            data.writeBytes(compressed);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static NBTTagCompound readNBT(ByteBuf data) {
        try {
            int length = data.readInt();
            byte[] compressed = new byte[length];
            data.readBytes(compressed);
            ByteArrayInputStream bais = new ByteArrayInputStream(compressed);
            return CompressedStreamTools.func_74796_a((InputStream)bais);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void writeStack(ByteBuf data, ItemStack stack) {
        if (stack == null || stack.func_77973_b() == null || stack.field_77994_a < 0) {
            data.writeByte(0);
        } else {
            data.writeByte(MathUtils.clamp(stack.field_77994_a + 1, 0, 64) & 0x7F | (stack.func_77942_o() ? 128 : 0));
            data.writeShort(Item.func_150891_b((Item)stack.func_77973_b()));
            data.writeShort(stack.func_77952_i());
            if (stack.func_77942_o()) {
                NetworkUtils.writeNBT(data, stack.func_77978_p());
            }
        }
    }

    public static ItemStack readStack(ByteBuf data) {
        short flags = data.readUnsignedByte();
        if (flags == 0) {
            return null;
        }
        boolean hasCompound = (flags & 0x80) != 0;
        int stackSize = (flags & 0x7F) - 1;
        int itemId = data.readUnsignedShort();
        short itemDamage = data.readShort();
        ItemStack stack = new ItemStack(Item.func_150899_d((int)itemId), stackSize, (int)itemDamage);
        if (hasCompound) {
            stack.func_77982_d(NetworkUtils.readNBT(data));
        }
        return stack;
    }

    public static void writeByteArray(ByteBuf stream, byte[] data) {
        stream.writeInt(data.length);
        stream.writeBytes(data);
    }

    public static byte[] readByteArray(ByteBuf stream) {
        byte[] data = new byte[stream.readInt()];
        stream.readBytes(data, 0, data.length);
        return data;
    }

    public static void writeVec3(ByteBuf stream, Vec3 vector) {
        stream.writeDouble(vector.field_72450_a);
        stream.writeDouble(vector.field_72448_b);
        stream.writeDouble(vector.field_72449_c);
    }

    public static Vec3 readVec3(ByteBuf stream) {
        double x = stream.readDouble();
        double y = stream.readDouble();
        double z = stream.readDouble();
        return new Vec3(x, y, z);
    }

    public static void writeBlockPos(ByteBuf stream, BlockPos pos) {
        stream.writeInt(pos.func_177958_n());
        stream.writeInt(pos.func_177956_o());
        stream.writeInt(pos.func_177952_p());
    }

    public static BlockPos readBlockPos(ByteBuf stream) {
        return new BlockPos(stream.readInt(), stream.readInt(), stream.readInt());
    }

    public static <E extends Enum<E>> void writeEnum(ByteBuf stream, E value) {
        if (value == null) {
            NetworkUtils.writeUTF(stream, "");
        } else {
            NetworkUtils.writeUTF(stream, value.name());
        }
    }

    public static <E extends Enum<E>> E readEnum(ByteBuf stream, Class<E> clazz) {
        String s = NetworkUtils.readUTF(stream);
        for (Enum val : (Enum[])clazz.getEnumConstants()) {
            if (!val.name().equals(s)) continue;
            return (E)val;
        }
        return null;
    }
}

