/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.utils.ThreadSafeUtils;
import buildcraft.core.proxy.CoreProxy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S27PacketExplosion;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;

public final class BlockUtils {
    private BlockUtils() {
    }

    public static List<ItemStack> getItemStackFromBlock(WorldServer world, BlockPos pos, BlockPos owner) {
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block == null || block.isAir((IBlockAccess)world, pos)) {
            return null;
        }
        List dropsList = block.getDrops((IBlockAccess)world, pos, state, 0);
        EntityPlayer fakePlayer = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world, owner).get();
        float dropChance = ForgeEventFactory.fireBlockHarvesting((List)dropsList, (World)world, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)false, (EntityPlayer)fakePlayer);
        ArrayList<ItemStack> returnList = new ArrayList<ItemStack>();
        for (ItemStack s : dropsList) {
            if (!(world.field_73012_v.nextFloat() <= dropChance)) continue;
            returnList.add(s);
        }
        return returnList;
    }

    public static boolean breakBlock(WorldServer world, BlockPos pos, BlockPos owner) {
        return BlockUtils.breakBlock(world, pos, BuildCraftCore.itemLifespan * 20, owner);
    }

    public static boolean breakBlock(WorldServer world, BlockPos pos, int forcedLifespan, BlockPos owner) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (BlockUtils.breakBlock(world, pos, items, owner)) {
            for (ItemStack item : items) {
                BlockUtils.dropItem(world, pos, forcedLifespan, item);
            }
            return true;
        }
        return false;
    }

    public static boolean harvestBlock(WorldServer world, BlockPos pos, ItemStack tool, BlockPos owner) {
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((World)world, pos, world.func_180495_p(pos), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world, owner).get());
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world, pos).get();
        if (!state.func_177230_c().canHarvestBlock((IBlockAccess)world, pos, player)) {
            return false;
        }
        state.func_177230_c().func_176208_a((World)world, pos, state, player);
        state.func_177230_c().func_180657_a((World)world, player, pos, state, world.func_175625_s(pos));
        world.func_175698_g(pos);
        return true;
    }

    public static EntityPlayer getFakePlayerWithTool(WorldServer world, BlockPos pos, ItemStack tool) {
        EntityPlayer player = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world, pos).get();
        for (int i = 0; player.func_70694_bm() != tool && i < 9; ++i) {
            if (i > 0) {
                player.field_71071_by.func_70299_a(i - 1, null);
            }
            player.field_71071_by.func_70299_a(i, tool);
        }
        return player;
    }

    public static boolean breakBlock(WorldServer world, BlockPos pos, List<ItemStack> drops, BlockPos owner) {
        BlockEvent.BreakEvent breakEvent = new BlockEvent.BreakEvent((World)world, pos, world.func_180495_p(pos), (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer(world, owner).get());
        MinecraftForge.EVENT_BUS.post((Event)breakEvent);
        if (breakEvent.isCanceled()) {
            return false;
        }
        if (!world.func_175623_d(pos) && !world.field_72995_K && world.func_82736_K().func_82766_b("doTileDrops")) {
            drops.addAll(BlockUtils.getItemStackFromBlock(world, pos, owner));
        }
        world.func_175698_g(pos);
        return true;
    }

    public static void dropItem(WorldServer world, BlockPos pos, int forcedLifespan, ItemStack stack) {
        float var = 0.7f;
        double dx = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dy = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        double dz = (double)(world.field_73012_v.nextFloat() * var) + (double)(1.0f - var) * 0.5;
        EntityItem entityitem = new EntityItem((World)world, (double)pos.func_177958_n() + dx, (double)pos.func_177956_o() + dy, (double)pos.func_177952_p() + dz, stack);
        entityitem.lifespan = forcedLifespan;
        entityitem.func_174869_p();
        world.func_72838_d((Entity)entityitem);
    }

    public static boolean canChangeBlock(World world, BlockPos pos) {
        return BlockUtils.canChangeBlock(world.func_180495_p(pos), world, pos);
    }

    public static boolean canChangeBlock(IBlockState state, World world, BlockPos pos) {
        Fluid f;
        if (state == null) {
            return true;
        }
        Block block = state.func_177230_c();
        if (block == null || block.isAir((IBlockAccess)world, pos)) {
            return true;
        }
        if (BlockUtils.isUnbreakableBlock(world, pos, block)) {
            return false;
        }
        if (block == Blocks.field_150353_l || block == Blocks.field_150356_k) {
            return false;
        }
        return !(block instanceof IFluidBlock) || ((IFluidBlock)block).getFluid() == null || (f = ((IFluidBlock)block).getFluid()).getDensity(world, pos) < 3000;
    }

    public static float getBlockHardnessMining(World world, BlockPos pos, Block b) {
        EntityPlayer fakePlayer;
        float relativeHardness;
        if (world instanceof WorldServer && !BuildCraftCore.miningAllowPlayerProtectedBlocks && (relativeHardness = b.func_180647_a(fakePlayer = (EntityPlayer)CoreProxy.proxy.getBuildCraftPlayer((WorldServer)world, pos).get(), world, pos)) <= 0.0f) {
            return -1.0f;
        }
        return b.func_176195_g(world, pos);
    }

    public static boolean isUnbreakableBlock(World world, BlockPos pos, Block b) {
        if (b == null) {
            return false;
        }
        return BlockUtils.getBlockHardnessMining(world, pos, b) < 0.0f;
    }

    public static boolean isUnbreakableBlock(World world, BlockPos pos) {
        return BlockUtils.isUnbreakableBlock(world, pos, world.func_180495_p(pos).func_177230_c());
    }

    public static boolean isToughBlock(World world, BlockPos pos) {
        return !world.func_180495_p(pos).func_177230_c().func_149688_o().func_76229_l();
    }

    public static boolean isFullFluidBlock(World world, BlockPos pos) {
        return BlockUtils.isFullFluidBlock(world.func_180495_p(pos), world, pos);
    }

    public static boolean isFullFluidBlock(IBlockState state, World world, BlockPos pos) {
        Block block = state.func_177230_c();
        if (block instanceof IFluidBlock) {
            FluidStack fluid = ((IFluidBlock)block).drain(world, pos, false);
            return fluid == null || fluid.amount > 0;
        }
        if (block instanceof BlockLiquid) {
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            return level == 0;
        }
        return false;
    }

    public static Fluid getFluid(Block block) {
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static FluidStack drainBlock(World world, BlockPos pos, boolean doDrain) {
        return BlockUtils.drainBlock(world.func_180495_p(pos), world, pos, doDrain);
    }

    public static FluidStack drainBlock(IBlockState state, World world, BlockPos pos, boolean doDrain) {
        Block block = state.func_177230_c();
        Fluid fluid = FluidRegistry.lookupFluidForBlock((Block)block);
        if (fluid != null && FluidRegistry.isFluidRegistered((Fluid)fluid)) {
            if (block instanceof IFluidBlock) {
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (!fluidBlock.canDrain(world, pos)) {
                    return null;
                }
                return fluidBlock.drain(world, pos, doDrain);
            }
            int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
            if (level != 0) {
                return null;
            }
            if (doDrain) {
                world.func_175698_g(pos);
            }
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public static void explodeBlock(World world, BlockPos pos) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            return;
        }
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        Explosion explosion = new Explosion(world, null, x, y, z, 3.0f, false, false);
        explosion.func_180343_e().add(pos);
        explosion.func_77279_a(true);
        for (EntityPlayer player : world.field_73010_i) {
            if (!(player instanceof EntityPlayerMP) || !(player.func_174818_b(pos) < 4096.0)) continue;
            ((EntityPlayerMP)player).field_71135_a.func_147359_a((Packet)new S27PacketExplosion(x, y, z, 3.0f, explosion.func_180343_e(), null));
        }
    }

    public static int computeBlockBreakEnergy(World world, BlockPos pos) {
        float hardness = world.func_180495_p(pos).func_177230_c().func_176195_g(world, pos);
        return (int)Math.floor(160.0f * BuildCraftCore.miningMultiplier * ((hardness + 1.0f) * 2.0f));
    }

    public static TileEntity getTileEntity(World world, BlockPos pos) {
        return BlockUtils.getTileEntity(world, pos, false);
    }

    public static TileEntity getTileEntity(World world, BlockPos pos, boolean force) {
        if (!force) {
            if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255) {
                return null;
            }
            Chunk chunk = ThreadSafeUtils.getChunk(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunk != null ? chunk.func_177424_a(pos, Chunk.EnumCreateEntityType.CHECK) : null;
        }
        return world.func_175625_s(pos);
    }

    public static IBlockState getBlockState(World world, BlockPos pos) {
        return BlockUtils.getBlockState(world, pos, false);
    }

    public static IBlockState getBlockState(World world, BlockPos pos, boolean force) {
        if (!force) {
            if (pos.func_177956_o() < 0 || pos.func_177956_o() >= world.func_72800_K()) {
                return Blocks.field_150350_a.func_176223_P();
            }
            Chunk chunk = ThreadSafeUtils.getChunk(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
            return chunk != null ? chunk.func_177435_g(pos) : Blocks.field_150350_a.func_176223_P();
        }
        if (pos.func_177956_o() < 0 || pos.func_177956_o() > 255) {
            return Blocks.field_150350_a.func_176223_P();
        }
        Chunk chunk = ThreadSafeUtils.getChunk(world, pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
        return chunk != null ? chunk.func_177435_g(pos) : Blocks.field_150350_a.func_176223_P();
    }

    public static boolean useItemOnBlock(World world, EntityPlayer player, ItemStack stack, BlockPos pos, EnumFacing direction) {
        boolean done = stack.func_77973_b().onItemUseFirst(stack, player, world, pos, direction, 0.5f, 0.5f, 0.5f);
        if (!done) {
            done = stack.func_77973_b().func_180614_a(stack, player, world, pos, direction, 0.5f, 0.5f, 0.5f);
        }
        return done;
    }

    public static void onComparatorUpdate(World world, BlockPos pos, Block block) {
        world.func_175666_e(pos, block);
    }

    public static TileEntityChest getOtherDoubleChest(TileEntity inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest adjacent = null;
            chest.func_145979_i();
            if (chest.field_145991_k != null) {
                adjacent = chest.field_145991_k;
            }
            if (chest.field_145990_j != null) {
                adjacent = chest.field_145990_j;
            }
            if (chest.field_145992_i != null) {
                adjacent = chest.field_145992_i;
            }
            if (chest.field_145988_l != null) {
                adjacent = chest.field_145988_l;
            }
            return adjacent;
        }
        return null;
    }
}

