/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.core.Box;
import buildcraft.core.lib.utils.NBTUtils;
import java.util.Iterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class BlockScanner
implements Iterable<BlockPos> {
    Box box = new Box();
    World world;
    BlockPos pos;
    int iterationsPerCycle;
    int blocksDone = 0;

    public BlockScanner(Box box, World world, int iterationsPreCycle) {
        this.box = box;
        this.world = world;
        this.iterationsPerCycle = iterationsPreCycle;
        this.pos = box.min();
    }

    public BlockScanner() {
    }

    @Override
    public Iterator<BlockPos> iterator() {
        return new BlockIt();
    }

    public int totalBlocks() {
        return this.box.size().func_177958_n() * this.box.size().func_177956_o() * this.box.size().func_177952_p();
    }

    public int blocksLeft() {
        return this.totalBlocks() - this.blocksDone;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("pos", NBTUtils.writeBlockPos(this.pos));
        nbt.func_74768_a("blocksDone", this.blocksDone);
        nbt.func_74768_a("iterationsPerCycle", this.iterationsPerCycle);
        NBTTagCompound boxNBT = new NBTTagCompound();
        this.box.writeToNBT(boxNBT);
        nbt.func_74782_a("box", (NBTBase)boxNBT);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.pos = NBTUtils.readBlockPos(nbt.func_74781_a("pos"));
        this.blocksDone = nbt.func_74762_e("blocksDone");
        this.iterationsPerCycle = nbt.func_74762_e("iterationsPerCycle");
        this.box.initialize(nbt.func_74775_l("box"));
    }

    class BlockIt
    implements Iterator<BlockPos> {
        int it = 0;

        BlockIt() {
        }

        @Override
        public boolean hasNext() {
            return BlockScanner.this.pos.func_177952_p() <= BlockScanner.this.box.max().func_177952_p() && this.it <= BlockScanner.this.iterationsPerCycle;
        }

        @Override
        public BlockPos next() {
            BlockPos index = new BlockPos((Vec3i)BlockScanner.this.pos);
            ++this.it;
            ++BlockScanner.this.blocksDone;
            if (BlockScanner.this.pos.func_177958_n() < BlockScanner.this.box.max().func_177958_n()) {
                BlockScanner.this.pos = BlockScanner.this.pos.func_177974_f();
            } else {
                BlockScanner.this.pos = new BlockPos(BlockScanner.this.box.min().func_177958_n(), BlockScanner.this.pos.func_177956_o(), BlockScanner.this.pos.func_177952_p());
                BlockScanner.this.pos = BlockScanner.this.pos.func_177956_o() < BlockScanner.this.box.max().func_177956_o() ? BlockScanner.this.pos.func_177984_a() : new BlockPos(BlockScanner.this.pos.func_177958_n(), BlockScanner.this.box.min().func_177956_o(), BlockScanner.this.pos.func_177952_p() + 1);
            }
            return index;
        }

        @Override
        public void remove() {
        }
    }
}

