/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import com.google.common.base.Splitter;
import java.text.DecimalFormat;
import net.minecraft.util.BlockPos;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;

public final class BCStringUtils {
    public static final Splitter newLineSplitter = Splitter.on((String)"\\n");
    private static final DecimalFormat displayDecimalFormat = new DecimalFormat("#####0.00");

    private BCStringUtils() {
    }

    public static String localize(String key) {
        return StatCollector.func_74838_a((String)key);
    }

    public static boolean canLocalize(String key) {
        return StatCollector.func_94522_b((String)key);
    }

    public static String blockPosToShortString(BlockPos pos) {
        return pos.func_177958_n() + "," + pos.func_177956_o() + "," + pos.func_177952_p();
    }

    public static BlockPos blockPosFromShortString(String string) {
        String[] s = string.split(",");
        try {
            return new BlockPos(Integer.parseInt(s[0]), Integer.parseInt(s[1]), Integer.parseInt(s[2]));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("The given string \"" + string + "\" was invalid!", nfe);
        }
        catch (ArrayIndexOutOfBoundsException aioobe) {
            throw new IllegalArgumentException("The given string \"" + string + "\" was invalid!", aioobe);
        }
    }

    public static String vec3ToDispString(Vec3 vec) {
        if (vec == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(displayDecimalFormat.format(vec.field_72450_a));
        builder.append(", ");
        builder.append(displayDecimalFormat.format(vec.field_72448_b));
        builder.append(", ");
        builder.append(displayDecimalFormat.format(vec.field_72449_c));
        return builder.toString();
    }

    public static String vec3ToDispString(Vec3i vec) {
        if (vec == null) {
            return "null";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(vec.func_177958_n());
        builder.append(", ");
        builder.append(vec.func_177956_o());
        builder.append(", ");
        builder.append(vec.func_177952_p());
        return builder.toString();
    }
}

