/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.network;

import buildcraft.BuildCraftCore;
import buildcraft.core.lib.network.IGuiReturnHandler;
import buildcraft.core.lib.network.base.Packet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.world.World;

public class PacketGuiReturn
extends Packet {
    private IGuiReturnHandler obj;
    private byte[] extraData;
    private boolean tileReturn;
    private BlockPos pos;
    private int entityId;
    private ByteBuf heldData;

    public PacketGuiReturn() {
    }

    public PacketGuiReturn(IGuiReturnHandler obj) {
        this.obj = obj;
        this.extraData = null;
        this.tempWorld = obj.getWorldBC();
        this.dimensionId = this.tempWorld.field_73011_w.func_177502_q();
    }

    public PacketGuiReturn(IGuiReturnHandler obj, byte[] extraData) {
        this.obj = obj;
        this.extraData = extraData;
        this.tempWorld = obj.getWorldBC();
        this.dimensionId = this.tempWorld.field_73011_w.func_177502_q();
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        if (this.obj instanceof TileEntity) {
            TileEntity tile = (TileEntity)this.obj;
            data.writeBoolean(true);
            data.writeInt(tile.func_174877_v().func_177958_n());
            data.writeInt(tile.func_174877_v().func_177956_o());
            data.writeInt(tile.func_174877_v().func_177952_p());
        } else if (this.obj instanceof Entity) {
            Entity entity = (Entity)this.obj;
            data.writeBoolean(false);
            data.writeInt(entity.func_145782_y());
        } else {
            return;
        }
        ByteBuf guiData = Unpooled.buffer();
        this.obj.writeGuiData(guiData);
        if (this.extraData != null) {
            guiData.writeBytes(this.extraData);
        }
        int length = guiData.readableBytes();
        data.writeInt(length);
        data.writeBytes(guiData);
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.tileReturn = data.readBoolean();
        if (this.tileReturn) {
            this.pos = new BlockPos(data.readInt(), data.readInt(), data.readInt());
            int length = data.readInt();
            this.heldData = data.readBytes(length);
        } else {
            this.entityId = data.readInt();
            int length = data.readInt();
            this.heldData = data.readBytes(length);
        }
    }

    public void sendPacket() {
        BuildCraftCore.instance.sendToServer(this);
    }

    @Override
    public void applyData(World world, EntityPlayer player) {
        if (this.tileReturn) {
            TileEntity tile = world.func_175625_s(this.pos);
            if (tile instanceof IGuiReturnHandler) {
                IGuiReturnHandler handler = (IGuiReturnHandler)tile;
                handler.readGuiData(this.heldData, null);
            }
        } else {
            Entity ent = world.func_73045_a(this.entityId);
            if (ent instanceof IGuiReturnHandler) {
                IGuiReturnHandler handler = (IGuiReturnHandler)ent;
                handler.readGuiData(this.heldData, null);
            }
        }
    }
}

