/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import buildcraft.api.core.IStackFilter;
import buildcraft.core.lib.inventory.Transactor;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class TransactorItemHandler
extends Transactor {
    protected IItemHandler handler;

    public TransactorItemHandler(IItemHandler handler) {
        this.handler = handler;
    }

    @Override
    public int inject(ItemStack stack, boolean doAdd) {
        ArrayList<Integer> filledSlots = new ArrayList<Integer>(this.handler.getSlots());
        ArrayList<Integer> emptySlots = new ArrayList<Integer>(this.handler.getSlots());
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack simulated = this.handler.insertItem(i, stack, true);
            if (simulated != null && simulated.field_77994_a >= stack.field_77994_a) continue;
            if (this.handler.getStackInSlot(i) == null) {
                emptySlots.add(i);
                continue;
            }
            filledSlots.add(i);
        }
        int injected = 0;
        injected = this.tryPut(stack, filledSlots, injected, doAdd);
        injected = this.tryPut(stack, emptySlots, injected, doAdd);
        return injected;
    }

    private int tryPut(ItemStack stack, List<Integer> slots, int injected, boolean doAdd) {
        int realInjected = injected;
        ItemStack toInsert = null;
        if (realInjected >= stack.field_77994_a) {
            return realInjected;
        }
        for (int i : slots) {
            if (toInsert == null) {
                toInsert = stack.func_77946_l();
                toInsert.field_77994_a = stack.field_77994_a - realInjected;
            }
            int oldInjected = realInjected;
            ItemStack insertedStack = this.handler.insertItem(i, toInsert, !doAdd);
            realInjected = insertedStack == null ? (realInjected += stack.field_77994_a) : (realInjected += stack.field_77994_a - insertedStack.field_77994_a);
            if (realInjected >= stack.field_77994_a) {
                return realInjected;
            }
            if (oldInjected == realInjected) continue;
            toInsert = null;
        }
        return realInjected;
    }

    @Override
    public ItemStack remove(IStackFilter filter, boolean doRemove) {
        for (int i = 0; i < this.handler.getSlots(); ++i) {
            ItemStack stack = this.handler.getStackInSlot(i);
            if (stack == null || !filter.matches(stack)) continue;
            return this.handler.extractItem(i, 1, !doRemove);
        }
        return null;
    }
}

