/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.inventory;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public interface IItemHandlerDelegate {

    public static class InsertItemChecker
    implements FunctionInsertItem {
        private final PredicateIsItemValidForSlot predicate;

        public InsertItemChecker(PredicateIsItemValidForSlot predicate) {
            this.predicate = predicate;
        }

        @Override
        public ItemStack insertItem(IItemHandler handler, int slot, ItemStack stack, boolean simulate) {
            if (!this.predicate.isItemValidForSlot(handler, slot, stack)) {
                return stack;
            }
            return handler.insertItem(slot, stack, simulate);
        }
    }

    public static interface PredicateIsItemValidForSlot {
        public boolean isItemValidForSlot(IItemHandler var1, int var2, ItemStack var3);

        default public FunctionInsertItem toFuncInsertItem() {
            return new InsertItemChecker(this);
        }
    }

    public static interface FunctionExtractItem {
        public ItemStack extractItem(IItemHandler var1, int var2, int var3, boolean var4);
    }

    public static interface FunctionInsertItem {
        public ItemStack insertItem(IItemHandler var1, int var2, ItemStack var3, boolean var4);
    }
}

