/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.gui.widgets;

import buildcraft.core.lib.fluids.Tank;
import buildcraft.core.lib.gui.GuiBuildCraft;
import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.widgets.Widget;
import java.io.DataInputStream;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class FluidTankWidget
extends Widget {
    public static final byte NET_CLICK = 0;
    public final Tank tank;
    private boolean overlay;
    private int overlayX;
    private int overlayY;

    public FluidTankWidget(Tank tank, int x, int y, int w, int h) {
        super(x, y, 0, 0, w, h);
        this.tank = tank;
    }

    public FluidTankWidget withOverlay(int x, int y) {
        this.overlay = true;
        this.overlayX = x;
        this.overlayY = y;
        return this;
    }

    public FluidTankWidget copyMoved(Tank tank, int x, int y) {
        FluidTankWidget copy = new FluidTankWidget(tank, x, y, this.w, this.h);
        if (this.overlay) {
            copy.withOverlay(this.overlayX, this.overlayY);
        }
        return copy;
    }

    @Override
    public ToolTip getToolTip() {
        return this.tank.getToolTip();
    }

    @Override
    public boolean handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        this.container.sendWidgetDataToServer(this, new byte[]{0});
        return true;
    }

    @Override
    public void handleServerPacketData(DataInputStream data) throws IOException {
        byte b = data.readByte();
        if (b == 0) {
            this.handleTankClick();
        }
    }

    private void handleTankClick() {
        InventoryPlayer inv = this.container.getPlayer().field_71071_by;
        ItemStack heldStack = inv.func_70445_o();
        if (heldStack == null || heldStack.func_77973_b() == null) {
            return;
        }
        Item heldItem = heldStack.func_77973_b();
        if (FluidContainerRegistry.isEmptyContainer((ItemStack)heldStack)) {
            int capacity = FluidContainerRegistry.getContainerCapacity((FluidStack)this.tank.drain(1, false), (ItemStack)heldStack);
            FluidStack potential = this.tank.drain(capacity, false);
            if (potential == null) {
                return;
            }
            ItemStack filled = FluidContainerRegistry.fillFluidContainer((FluidStack)potential, (ItemStack)heldStack);
            if (filled == null) {
                return;
            }
            if (FluidContainerRegistry.getContainerCapacity((ItemStack)filled) != capacity) {
                return;
            }
            this.tank.drain(capacity, true);
            inv.func_70437_b(filled);
            if (inv.field_70458_d instanceof EntityPlayerMP) {
                ((EntityPlayerMP)inv.field_70458_d).func_71113_k();
            }
        } else if (FluidContainerRegistry.isFilledContainer((ItemStack)heldStack)) {
            FluidStack contained = FluidContainerRegistry.getFluidForFilledItem((ItemStack)heldStack);
            if (this.tank.fill(contained, false) != contained.amount) {
                return;
            }
            ItemStack drained = FluidContainerRegistry.drainFluidContainer((ItemStack)heldStack);
            if (drained == null) {
                return;
            }
            this.tank.fill(contained, true);
            inv.func_70437_b(drained);
            if (inv.field_70458_d instanceof EntityPlayerMP) {
                ((EntityPlayerMP)inv.field_70458_d).func_71113_k();
            }
        } else if (heldItem instanceof IFluidContainerItem) {
            IFluidContainerItem container = (IFluidContainerItem)heldItem;
            FluidStack fluidStack = container.getFluid(heldStack);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiBuildCraft gui, int guiX, int guiY, int mouseX, int mouseY) {
        if (this.tank == null) {
            return;
        }
        FluidStack fluidStack = this.tank.getFluid();
        if (fluidStack != null && fluidStack.amount > 0) {
            gui.drawFluid(fluidStack, guiX + this.x, guiY + this.y, this.w, this.h, this.tank.getCapacity());
        }
        GuiBuildCraft.bindTexture(gui.texture);
        if (this.overlay) {
            gui.func_73729_b(guiX + this.x, guiY + this.y, this.overlayX, this.overlayY, this.w, this.h);
        }
    }
}

