/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.fluids;

import buildcraft.core.lib.gui.tooltips.ToolTip;
import buildcraft.core.lib.gui.tooltips.ToolTipLine;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;

public class Tank
extends FluidTank
implements INBTSerializable<NBTTagCompound> {
    public int colorRenderCache = 0xFFFFFF;
    protected final ToolTip toolTip = new ToolTip(new ToolTipLine[0]){

        @Override
        public void refresh() {
            Tank.this.refreshTooltip();
        }
    };
    private final String name;
    private final Predicate<FluidStack> filter;

    public Tank(String name, int capacity, TileEntity tile) {
        this(name, capacity, tile, null);
    }

    public Tank(String name, int capacity, TileEntity tile, Predicate<FluidStack> filter) {
        super(capacity);
        this.name = name;
        this.tile = tile;
        this.filter = filter;
    }

    public String getTankName() {
        return this.name;
    }

    public boolean isEmpty() {
        return this.getFluid() == null || this.getFluid().amount <= 0;
    }

    public boolean isFull() {
        return this.getFluid() != null && this.getFluid().amount >= this.getCapacity();
    }

    public Fluid getFluidType() {
        return this.getFluid() != null ? this.getFluid().getFluid() : null;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return nbt;
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public final NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        NBTTagCompound tankData = new NBTTagCompound();
        super.writeToNBT(tankData);
        this.writeTankToNBT(tankData);
        nbt.func_74782_a(this.name, (NBTBase)tankData);
        return nbt;
    }

    public final FluidTank readFromNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b(this.name)) {
            this.setFluid(null);
            NBTTagCompound tankData = nbt.func_74775_l(this.name);
            super.readFromNBT(tankData);
            this.readTankFromNBT(tankData);
        }
        return this;
    }

    public void writeTankToNBT(NBTTagCompound nbt) {
    }

    public void readTankFromNBT(NBTTagCompound nbt) {
    }

    public ToolTip getToolTip() {
        return this.toolTip;
    }

    protected void refreshTooltip() {
        this.toolTip.clear();
        int amount = 0;
        if (this.getFluid() != null && this.getFluid().amount > 0) {
            ToolTipLine fluidName = new ToolTipLine(this.getFluid().getFluid().getLocalizedName(this.getFluid()), EnumChatFormatting.WHITE);
            fluidName.setSpacing(2);
            this.toolTip.add(fluidName);
            amount = this.getFluid().amount;
        }
        this.toolTip.add(new ToolTipLine(String.format(Locale.ENGLISH, "%,d / %,d", amount, this.getCapacity())));
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.filter == null || this.filter.test(resource)) {
            return super.fill(resource, doFill);
        }
        return 0;
    }

    public void setFluid(FluidStack fluid) {
        if (fluid == null || this.filter == null || this.filter.test(fluid)) {
            super.setFluid(fluid);
        }
    }

    public String toString() {
        return "Tank [" + this.getContentsString() + "]";
    }

    public String getContentsString() {
        if (this.fluid == null || this.fluid.amount <= 0) {
            return "Empty";
        }
        return (double)this.fluid.amount / 1000.0 + "B of " + this.fluid.getLocalizedName();
    }
}

