/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.event;

import buildcraft.api.core.BCLog;
import buildcraft.core.lib.event.EventBusASM;
import buildcraft.core.lib.event.EventProviderASM;
import buildcraft.core.lib.event.IEventBus;
import buildcraft.core.lib.event.IEventBusProvider;
import buildcraft.core.lib.event.IEventHandler;
import buildcraft.core.lib.event.IEventHandlerProvider;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileOutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EventBusProviderASM<T>
implements IEventBusProvider<T> {
    private final Class<T> eventBaseClass;
    private final Class<? extends Annotation> annotationClass;
    private final Map<Class<?>, EventProviderASM<T>> classMap = new HashMap();

    public EventBusProviderASM(Class<T> eventClass, Class<? extends Annotation> annotation) {
        this.eventBaseClass = eventClass;
        this.annotationClass = annotation;
    }

    @Override
    public IEventBus<T> newBus() {
        return new EventBusASM(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventProviderASM<T> getProviderFor(Class<?> clazz) {
        if (!this.classMap.containsKey(clazz)) {
            Map<Class<?>, EventProviderASM<T>> map = this.classMap;
            synchronized (map) {
                if (!this.classMap.containsKey(clazz)) {
                    EventProviderASM<T> prov = this.generateProvider(clazz);
                    this.classMap.put(clazz, prov);
                }
            }
        }
        return this.classMap.get(clazz);
    }

    private EventProviderASM<T> generateProvider(Class<?> clazz) {
        ArrayList providers = Lists.newArrayList();
        for (Method meth : clazz.getMethods()) {
            Annotation annotation;
            if (!Modifier.isPublic(meth.getModifiers()) || (annotation = meth.getAnnotation(this.annotationClass)) == null) continue;
            Class<?>[] parameters = meth.getParameterTypes();
            if (parameters.length != 1) {
                BCLog.logger.warn("Found a method " + meth.getName() + " in the class " + clazz.getName() + ", annoted with @" + this.annotationClass.getSimpleName() + ", that does not have a single argument!");
                continue;
            }
            Class<?> par = parameters[0];
            if (!par.isInterface()) {
                BCLog.logger.warn("Found a method " + meth.getName() + " in the class " + clazz.getName() + " that listened to a class directly!");
                continue;
            }
            if (!this.eventBaseClass.isAssignableFrom(par)) {
                BCLog.logger.warn("Found a method " + meth.getName() + " in the class " + clazz.getName() + ", annoted with @" + this.annotationClass.getSimpleName() + ", that has an argument that does not extend " + this.eventBaseClass.getName() + " (Was " + par.getName() + "!");
                continue;
            }
            providers.add(this.generateSingleProvider(meth, par));
        }
        return new EventProviderASM(providers);
    }

    private IEventHandlerProvider<T> generateSingleProvider(Method meth, Class<?> parClass) {
        String clsName = "buildcraft.core.lib.event._GENERATED_.";
        clsName = clsName + meth.getDeclaringClass().getName() + "._METHOD_.";
        clsName = clsName + meth.getName() + "._EVENT_." + parClass.getName();
        String name = clsName + ".Caller";
        byte[] bytecode = this.generateDirectHandler(meth, parClass, name);
        Class handler = this.writeAndLoadClassOfA(bytecode, name);
        name = clsName + ".Generator";
        bytecode = this.generateGenerator(handler, meth.getDeclaringClass(), name);
        Class provider = this.writeAndLoadClassOfA(bytecode, name);
        try {
            return (IEventHandlerProvider)provider.newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private byte[] generateGenerator(Class<? extends IEventHandler<?>> handlerClass, Class<?> parClass, String clsName) {
        ClassWriter writer = new ClassWriter(3);
        ClassNode node = new ClassNode();
        node.name = clsName.replace('.', '/');
        node.version = 50;
        node.access = 17;
        node.interfaces = Lists.newArrayList((Object[])new String[]{IEventHandlerProvider.class.getName().replace('.', '/')});
        node.superName = "java/lang/Object";
        MethodNode consturctorMethod = new MethodNode();
        consturctorMethod.access = 1;
        consturctorMethod.desc = "()V";
        consturctorMethod.name = "<init>";
        consturctorMethod.exceptions = Lists.newArrayList();
        consturctorMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        consturctorMethod.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/Object", "<init>", "()V", false));
        consturctorMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        node.methods.add(consturctorMethod);
        MethodNode generationMethod = new MethodNode();
        generationMethod.access = 17;
        generationMethod.desc = "(Ljava/lang/Object;)Lbuildcraft/core/lib/event/IEventHandler;";
        generationMethod.name = "createNewHandler";
        generationMethod.exceptions = Lists.newArrayList();
        generationMethod.instructions.add((AbstractInsnNode)new TypeInsnNode(187, Type.getInternalName(handlerClass)));
        generationMethod.instructions.add((AbstractInsnNode)new InsnNode(89));
        generationMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        generationMethod.instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(parClass)));
        generationMethod.instructions.add((AbstractInsnNode)new MethodInsnNode(183, Type.getInternalName(handlerClass), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(parClass)}), false));
        generationMethod.instructions.add((AbstractInsnNode)new InsnNode(176));
        node.methods.add(generationMethod);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] generateDirectHandler(Method meth, Class<?> parClass, String clsName) {
        ClassWriter writer = new ClassWriter(3);
        ClassNode node = new ClassNode();
        node.name = clsName.replace('.', '/');
        node.access = 17;
        node.interfaces = Lists.newArrayList((Object[])new String[]{IEventHandler.class.getName().replace('.', '/')});
        node.version = 50;
        node.superName = "java/lang/Object";
        String fd = Type.getDescriptor(meth.getDeclaringClass());
        node.fields.add(new FieldNode(18, "listener", fd, null, null));
        MethodNode consturctorMethod = new MethodNode();
        consturctorMethod.access = 1;
        consturctorMethod.desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(meth.getDeclaringClass())});
        consturctorMethod.name = "<init>";
        consturctorMethod.exceptions = Lists.newArrayList();
        consturctorMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        consturctorMethod.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "java/lang/Object", "<init>", "()V", false));
        consturctorMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        consturctorMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        consturctorMethod.instructions.add((AbstractInsnNode)new FieldInsnNode(181, node.name, "listener", fd));
        consturctorMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        node.methods.add(consturctorMethod);
        MethodNode generationMethod = new MethodNode();
        generationMethod.access = 17;
        generationMethod.desc = Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Type.getType(Object.class)});
        generationMethod.name = "handle";
        generationMethod.exceptions = Lists.newArrayList();
        generationMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        generationMethod.instructions.add((AbstractInsnNode)new TypeInsnNode(193, Type.getInternalName(parClass)));
        LabelNode instanceLabel = new LabelNode();
        generationMethod.instructions.add((AbstractInsnNode)new JumpInsnNode(154, instanceLabel));
        generationMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        generationMethod.instructions.add((AbstractInsnNode)instanceLabel);
        generationMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        String desc = Type.getDescriptor(meth.getDeclaringClass());
        generationMethod.instructions.add((AbstractInsnNode)new FieldInsnNode(180, node.name, "listener", desc));
        generationMethod.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        generationMethod.instructions.add((AbstractInsnNode)new TypeInsnNode(192, Type.getInternalName(parClass)));
        generationMethod.instructions.add((AbstractInsnNode)new MethodInsnNode(182, Type.getInternalName(meth.getDeclaringClass()), meth.getName(), Type.getMethodDescriptor((Method)meth), false));
        generationMethod.instructions.add((AbstractInsnNode)new InsnNode(177));
        node.methods.add(generationMethod);
        node.accept((ClassVisitor)writer);
        byte[] bytecode = writer.toByteArray();
        return bytecode;
    }

    private <A> Class<A> writeAndLoadClassOfA(byte[] bytes, String clsName) {
        try {
            File folder = new File("./asm/buildcraft/");
            folder.mkdirs();
            FileOutputStream fos = new FileOutputStream("./asm/buildcraft/" + clsName + ".class");
            fos.write(bytes);
            fos.flush();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        Class<?> cls = ByteCodeLoader.INSTANCE.define(clsName, bytes);
        return cls;
    }

    static class ByteCodeLoader
    extends ClassLoader {
        public static final ByteCodeLoader INSTANCE = new ByteCodeLoader();
        private Map<String, Class<?>> classDefinitionMap = new HashMap();

        private ByteCodeLoader() {
            super(ByteCodeLoader.class.getClassLoader());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Class<?> define(String name, byte[] data) {
            Map<String, Class<?>> map = this.classDefinitionMap;
            synchronized (map) {
                if (!this.classDefinitionMap.containsKey(name)) {
                    BCLog.logger.info("Defining the class " + name);
                    this.classDefinitionMap.put(name, this.defineClass(name, data, 0, data.length));
                }
                return this.classDefinitionMap.get(name);
            }
        }
    }
}

