/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.event;

import buildcraft.core.lib.event.EventBusProviderASM;
import buildcraft.core.lib.event.EventProviderASM;
import buildcraft.core.lib.event.IEventBus;
import buildcraft.core.lib.event.IEventHandler;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;

public class EventBusASM<T>
implements IEventBus<T> {
    private final Multimap<Object, IEventHandler<T>> handlers = HashMultimap.create();
    private final EventBusProviderASM<T> provider;

    public EventBusASM(EventBusProviderASM<T> provider) {
        this.provider = provider;
    }

    @Override
    public void registerHandler(Object handler) {
        EventProviderASM<T> eventProvider = this.provider.getProviderFor(handler.getClass());
        this.handlers.putAll(handler, eventProvider.getNewHandlerSet(handler));
    }

    @Override
    public void unregisterHandler(Object handler) {
        this.handlers.removeAll(handler);
    }

    @Override
    public void handleEvent(T event) {
        Collection handlers = this.handlers.values();
        handlers = ImmutableList.copyOf((Collection)handlers);
        for (IEventHandler handler : handlers) {
            handler.handle(event);
        }
    }
}

