/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.engines;

import buildcraft.api.enums.EnumEnergyStage;
import buildcraft.api.enums.EnumEngineType;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.transport.IItemPipe;
import buildcraft.core.lib.block.BlockBuildCraft;
import buildcraft.core.lib.client.render.ICustomHighlight;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BlockEngineBase
extends BlockBuildCraft
implements ICustomHighlight {
    private static final Map<EnumFacing, AxisAlignedBB[]> boxMap;

    public BlockEngineBase() {
        super(Material.field_151573_f, ENGINE_TYPE, FACING_6_PROP, ENERGY_STAGE);
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        TileEntity tile = access.func_175625_s(pos);
        if (tile instanceof TileEngineBase) {
            TileEngineBase engine = (TileEngineBase)tile;
            state = state.func_177226_a((IProperty)FACING_6_PROP, (Comparable)engine.orientation);
            state = state.func_177226_a((IProperty)ENERGY_STAGE, (Comparable)((Object)engine.energyStage));
        }
        return state;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return 3;
    }

    public boolean isSideSolid(IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase) {
            return ((TileEngineBase)tile).orientation.func_176734_d() == side;
        }
        return false;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float par7, float par8, float par9) {
        TileEntity tile = world.func_175625_s(pos);
        BlockInteractionEvent event = new BlockInteractionEvent(player, state);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return false;
        }
        if (player.func_71045_bC() != null && player.func_71045_bC().func_77973_b() instanceof IItemPipe) {
            return false;
        }
        if (tile instanceof TileEngineBase) {
            return ((TileEngineBase)tile).onBlockActivated(player, side);
        }
        return false;
    }

    @Override
    public AxisAlignedBB[] getBoxes(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase) {
            return boxMap.get(((TileEngineBase)tile).orientation);
        }
        return super.getBoxes(world, pos, state);
    }

    @Override
    public double getExpansion() {
        return 0.0075;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase) {
            TileEngineBase engine = (TileEngineBase)tile;
            engine.orientation = EnumFacing.UP;
            if (!engine.isOrientationValid()) {
                engine.switchOrientation(true);
            }
        }
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase) {
            TileEngineBase engine = (TileEngineBase)tile;
            return engine.switchOrientation(false);
        }
        return false;
    }

    public int func_180651_a(IBlockState state) {
        return ((EnumEngineType)((Object)state.func_177229_b((IProperty)ENGINE_TYPE))).ordinal();
    }

    public void func_180655_c(World world, BlockPos pos, IBlockState state, Random random) {
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TileEngineBase)) {
            return;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (((TileEngineBase)tile).getEnergyStage() == EnumEnergyStage.OVERHEAT) {
            for (int f = 0; f < 16; ++f) {
                double particleX = (float)x + 0.4f + random.nextFloat() * 0.2f;
                double particleY = (float)y + random.nextFloat() * 0.5f;
                double particleZ = (float)z + 0.4f + random.nextFloat() * 0.2f;
                double particleOffsetX = random.nextFloat() * 0.04f - 0.02f;
                double particleOffsetY = random.nextFloat() * 0.05f + 0.02f;
                double particleOffsetZ = random.nextFloat() * 0.04f - 0.02f;
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, particleX, particleY, particleZ, particleOffsetX, particleOffsetY, particleOffsetZ, new int[0]);
            }
        } else if (((TileEngineBase)tile).isBurning()) {
            float f = (float)x + 0.5f;
            float f1 = (float)y + 0.0f + random.nextFloat() * 6.0f / 16.0f;
            float f2 = (float)z + 0.5f;
            float f3 = 0.52f;
            float f4 = random.nextFloat() * 0.6f - 0.3f;
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(f - f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(f + f3), (double)f1, (double)(f2 + f4), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(f + f4), (double)f1, (double)(f2 - f3), 0.0, 0.0, 0.0, new int[0]);
            world.func_175688_a(EnumParticleTypes.REDSTONE, (double)(f + f4), (double)f1, (double)(f2 + f3), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block neighbour) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEngineBase) {
            ((TileEngineBase)tile).onNeighborUpdate();
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return this.createTileEntity(world, metadata);
    }

    public abstract String getUnlocalizedName(int var1);

    public abstract TileEntity createTileEntity(World var1, int var2);

    static {
        EnumMap map = Maps.newEnumMap(EnumFacing.class);
        for (EnumFacing face : EnumFacing.values()) {
            AxisAlignedBB[] array = new AxisAlignedBB[2];
            boolean pos = face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE;
            Vec3 pointA = Utils.withValue(Utils.VEC_ZERO, face.func_176740_k(), pos ? 0.0 : 0.5);
            Vec3 pointB = Utils.withValue(Utils.VEC_ONE, face.func_176740_k(), pos ? 0.5 : 1.0);
            array[0] = Utils.boundingBox(pointA, pointB);
            pointA = Utils.vec3(0.25).func_178787_e(Utils.convert(face, 0.25));
            pointB = pointA.func_178787_e(Utils.VEC_HALF);
            array[1] = Utils.boundingBox(pointA, pointB);
            map.put(face, array);
        }
        boxMap = Maps.immutableEnumMap((Map)map);
    }
}

