/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.config;

import buildcraft.core.lib.config.ExpressionCompiler;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Map;

public class Expression {
    private final ExpressionCompiler.Node node;
    private final double[] variables;
    private final Map<String, Variable> varAccessor;

    public Expression(ExpressionCompiler.Node node, Map<String, Integer> vars) {
        this.node = node;
        this.variables = new double[vars.size()];
        this.varAccessor = Maps.newHashMap();
        for (Map.Entry<String, Integer> entry : vars.entrySet()) {
            this.varAccessor.put(entry.getKey(), new Variable(entry.getValue()));
        }
    }

    public Map<String, Variable> getVariables() {
        return Collections.unmodifiableMap(this.varAccessor);
    }

    public Variable getVariable(String name) {
        return this.varAccessor.get(name);
    }

    public double evaluate() {
        return this.node.evaluate(this.variables);
    }

    public class Variable {
        private final int index;

        private Variable(int index) {
            this.index = index;
        }

        public double get() {
            return Expression.this.variables[this.index];
        }

        public void set(double value) {
            ((Expression)Expression.this).variables[this.index] = value;
        }
    }
}

