/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.sprite;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.BCLog;
import buildcraft.core.lib.fluids.FluidDefinition;
import com.google.common.base.Throwables;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.client.resources.data.TextureMetadataSection;
import net.minecraft.util.ResourceLocation;

public class SpriteColourMapper
extends TextureAtlasSprite {
    private final ResourceLocation from;
    private final int dark;
    private final int light;

    public SpriteColourMapper(FluidDefinition.BCFluid bcFluid, String fluidTextureFrom, boolean still) {
        super(still ? bcFluid.getStill().toString() : bcFluid.getFlowing().toString());
        this.from = new ResourceLocation(fluidTextureFrom);
        this.dark = bcFluid.getDarkColour();
        this.light = bcFluid.getLightColour();
    }

    public SpriteColourMapper(String spriteName, ResourceLocation from, int dark, int light) {
        super(spriteName);
        this.from = from;
        this.dark = dark;
        this.light = light;
    }

    public boolean hasCustomLoader(IResourceManager manager, ResourceLocation location) {
        return true;
    }

    private static int lerp(int[] values) {
        float t = (float)values[0] / 255.0f;
        int l = values[1];
        int u = values[2];
        float v = (1.0f - t) * (float)u + t * (float)l;
        return (int)v & 0xFF;
    }

    private int average(int from) {
        int[] a = new int[]{from >> 24 & 0xFF, this.light >> 24 & 0xFF, this.dark >> 24 & 0xFF};
        int[] b = new int[]{from >> 16 & 0xFF, this.light >> 16 & 0xFF, this.dark >> 16 & 0xFF};
        int[] g = new int[]{from >> 8 & 0xFF, this.light >> 8 & 0xFF, this.dark >> 8 & 0xFF};
        int[] r = new int[]{from & 0xFF, this.light & 0xFF, this.dark & 0xFF};
        return 0xFF000000 | SpriteColourMapper.lerp(b) << 16 | SpriteColourMapper.lerp(g) << 8 | SpriteColourMapper.lerp(r);
    }

    public boolean load(IResourceManager manager, ResourceLocation location) {
        TextureData data = SpriteColourMapper.loadFromManager(manager, this.from);
        BufferedImage[] images = new BufferedImage[1 + Minecraft.func_71410_x().field_71474_y.field_151442_I];
        images[0] = new BufferedImage(data.image.getWidth(), data.image.getHeight(), 6);
        for (int w = 0; w < images[0].getWidth(); ++w) {
            for (int h = 0; h < images[0].getHeight(); ++h) {
                int rgba = data.image.getRGB(w, h);
                images[0].setRGB(w, h, this.average(rgba));
            }
        }
        SpriteColourMapper.output(data.image, location.toString().replace("/", "__") + "_from");
        SpriteColourMapper.output(images[0], location.toString().replace("/", "__") + "_to");
        try {
            super.func_180598_a(images, data.animationMeta);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        return false;
    }

    private static void output(BufferedImage bufferedImage, String string) {
        if (BuildCraftCore.DEVELOPER_MODE) {
            File loc = new File("./bc-tex/");
            loc = new File(loc.getAbsolutePath());
            loc.mkdir();
            loc = new File(loc, string + ".png");
            try {
                ImageIO.write((RenderedImage)bufferedImage, "png", loc);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private static ResourceLocation completeResourceLocation(ResourceLocation location) {
        return new ResourceLocation(location.func_110624_b(), "textures/" + location.func_110623_a() + ".png");
    }

    private static TextureData loadFromManager(IResourceManager manager, ResourceLocation location) {
        try {
            IResource iresource = manager.func_110536_a(SpriteColourMapper.completeResourceLocation(location));
            TextureData data = new TextureData();
            data.image = TextureUtil.func_177053_a((InputStream)iresource.func_110527_b());
            data.textureMeta = (TextureMetadataSection)iresource.func_110526_a("texture");
            data.animationMeta = (AnimationMetadataSection)iresource.func_110526_a("animation");
            return data;
        }
        catch (Throwable t) {
            BCLog.logger.warn("[SpriteColourMapper] Could not find " + location);
            return SpriteColourMapper.missingTex(16, 16);
        }
    }

    private static TextureData missingTex(int width, int height) {
        TextureData tex = new TextureData();
        tex.image = new BufferedImage(width, height, 6);
        int yellow = -256;
        int black = -16777216;
        int[][] c = new int[][]{{yellow, black, -1}, {black, yellow, -1}, {-1, -1, -1}};
        for (int w = 0; w < width; ++w) {
            for (int h = 0; h < height; ++h) {
                tex.image.setRGB(w, h, c[w * 2 / width][h * 2 / height]);
            }
        }
        return tex;
    }

    private static class TextureData {
        BufferedImage image;
        TextureMetadataSection textureMeta;
        AnimationMetadataSection animationMeta;

        private TextureData() {
        }
    }
}

