/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.render;

import buildcraft.core.lib.EntityResizableCuboid;
import buildcraft.core.lib.client.render.RenderResizableCuboid;
import buildcraft.core.lib.client.render.RenderUtils;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public final class FluidRenderer {
    public static final FluidRenderer INSTANCE = new FluidRenderer();
    public static final int DISPLAY_STAGES = 100;
    public static final Vec3 BLOCK_SIZE = new Vec3(0.98, 0.98, 0.98);
    private final Map<Fluid, Map<Vec3, int[]>> flowingRenderCache = Maps.newHashMap();
    private final Map<Fluid, Map<Vec3, int[]>> stillRenderCache = Maps.newHashMap();
    private final Map<Fluid, Map<Vec3, int[]>> frozenRenderCache = Maps.newHashMap();
    private final Map<FluidType, Map<Fluid, TextureAtlasSprite>> textureMap = Maps.newHashMap();
    private static TextureAtlasSprite missingIcon = null;

    private FluidRenderer() {
    }

    @SubscribeEvent
    public void modelBakeEvent(ModelBakeEvent event) {
        this.flowingRenderCache.clear();
        this.stillRenderCache.clear();
        this.frozenRenderCache.clear();
    }

    @SubscribeEvent
    public void textureStitchPost(TextureStitchEvent.Post event) {
        this.flowingRenderCache.clear();
        this.stillRenderCache.clear();
        this.frozenRenderCache.clear();
        TextureMap map = event.map;
        missingIcon = map.func_174944_f();
        this.textureMap.clear();
        for (FluidType type : FluidType.values()) {
            this.textureMap.put(type, new HashMap());
        }
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            TextureAtlasSprite sprite;
            if (fluid.getFlowing() != null) {
                String flow = fluid.getFlowing().toString();
                sprite = map.getTextureExtry(flow) != null ? map.getTextureExtry(flow) : map.func_174942_a(fluid.getFlowing());
                this.textureMap.get((Object)FluidType.FLOWING).put(fluid, sprite);
            }
            if (fluid.getStill() == null) continue;
            String still = fluid.getStill().toString();
            sprite = map.getTextureExtry(still) != null ? map.getTextureExtry(still) : map.func_174942_a(fluid.getStill());
            this.textureMap.get((Object)FluidType.STILL).put(fluid, sprite);
        }
    }

    public static TextureAtlasSprite getFluidTexture(FluidStack stack, FluidType type) {
        if (stack == null) {
            return missingIcon;
        }
        return FluidRenderer.getFluidTexture(stack.getFluid(), type);
    }

    public static TextureAtlasSprite getFluidTexture(Fluid fluid, FluidType type) {
        if (fluid == null || type == null) {
            return missingIcon;
        }
        Map<Fluid, TextureAtlasSprite> map = FluidRenderer.INSTANCE.textureMap.get((Object)type);
        return map.containsKey(fluid) ? map.get(fluid) : missingIcon;
    }

    public static void setColorForFluidStack(FluidStack fluidstack) {
        if (fluidstack == null) {
            return;
        }
        int color = fluidstack.getFluid().getColor(fluidstack);
        RenderUtils.setGLColorFromInt(color);
    }

    public static int[] getFluidDisplayListForSide(FluidStack fluidStack, FluidType type, Vec3 size, EnumFacing side) {
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        int[] lists = new int[100];
        for (int s = 0; s < 100; ++s) {
            lists[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)lists[s], (int)4864);
            EntityResizableCuboid ent = new EntityResizableCuboid(null);
            ent.xSize = size.field_72450_a;
            ent.ySize = (double)((float)Math.max(s, 1) / 100.0f) * size.field_72448_b;
            ent.zSize = size.field_72449_c;
            ent.texture = FluidRenderer.getFluidTexture(fluidStack, type);
            ent.makeClient();
            Arrays.fill(ent.textures, null);
            ent.textures[side.ordinal()] = ent.texture;
            RenderResizableCuboid.INSTANCE.renderCube(ent);
            GL11.glEndList();
        }
        return lists;
    }

    public static int[] getFluidDisplayLists(FluidStack fluidStack, FluidType type, Vec3 size) {
        int[] displayList;
        if (fluidStack == null) {
            return null;
        }
        Fluid fluid = fluidStack.getFluid();
        if (fluid == null) {
            return null;
        }
        Map<Fluid, Map<Vec3, int[]>> cache = type == FluidType.FLOWING ? FluidRenderer.INSTANCE.flowingRenderCache : (type == FluidType.STILL ? FluidRenderer.INSTANCE.stillRenderCache : FluidRenderer.INSTANCE.frozenRenderCache);
        HashMap displayLists = cache.get(fluid);
        if (displayLists != null) {
            displayList = (int[])displayLists.get(size);
            if (displayList != null) {
                return displayList;
            }
        } else {
            displayLists = Maps.newHashMap();
            cache.put(fluid, displayLists);
        }
        displayList = new int[100];
        cache.put(fluid, displayLists);
        for (int s = 0; s < 100; ++s) {
            displayList[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)displayList[s], (int)4864);
            EntityResizableCuboid ent = new EntityResizableCuboid(null);
            ent.xSize = size.field_72450_a;
            ent.ySize = (double)((float)Math.max(s, 1) / 100.0f) * size.field_72448_b;
            ent.zSize = size.field_72449_c;
            ent.texture = FluidRenderer.getFluidTexture(fluidStack, type);
            RenderResizableCuboid.INSTANCE.renderCube(ent, true, false);
            GL11.glEndList();
        }
        displayLists.put(size, displayList);
        return displayList;
    }

    public static enum FluidType {
        FLOWING,
        STILL,
        FROZEN;

    }
}

