/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.core.lib.client.model.IModelCache;
import buildcraft.core.lib.client.model.ModelCache;
import buildcraft.core.lib.client.model.MutableQuad;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class ModelCacheMultipleSame<K, T>
implements IModelCache<K> {
    private final IModelCache<K> mainCache;
    private final IModelKeyMultipleSameMapper<K, T> mapper;
    private final IModelCache<T> seperateCache;

    public ModelCacheMultipleSame(String mainName, IModelKeyMultipleSameMapper<K, T> mapper, IModelCache<T> seperateCache) {
        this.mainCache = new ModelCache<Object>(mainName, this::load);
        this.mapper = mapper;
        this.seperateCache = seperateCache;
    }

    private List<MutableQuad> load(K key) {
        ArrayList<MutableQuad> quads = new ArrayList<MutableQuad>();
        for (T to : this.mapper.map(key)) {
            this.seperateCache.appendAsMutable(to, quads);
        }
        return quads;
    }

    @Override
    public void appendAsMutable(K key, List<MutableQuad> quads) {
        this.mainCache.appendAsMutable(key, quads);
    }

    @Override
    public ImmutableList<BakedQuad> bake(K key, VertexFormat format) {
        return this.mainCache.bake(key, format);
    }

    @Override
    public void render(K key, WorldRenderer wr) {
        this.mainCache.render(key, wr);
    }

    @Override
    public void renderDisplayList(K key) {
        for (T to : this.mapper.map(key)) {
            this.seperateCache.renderDisplayList(to);
        }
    }

    public static interface IModelKeyMultipleSameMapper<F, T> {
        public Collection<T> map(F var1);
    }
}

