/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.core.lib.client.model.IModelCache;
import buildcraft.core.lib.client.model.ModelCache;
import buildcraft.core.lib.client.model.MutableQuad;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;

public class ModelCacheJoiner<K>
implements IModelCache<K> {
    private final IModelCache<K> mainCache;
    private final ImmutableList<ModelKeyWrapper<K, ?>> modelKeyWrappers;

    public ModelCacheJoiner(String mainName, List<ModelKeyWrapper<K, ?>> wrappers) {
        this.modelKeyWrappers = ImmutableList.copyOf(wrappers);
        this.mainCache = new ModelCache<Object>(mainName, this::load);
    }

    private List<MutableQuad> load(K key) {
        ArrayList<MutableQuad> quads = new ArrayList<MutableQuad>();
        for (ModelKeyWrapper wrapper : this.modelKeyWrappers) {
            wrapper.appendQuads(key, quads);
        }
        return quads;
    }

    @Override
    public void appendAsMutable(K key, List<MutableQuad> quads) {
        this.mainCache.appendAsMutable(key, quads);
    }

    @Override
    public ImmutableList<BakedQuad> bake(K key, VertexFormat format) {
        return this.mainCache.bake(key, format);
    }

    @Override
    public void render(K key, WorldRenderer wr) {
        this.mainCache.render(key, wr);
    }

    @Override
    public void renderDisplayList(K key) {
        for (ModelKeyWrapper wrapper : this.modelKeyWrappers) {
            wrapper.renderDisplayList(key);
        }
    }

    public static interface IModelKeyMapper<F, T> {
        public T getInternKey(F var1);
    }

    public static class ModelKeyWrapper<K, T> {
        private final IModelKeyMapper<K, T> mapper;
        private final IModelCache<T> cache;

        public ModelKeyWrapper(String detailedName, IModelKeyMapper<K, T> mapper, ModelCache.IModelGenerator<T> generator) {
            this.mapper = mapper;
            this.cache = new ModelCache<T>(detailedName, generator);
        }

        public ModelKeyWrapper(IModelKeyMapper<K, T> mapper, IModelCache<T> cache) {
            this.mapper = mapper;
            this.cache = cache;
        }

        public void appendQuads(K key, List<MutableQuad> quads) {
            this.cache.appendAsMutable(this.mapper.getInternKey(key), quads);
        }

        public void renderDisplayList(K key) {
            this.cache.renderDisplayList(this.mapper.getInternKey(key));
        }
    }
}

