/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.client.model;

import buildcraft.core.lib.client.model.MutableQuad;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.util.EnumFacing;

public class BCModelHelper {
    public static final int U_MIN = 0;
    public static final int U_MAX = 1;
    public static final int V_MIN = 2;
    public static final int V_MAX = 3;
    public static final int X = 0;
    public static final int Y = 1;
    public static final int Z = 2;
    public static final int SHADE = 3;
    public static final int U = 4;
    public static final int V = 5;
    public static final int UNUSED = 6;
    public static final int ARRAY_SIZE = 7;

    public static MutableQuad createFace(EnumFacing face, Tuple3f a, Tuple3f b, Tuple3f c, Tuple3f d, float[] uvs) {
        MutableQuad mutable = new MutableQuad(-1, face);
        if (face == null || BCModelHelper.shouldInvertForRender(face)) {
            mutable.getVertex(0).positionv(a).texf(uvs[0], uvs[2]);
            mutable.getVertex(1).positionv(b).texf(uvs[0], uvs[3]);
            mutable.getVertex(2).positionv(c).texf(uvs[1], uvs[3]);
            mutable.getVertex(3).positionv(d).texf(uvs[1], uvs[2]);
        } else {
            mutable.getVertex(3).positionv(a).texf(uvs[0], uvs[2]);
            mutable.getVertex(2).positionv(b).texf(uvs[0], uvs[3]);
            mutable.getVertex(1).positionv(c).texf(uvs[1], uvs[3]);
            mutable.getVertex(0).positionv(d).texf(uvs[1], uvs[2]);
        }
        return mutable;
    }

    public static <T extends Tuple3f> MutableQuad createFace(EnumFacing face, T[] points, float[] uvs) {
        return BCModelHelper.createFace(face, points[0], points[1], points[2], points[3], uvs);
    }

    public static MutableQuad createFace(EnumFacing face, Tuple3f center, Tuple3f radius, float[] uvs) {
        Point3f[] points = BCModelHelper.getPointsForFace(face, center, radius);
        return BCModelHelper.createFace((EnumFacing)face, (Tuple3f[])points, (float[])uvs);
    }

    public static MutableQuad createInverseFace(EnumFacing face, Tuple3f center, Tuple3f radius, float[] uvs) {
        return BCModelHelper.createFace(face, center, radius, uvs).invertNormal();
    }

    public static MutableQuad[] createDoubleFace(EnumFacing face, Tuple3f center, Tuple3f radius, float[] uvs) {
        MutableQuad norm = BCModelHelper.createFace(face, center, radius, uvs);
        return new MutableQuad[]{norm, new MutableQuad(norm).invertNormal()};
    }

    public static List<MutableQuad> toMutableQuadList(IBakedModel model, boolean includeFaces) {
        ArrayList<MutableQuad> quads = new ArrayList<MutableQuad>();
        for (BakedQuad q : model.func_177550_a()) {
            quads.add(MutableQuad.create(q));
        }
        if (includeFaces) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                for (BakedQuad q : model.func_177551_a(facing)) {
                    quads.add(MutableQuad.create(q));
                }
            }
        }
        return quads;
    }

    public static void appendQuads(List<MutableQuad> to, MutableQuad ... from) {
        for (MutableQuad q : from) {
            to.add(q);
        }
    }

    public static void appendBakeQuads(List<BakedQuad> to, MutableQuad ... from) {
        for (MutableQuad q : from) {
            to.add((BakedQuad)q.toUnpacked());
        }
    }

    public static void appendBakeQuads(List<BakedQuad> to, VertexFormat format, MutableQuad ... from) {
        for (MutableQuad q : from) {
            to.add((BakedQuad)q.toUnpacked(format));
        }
    }

    public static void appendBakeQuads(List<BakedQuad> to, Collection<MutableQuad> from) {
        for (MutableQuad q : from) {
            to.add((BakedQuad)q.toUnpacked());
        }
    }

    public static List<BakedQuad> bakeList(List<MutableQuad> from) {
        ArrayList<BakedQuad> to = new ArrayList<BakedQuad>();
        BCModelHelper.appendBakeQuads(to, from);
        return to;
    }

    public static Point3f[] getPointsForFace(EnumFacing face, Tuple3f center, Tuple3f radius) {
        Point3f centerOfFace = new Point3f(center);
        Point3f faceAdd = new Point3f((float)face.func_82601_c() * radius.x, (float)face.func_96559_d() * radius.y, (float)face.func_82599_e() * radius.z);
        centerOfFace.add((Tuple3f)faceAdd);
        Vector3f faceRadius = new Vector3f(radius);
        if (face.func_176743_c() == EnumFacing.AxisDirection.POSITIVE) {
            faceRadius.sub((Tuple3f)faceAdd);
        } else {
            faceRadius.add((Tuple3f)faceAdd);
        }
        return BCModelHelper.getPoints(centerOfFace, (Tuple3f)faceRadius);
    }

    public static Point3f[] getPoints(Point3f centerFace, Tuple3f faceRadius) {
        Point3f[] array = new Point3f[]{new Point3f(centerFace), new Point3f(centerFace), new Point3f(centerFace), new Point3f(centerFace)};
        array[0].add((Tuple3f)BCModelHelper.addOrNegate(faceRadius, false, false));
        array[1].add((Tuple3f)BCModelHelper.addOrNegate(faceRadius, false, true));
        array[2].add((Tuple3f)BCModelHelper.addOrNegate(faceRadius, true, true));
        array[3].add((Tuple3f)BCModelHelper.addOrNegate(faceRadius, true, false));
        return array;
    }

    public static Vector3f addOrNegate(Tuple3f coord, boolean u, boolean v) {
        boolean zisv = coord.x != 0.0f && coord.y == 0.0f;
        float x = coord.x * (float)(u ? 1 : -1);
        float y = coord.y * (float)(v ? -1 : 1);
        float z = coord.z * (float)(zisv ? (v ? -1 : 1) : (u ? 1 : -1));
        Vector3f neg = new Vector3f(x, y, z);
        return neg;
    }

    public static boolean shouldInvertForRender(EnumFacing face) {
        boolean flip;
        boolean bl = flip = face.func_176743_c() == EnumFacing.AxisDirection.NEGATIVE;
        if (face.func_176740_k() == EnumFacing.Axis.Z) {
            flip = !flip;
        }
        return flip;
    }

    public static EnumFacing faceForRender(EnumFacing face) {
        if (BCModelHelper.shouldInvertForRender(face)) {
            return face.func_176734_d();
        }
        return face;
    }
}

