/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.block;

import buildcraft.api.core.IInvSlot;
import buildcraft.api.events.BlockInteractionEvent;
import buildcraft.api.events.BlockPlacedDownEvent;
import buildcraft.api.properties.BuildCraftProperty;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.lib.block.BlockBuildCraftBase;
import buildcraft.core.lib.block.IComparatorInventory;
import buildcraft.core.lib.block.TileBuildCraft;
import buildcraft.core.lib.inventory.InventoryIterator;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.lib.utils.XorShift128Random;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;

public abstract class BlockBuildCraft
extends BlockBuildCraftBase
implements ITileEntityProvider {
    protected static boolean keepInventory = false;
    protected final XorShift128Random rand = new XorShift128Random();
    private final boolean hasPowerLed = this.propertyList.contains((Object)LED_POWER);
    private final boolean hasDoneLed = this.propertyList.contains((Object)LED_DONE);

    protected BlockBuildCraft(Material material) {
        this(material, BCCreativeTab.get("main"), new BuildCraftProperty[0]);
    }

    protected BlockBuildCraft(Material material, BCCreativeTab creativeTab) {
        this(material, creativeTab, new BuildCraftProperty[0]);
    }

    protected BlockBuildCraft(Material material, BuildCraftProperty<?> ... properties) {
        this(material, BCCreativeTab.get("main"), properties);
    }

    protected BlockBuildCraft(Material material, BCCreativeTab bcCreativeTab, BuildCraftProperty<?> ... properties) {
        this(material, bcCreativeTab, false, properties);
    }

    protected BlockBuildCraft(Material material, BCCreativeTab bcCreativeTab, boolean hasExtended, BuildCraftProperty<?> ... properties) {
        super(material, bcCreativeTab, hasExtended, properties);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        if (!this.hasPowerLed || !this.hasDoneLed) {
            return state;
        }
        TileEntity tile = access.func_175625_s(pos);
        if (!(tile instanceof TileBuildCraft)) {
            return state;
        }
        TileBuildCraft tileBC = (TileBuildCraft)tile;
        if (this.hasPowerLed) {
            state = state.func_177226_a((IProperty)LED_POWER, (Comparable)Integer.valueOf(tileBC.ledPower));
        }
        if (this.hasDoneLed) {
            state = state.func_177226_a((IProperty)LED_DONE, (Comparable)Boolean.valueOf(tileBC.ledDone));
        }
        return state;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entity, ItemStack stack) {
        super.func_180633_a(world, pos, state, entity, stack);
        MinecraftForge.EVENT_BUS.post((Event)new BlockPlacedDownEvent((EntityPlayer)entity, pos, state));
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileBuildCraft) {
            ((TileBuildCraft)tile).onBlockPlacedBy(entity, stack);
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        BlockInteractionEvent event = new BlockInteractionEvent(player, state);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.isCanceled();
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Utils.preDestroyBlock(world, pos);
        super.func_180663_b(world, pos, state);
    }

    public int getLightValue(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IHasWork && ((IHasWork)tile).hasWork()) {
            return super.getLightValue(world, pos) + 8;
        }
        return super.getLightValue(world, pos);
    }

    public boolean func_149740_M() {
        return this instanceof IComparatorInventory;
    }

    public int func_180641_l(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof IInventory) {
            int count = 0;
            int countNonEmpty = 0;
            float power = 0.0f;
            for (EnumFacing face : EnumFacing.values()) {
                for (IInvSlot slot : InventoryIterator.getIterable((IInventory)tile, face)) {
                    if (!((IComparatorInventory)((Object)this)).doesSlotCountComparator(tile, slot.getIndex(), slot.getStackInSlot())) continue;
                    ++count;
                    if (slot.getStackInSlot() == null) continue;
                    ++countNonEmpty;
                    power += (float)slot.getStackInSlot().field_77994_a / (float)Math.min(((IInventory)tile).func_70297_j_(), slot.getStackInSlot().func_77976_d());
                }
            }
            return MathHelper.func_76141_d((float)((power /= (float)count) * 14.0f)) + (countNonEmpty > 0 ? 1 : 0);
        }
        return 0;
    }
}

