/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.config;

import buildcraft.BuildCraftMod;
import buildcraft.core.config.BCConfigElement;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.IModGuiFactory;
import net.minecraftforge.fml.client.config.GuiConfig;

public class ConfigManager
implements IModGuiFactory {
    public static Configuration config;
    private final BuildCraftMod mod;

    public ConfigManager() {
        this.mod = null;
    }

    public ConfigManager(Configuration c, BuildCraftMod mod) {
        config = c;
        this.mod = mod;
    }

    public ConfigCategory getCat(String name) {
        return config.getCategory(name);
    }

    public Property get(String iName) {
        int sep = iName.lastIndexOf(".");
        return this.get(iName.substring(0, sep), iName.substring(sep + 1));
    }

    public Property get(String catName, String propName) {
        ConfigCategory c = config.getCategory(catName);
        return c.get(propName);
    }

    private Property create(String s, Object o) {
        Property p;
        if (o instanceof Integer) {
            p = new Property(s, o.toString(), Property.Type.INTEGER);
        } else if (o instanceof String) {
            p = new Property(s, (String)o, Property.Type.STRING);
        } else if (o instanceof Double || o instanceof Float) {
            p = new Property(s, o.toString(), Property.Type.DOUBLE);
        } else if (o instanceof Boolean) {
            p = new Property(s, o.toString(), Property.Type.BOOLEAN);
        } else if (o instanceof String[]) {
            p = new Property(s, (String[])o, Property.Type.STRING);
        } else {
            return null;
        }
        return p;
    }

    public Property register(String catName, String propName, Object property, String comment, RestartRequirement restartRequirement) {
        Property p;
        ConfigCategory c;
        ConfigCategory parent = c = config.getCategory(catName);
        while (parent != null) {
            parent.setLanguageKey("config." + parent.getQualifiedName());
            parent = parent.parent;
        }
        if (c.get(propName) != null) {
            p = c.get(propName);
        } else {
            p = this.create(propName, property);
            c.put(propName, p);
        }
        p.comment = comment;
        RestartRequirement r = restartRequirement;
        p.setLanguageKey("config." + catName + "." + propName);
        p.setRequiresWorldRestart(r == RestartRequirement.WORLD);
        p.setRequiresMcRestart(r == RestartRequirement.GAME);
        this.mod.putOption(catName + "." + propName, p);
        return p;
    }

    public Property register(String name, Object property, String comment, RestartRequirement restartRequirement) {
        String prefix = name.substring(0, name.lastIndexOf("."));
        String suffix = name.substring(name.lastIndexOf(".") + 1);
        return this.register(prefix, suffix, property, comment, restartRequirement);
    }

    public void initialize(Minecraft minecraftInstance) {
    }

    public Class<? extends GuiScreen> mainConfigGuiClass() {
        return GuiConfigManager.class;
    }

    public Set<IModGuiFactory.RuntimeOptionCategoryElement> runtimeGuiCategories() {
        return null;
    }

    public IModGuiFactory.RuntimeOptionGuiHandler getHandlerFor(IModGuiFactory.RuntimeOptionCategoryElement element) {
        return null;
    }

    public static enum RestartRequirement {
        NONE,
        WORLD,
        GAME;

    }

    public static class GuiConfigManager
    extends GuiConfig {
        public GuiConfigManager(GuiScreen parentScreen) {
            super(parentScreen, new ArrayList(), "BuildCraft|Core", "config", false, false, I18n.func_135052_a((String)"config.buildcraft", (Object[])new Object[0]));
            for (String s : config.getCategoryNames()) {
                if (s.contains(".")) continue;
                this.configElements.add(new BCConfigElement(config.getCategory(s)));
            }
        }
    }
}

