/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.client;

import buildcraft.api.tiles.IControllable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;

public enum CoreIconProvider {
    ENERGY("buildcraftcore:items/icons/energy"),
    SLOT("buildcraftcore:gui/slot"),
    LOCK("buildcraftcore:items/icons/lock"),
    TURNED_OFF("buildcraftcore:triggers/action_machinecontrol_off"),
    LOOPING("buildcraftcore:triggers/action_machinecontrol_loop");

    private final ResourceLocation location;
    private TextureAtlasSprite sprite;

    private CoreIconProvider(String location) {
        this.location = new ResourceLocation(location);
    }

    public static void registerSprites(TextureMap map) {
        for (CoreIconProvider icon : CoreIconProvider.values()) {
            icon.registerSprite(map);
        }
    }

    private void registerSprite(TextureMap map) {
        this.sprite = null;
        this.sprite = map.getTextureExtry(this.location.toString());
        if (this.sprite == null) {
            this.sprite = map.func_174942_a(this.location);
        }
    }

    public TextureAtlasSprite getSprite() {
        return this.sprite;
    }

    public static CoreIconProvider getForControlMode(IControllable.Mode mode) {
        if (mode == IControllable.Mode.Off) {
            return TURNED_OFF;
        }
        if (mode == IControllable.Mode.Loop) {
            return LOOPING;
        }
        return null;
    }
}

