/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders.patterns;

import buildcraft.api.blueprints.SchematicMask;
import buildcraft.api.enums.EnumFillerPattern;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.blueprints.Template;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.lib.utils.Utils;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class PatternHorizon
extends FillerPattern {
    public PatternHorizon() {
        super("horizon", EnumFillerPattern.HORIZON);
    }

    @Override
    public Template getTemplate(Box box, World world, IStatementParameter[] parameters) {
        int xMin = box.min().func_177958_n();
        int yMin = box.min().func_177956_o() > 0 ? box.min().func_177956_o() - 1 : 0;
        int zMin = box.min().func_177952_p();
        int xMax = box.max().func_177958_n();
        int yMax = world.func_72940_L();
        int zMax = box.max().func_177952_p();
        Template bpt = new Template(Utils.withValue(box.size(), EnumFacing.Axis.Y, yMax - yMin));
        if (box.size().func_177956_o() > 0) {
            for (int x = xMin; x <= xMax; ++x) {
                for (int z = zMin; z <= zMax; ++z) {
                    bpt.set(new BlockPos(x - xMin, 0, z - zMin), new SchematicMask(true));
                }
            }
        }
        return bpt;
    }

    @Override
    public BptBuilderTemplate getTemplateBuilder(Box box, World world, IStatementParameter[] parameters) {
        int yMin = box.min().func_177956_o() > 0 ? box.min().func_177956_o() - 1 : 0;
        return new BptBuilderTemplate(this.getTemplate(box, world, parameters), world, new BlockPos(box.min().func_177958_n(), yMin, box.min().func_177952_p()));
    }
}

