/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicEntity;
import buildcraft.api.blueprints.SchematicFactory;
import buildcraft.core.builders.BuildingSlot;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Vec3;

public class BuildingSlotEntity
extends BuildingSlot {
    public SchematicEntity schematic;
    public int sequenceNumber;

    @Override
    public boolean writeToWorld(IBuilderContext context) {
        this.schematic.writeToWorld(context);
        return true;
    }

    @Override
    public Vec3 getDestination() {
        NBTTagList nbttaglist = this.schematic.entityNBT.func_150295_c("Pos", 6);
        Vec3 pos = new Vec3(nbttaglist.func_150309_d(0), nbttaglist.func_150309_d(1), nbttaglist.func_150309_d(2));
        return pos;
    }

    public LinkedList<ItemStack> getRequirements(IBuilderContext context) {
        LinkedList<ItemStack> results = new LinkedList<ItemStack>();
        Collections.addAll(results, this.schematic.storedRequirements);
        return results;
    }

    @Override
    public SchematicEntity getSchematic() {
        return this.schematic;
    }

    @Override
    public boolean isAlreadyBuilt(IBuilderContext context) {
        return this.schematic.isAlreadyBuilt(context);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, MappingRegistry registry) {
        NBTTagCompound schematicNBT = new NBTTagCompound();
        SchematicFactory.getFactory(this.schematic.getClass()).saveSchematicToWorldNBT(schematicNBT, this.schematic, registry);
        nbt.func_74782_a("schematic", (NBTBase)schematicNBT);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, MappingRegistry registry) throws MappingNotFoundException {
        this.schematic = (SchematicEntity)SchematicFactory.createSchematicFromWorldNBT(nbt.func_74775_l("schematic"), registry);
    }

    @Override
    public int getEnergyRequirement() {
        return this.schematic.getEnergyRequirement(this.stackConsumed);
    }

    @Override
    public int buildTime() {
        return this.schematic.buildTime();
    }
}

