/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.builders;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingNotFoundException;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.Schematic;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public abstract class BuildingSlot {
    public List<ItemStack> stackConsumed;
    public boolean reserved = false;
    public boolean built = false;

    public boolean writeToWorld(IBuilderContext context) {
        return false;
    }

    public void writeCompleted(IBuilderContext context, double complete) {
    }

    public void postProcessing(IBuilderContext context) {
    }

    public List<ItemStack> getRequirements(IBuilderContext context) {
        return new ArrayList<ItemStack>();
    }

    public abstract Vec3 getDestination();

    public void addStackConsumed(ItemStack stack) {
        if (this.stackConsumed == null) {
            this.stackConsumed = new LinkedList<ItemStack>();
        }
        this.stackConsumed.add(stack);
    }

    public List<ItemStack> getStacksToDisplay() {
        return this.getSchematic().getStacksToDisplay(this.stackConsumed);
    }

    public abstract boolean isAlreadyBuilt(IBuilderContext var1);

    public abstract Schematic getSchematic();

    public abstract void writeToNBT(NBTTagCompound var1, MappingRegistry var2);

    public abstract void readFromNBT(NBTTagCompound var1, MappingRegistry var2) throws MappingNotFoundException;

    public abstract int getEnergyRequirement();

    public abstract int buildTime();
}

