/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints.iterator;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.iterator.BuildRequirement;
import buildcraft.core.blueprints.iterator.BuildingSlotPostProcess;
import buildcraft.core.blueprints.iterator.IBptBuilder;
import buildcraft.core.builders.BuildingSlot;
import buildcraft.core.builders.BuildingSlotEntity;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;

public class BptBuilderOrdered
implements IBptBuilder {
    private final BlueprintBase blueprint;
    private final IBuilderContext context;
    private final BlockPos worldOffset;
    private final Box worldOperatingBox;
    private final Utils.AxisOrder order;
    private boolean hasInitBlocks = false;
    private boolean hasInitEntities = false;
    private BlockPos initPos;
    private Utils.BoxIterator iterator;
    private BuildRequirement[][][] clearRequirements;
    private Map<BlockPos, BuildRequirement> reservedRequirements = Maps.newHashMap();
    private Map<BlockPos, BuildingSlotPostProcess> postProcessing = Maps.newHashMap();
    private Multimap<BlockPos, BuildingSlotEntity> entities = HashMultimap.create();
    private boolean hasFinishedBuilding = false;

    public BptBuilderOrdered(BlueprintBase blueprint, BlockPos worldOffset, IBuilderContext context, Utils.AxisOrder order) {
        this.blueprint = blueprint;
        this.worldOffset = worldOffset;
        this.context = context;
        this.order = order;
        this.worldOperatingBox = new Box(worldOffset, worldOffset.func_177971_a((Vec3i)blueprint.size.func_177973_b((Vec3i)Utils.POS_ONE)));
    }

    @Override
    public BptBuilderOrdered readFromNBT(NBTBase nbt) {
        BptBuilderOrdered builder = new BptBuilderOrdered(this.blueprint, this.worldOffset, this.context, this.order);
        return builder;
    }

    @Override
    public NBTTagCompound writeToNBT() {
        return null;
    }

    @Override
    public Box operatingBox() {
        return this.worldOperatingBox;
    }

    @Override
    public void recheckBlock(BlockPos pos) {
        if (!this.worldOperatingBox.contains(pos)) {
            return;
        }
        BlockPos blueprintPos = pos.func_177973_b((Vec3i)this.worldOffset);
        SchematicBlockBase schematic = this.blueprint.get(blueprintPos);
        if (schematic != null) {
            if (schematic.isAlreadyBuilt(this.context, blueprintPos)) {
                return;
            }
            if (this.reservedRequirements.get(pos) != null) {
                return;
            }
            if (this.clearRequirements[blueprintPos.func_177958_n()][blueprintPos.func_177956_o()][blueprintPos.func_177952_p()] != null) {
                BuildRequirement req = this.clearRequirements[blueprintPos.func_177958_n()][blueprintPos.func_177956_o()][blueprintPos.func_177952_p()];
                req.updateFor(schematic, this.context, pos);
            } else {
                BuildRequirement req = new BuildRequirement();
                req.updateFor(schematic, this.context, pos);
                this.clearRequirements[blueprintPos.func_177958_n()][blueprintPos.func_177956_o()][blueprintPos.func_177952_p()] = req;
            }
        }
    }

    protected void internalInit() {
        if (!this.hasInitBlocks) {
            if (!this.iterator.hasNext()) {
                this.hasInitBlocks = true;
            } else {
                BlockPos next = (BlockPos)this.iterator.next();
                this.recheckBlock(next);
            }
        } else if (!this.hasInitEntities) {
            this.hasInitEntities = true;
        }
    }

    @Override
    public double iterateInit(long us) {
        if (this.hasInitBlocks && this.hasInitEntities) {
            return -1.0;
        }
        if (this.initPos == null || this.iterator == null) {
            this.initPos = this.worldOffset;
            this.iterator = new Utils.BoxIterator(this.worldOffset, this.blueprint.size.func_177973_b((Vec3i)Utils.POS_ONE), Utils.EnumAxisOrder.XZY.defaultOrder);
            this.clearRequirements = new BuildRequirement[this.blueprint.size.func_177958_n()][this.blueprint.size.func_177956_o()][this.blueprint.size.func_177952_p()];
        }
        long start = System.nanoTime() / 1000L;
        do {
            for (int i = 0; i < 64; ++i) {
                this.internalInit();
            }
        } while (System.nanoTime() / 1000L - start < us);
        return 1.0;
    }

    @Override
    public boolean hasInit() {
        return this.hasInitBlocks && this.hasInitEntities;
    }

    @Override
    public void tick() {
        BuildRequirement req;
        HashSet finished = Sets.newHashSet();
        for (Map.Entry<BlockPos, BuildRequirement> entry : this.reservedRequirements.entrySet()) {
            req = entry.getValue();
            if (!req.hasBuilt()) continue;
            finished.add(entry.getKey());
        }
        for (BlockPos pos : finished) {
            req = this.reservedRequirements.remove(pos);
            this.postProcessing.put(pos, req.forPostProcess());
        }
    }

    @Override
    public BuildingSlot getNextSlot(BlockPos closestToHint) {
        if (!this.iterator.hasNext()) {
            return null;
        }
        while (this.iterator.hasNext()) {
            BlockPos next = (BlockPos)this.iterator.next();
            BuildRequirement req = this.clearRequirements[next.func_177958_n()][next.func_177956_o()][next.func_177952_p()];
            if (req == null) continue;
            return req.getSlot();
        }
        return null;
    }

    @Override
    public void reserveSlot(BuildingSlot toReserve) {
    }

    @Override
    public void unreserveSlot(BuildingSlot used) {
    }

    @Override
    public int reservedSlotCount() {
        return this.reservedRequirements.size();
    }

    @Override
    public boolean hasFinishedBuilding() {
        return false;
    }
}

