/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.SchematicBlock;
import buildcraft.core.builders.BuildingSlotBlock;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Set;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;

public class IndexRequirementMap {
    private final Multimap<BlockPos, BlockPos> requirements = HashMultimap.create();
    private final Multimap<BlockPos, BlockPos> requirementsInv = HashMultimap.create();

    public void add(BuildingSlotBlock b, IBuilderContext context) {
        if (b.schematic instanceof SchematicBlock) {
            BlockPos index = b.pos;
            Set<BlockPos> prereqs = ((SchematicBlock)b.schematic).getPrerequisiteBlocks(context);
            if (prereqs != null && prereqs.size() > 0) {
                for (BlockPos i : prereqs) {
                    BlockPos ia = i.func_177971_a((Vec3i)index);
                    if (ia.equals((Object)index) || !context.surroundingBox().contains(Utils.convert((Vec3i)ia))) continue;
                    this.requirements.put((Object)index, (Object)ia);
                    this.requirementsInv.put((Object)ia, (Object)index);
                }
            }
        }
    }

    public boolean contains(BlockPos index) {
        return this.requirements.containsKey((Object)index);
    }

    public void remove(BuildingSlotBlock b) {
        this.remove(b.pos);
    }

    public void remove(BlockPos index) {
        for (BlockPos reqingIndex : this.requirementsInv.get((Object)index)) {
            this.requirements.remove((Object)reqingIndex, (Object)index);
        }
        this.requirementsInv.removeAll((Object)index);
    }
}

