/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.blueprints;

import buildcraft.api.blueprints.BuildingPermission;
import buildcraft.api.blueprints.IBuilderContext;
import buildcraft.api.blueprints.MappingRegistry;
import buildcraft.api.blueprints.SchematicBlockBase;
import buildcraft.core.Box;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptError;
import buildcraft.core.blueprints.LibraryId;
import buildcraft.core.blueprints.Template;
import buildcraft.core.lib.utils.Matrix4i;
import buildcraft.core.lib.utils.NBTUtils;
import buildcraft.core.lib.utils.Utils;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.WorldSettings;

public abstract class BlueprintBase {
    public ArrayList<NBTTagCompound> subBlueprintsNBT = new ArrayList();
    public BlockPos anchor = Utils.POS_ZERO;
    public BlockPos size = Utils.POS_ONE;
    public LibraryId id = new LibraryId();
    public String author;
    public boolean rotate = true;
    public boolean excavate = true;
    public BuildingPermission buildingPermission = BuildingPermission.ALL;
    public boolean isComplete = true;
    protected MappingRegistry mapping = new MappingRegistry();
    private SchematicBlockBase[][][] contents;
    private NBTTagCompound nbt;
    private EnumFacing mainDir = EnumFacing.EAST;

    public BlueprintBase() {
    }

    @Deprecated
    public BlueprintBase(int sizeX, int sizeY, int sizeZ) {
        this(new BlockPos(sizeX, sizeY, sizeZ));
    }

    public BlueprintBase(BlockPos size) {
        this.contents = new SchematicBlockBase[size.func_177958_n()][size.func_177956_o()][size.func_177952_p()];
        this.size = size;
        this.anchor = Utils.POS_ZERO;
    }

    public SchematicBlockBase get(BlockPos pos) {
        String error = "Tried to access the " + pos + " when the maximum ";
        if (this.contents.length <= pos.func_177958_n()) {
            throw new ArrayIndexOutOfBoundsException(error + "X coord was " + (this.contents.length - 1));
        }
        SchematicBlockBase[][] arr2 = this.contents[pos.func_177958_n()];
        if (arr2.length <= pos.func_177956_o()) {
            throw new ArrayIndexOutOfBoundsException(error + "Y coord was " + (arr2.length - 1));
        }
        SchematicBlockBase[] arr1 = arr2[pos.func_177956_o()];
        if (arr1.length <= pos.func_177952_p()) {
            throw new ArrayIndexOutOfBoundsException(error + "Z coord was " + (arr1.length - 1));
        }
        return arr1[pos.func_177952_p()];
    }

    public void set(BlockPos pos, SchematicBlockBase schematic) {
        this.contents[pos.func_177958_n()][pos.func_177956_o()][pos.func_177952_p()] = schematic;
    }

    public void translateToBlueprint(Vec3 transform) {
        SchematicBlockBase[][][] schematicBlockBaseArray = this.contents;
        int n = schematicBlockBaseArray.length;
        for (int i = 0; i < n; ++i) {
            SchematicBlockBase[][] arr2;
            SchematicBlockBase[][] schematicBlockBaseArray2 = arr2 = schematicBlockBaseArray[i];
            int n2 = schematicBlockBaseArray2.length;
            for (int j = 0; j < n2; ++j) {
                SchematicBlockBase[] arr1;
                for (SchematicBlockBase content : arr1 = schematicBlockBaseArray2[j]) {
                    if (content == null) continue;
                    content.translateToBlueprint(transform);
                }
            }
        }
    }

    public void translateToWorld(Vec3 transform) {
        SchematicBlockBase[][][] schematicBlockBaseArray = this.contents;
        int n = schematicBlockBaseArray.length;
        for (int i = 0; i < n; ++i) {
            SchematicBlockBase[][] arr2;
            SchematicBlockBase[][] schematicBlockBaseArray2 = arr2 = schematicBlockBaseArray[i];
            int n2 = schematicBlockBaseArray2.length;
            for (int j = 0; j < n2; ++j) {
                SchematicBlockBase[] arr1;
                for (SchematicBlockBase content : arr1 = schematicBlockBaseArray2[j]) {
                    if (content == null) continue;
                    content.translateToWorld(transform);
                }
            }
        }
    }

    public void rotateLeft(BptContext context) {
        SchematicBlockBase[][][] newContents = new SchematicBlockBase[this.size.func_177952_p()][this.size.func_177956_o()][this.size.func_177958_n()];
        Matrix4i leftRot = Matrix4i.makeRotLeftTranslatePositive(new Box(BlockPos.field_177992_a, this.size.func_177973_b((Vec3i)Utils.POS_ONE)));
        for (BlockPos internal : BlockPos.func_177980_a((BlockPos)Utils.POS_ZERO, (BlockPos)this.size.func_177973_b((Vec3i)Utils.POS_ONE))) {
            BlockPos rotated = leftRot.multiplyPosition((Vec3i)internal);
            SchematicBlockBase oldContents = this.contents[internal.func_177958_n()][internal.func_177956_o()][internal.func_177952_p()];
            if (oldContents == null) continue;
            oldContents.rotateLeft(context);
            newContents[rotated.func_177958_n()][rotated.func_177956_o()][rotated.func_177952_p()] = oldContents;
        }
        this.contents = newContents;
        this.size = new BlockPos(this.size.func_177952_p(), this.size.func_177956_o(), this.size.func_177958_n());
        BlockPos newAnchor = leftRot.multiplyPosition((Vec3i)this.anchor);
        for (NBTTagCompound sub : this.subBlueprintsNBT) {
            EnumFacing dir = EnumFacing.values()[sub.func_74771_c("dir")];
            if (dir.func_176740_k() != EnumFacing.Axis.Y) {
                dir = dir.func_176746_e();
            }
            Vec3 pos = new Vec3((double)sub.func_74762_e("x"), (double)sub.func_74762_e("y"), (double)sub.func_74762_e("z"));
            Vec3 rotated = context.rotatePositionLeft(pos);
            sub.func_74768_a("x", (int)rotated.field_72450_a);
            sub.func_74768_a("z", (int)rotated.field_72449_c);
            sub.func_74774_a("dir", (byte)dir.ordinal());
        }
        context.rotateLeft();
        this.anchor = newAnchor;
        if (this.mainDir.func_176740_k() != EnumFacing.Axis.Y) {
            this.mainDir = this.mainDir.func_176746_e();
        }
    }

    private void writeToNBTInternal(NBTTagCompound nbt) {
        nbt.func_74778_a("version", "7.2.7");
        if (this instanceof Template) {
            nbt.func_74778_a("kind", "template");
        } else {
            nbt.func_74778_a("kind", "blueprint");
        }
        nbt.func_74757_a("rotate", this.rotate);
        nbt.func_74757_a("excavate", this.excavate);
        nbt.func_74782_a("size", NBTUtils.writeBlockPos(this.size));
        nbt.func_74782_a("anchor", NBTUtils.writeBlockPos(this.anchor));
        if (this.author != null) {
            nbt.func_74778_a("author", this.author);
        }
        this.saveContents(nbt);
        NBTTagList subBptList = new NBTTagList();
        for (NBTTagCompound subBpt : this.subBlueprintsNBT) {
            subBptList.func_74742_a((NBTBase)subBpt);
        }
        nbt.func_74782_a("subBpt", (NBTBase)subBptList);
    }

    public static BlueprintBase loadBluePrint(NBTTagCompound nbt) {
        String kind = nbt.func_74779_i("kind");
        BlueprintBase bpt = "template".equals(kind) ? new Template() : new Blueprint();
        bpt.readFromNBT(nbt);
        return bpt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.size = nbt.func_74764_b("sizeX") ? new BlockPos(nbt.func_74762_e("sizeX"), nbt.func_74762_e("sizeY"), nbt.func_74762_e("sizeZ")) : NBTUtils.readBlockPos(nbt.func_74781_a("size"));
        this.anchor = nbt.func_74764_b("anchorX") ? new BlockPos(nbt.func_74762_e("anchorX"), nbt.func_74762_e("anchorY"), nbt.func_74762_e("anchorZ")) : NBTUtils.readBlockPos(nbt.func_74781_a("anchor"));
        this.author = nbt.func_74779_i("author");
        this.rotate = nbt.func_74764_b("rotate") ? nbt.func_74767_n("rotate") : true;
        this.excavate = nbt.func_74764_b("excavate") ? nbt.func_74767_n("excavate") : true;
        this.contents = new SchematicBlockBase[this.size.func_177958_n()][this.size.func_177956_o()][this.size.func_177952_p()];
        try {
            this.loadContents(nbt);
        }
        catch (BptError e) {
            e.printStackTrace();
        }
        if (nbt.func_74764_b("subBpt")) {
            NBTTagList subBptList = nbt.func_150295_c("subBpt", 10);
            for (int i = 0; i < subBptList.func_74745_c(); ++i) {
                this.subBlueprintsNBT.add(subBptList.func_150305_b(i));
            }
        }
    }

    public Box getBoxForPos(BlockPos pos) {
        BlockPos min = pos.func_177971_a((Vec3i)this.anchor);
        BlockPos max = min.func_177971_a((Vec3i)this.size).func_177973_b((Vec3i)Utils.POS_ONE);
        return new Box(min, max);
    }

    public BptContext getContext(World world, Box box) {
        return new BptContext(world, box, this.mapping);
    }

    public void addSubBlueprint(BlueprintBase subBpt, BlockPos pos, EnumFacing dir) {
        NBTTagCompound subNBT = new NBTTagCompound();
        subNBT.func_74768_a("x", pos.func_177958_n());
        subNBT.func_74768_a("y", pos.func_177956_o());
        subNBT.func_74768_a("z", pos.func_177952_p());
        subNBT.func_74774_a("dir", (byte)dir.ordinal());
        subNBT.func_74782_a("bpt", (NBTBase)subBpt.getNBT());
        this.subBlueprintsNBT.add(subNBT);
    }

    public NBTTagCompound getNBT() {
        if (this.nbt == null) {
            this.nbt = new NBTTagCompound();
            this.writeToNBTInternal(this.nbt);
        }
        return this.nbt;
    }

    public BlueprintBase adjustToWorld(World world, BlockPos pos, EnumFacing o) {
        if (this.buildingPermission == BuildingPermission.NONE || this.buildingPermission == BuildingPermission.CREATIVE_ONLY && world.func_72912_H().func_76077_q() != WorldSettings.GameType.CREATIVE) {
            return null;
        }
        BptContext context = this.getContext(world, this.getBoxForPos(pos));
        if (this.rotate && o != EnumFacing.EAST) {
            if (o == EnumFacing.SOUTH) {
                this.rotateLeft(context);
            } else if (o == EnumFacing.WEST) {
                this.rotateLeft(context);
                this.rotateLeft(context);
            } else if (o == EnumFacing.NORTH) {
                this.rotateLeft(context);
                this.rotateLeft(context);
                this.rotateLeft(context);
            }
        }
        Vec3 transform = Utils.convert((Vec3i)pos).func_178788_d(new Vec3((Vec3i)this.anchor));
        this.translateToWorld(transform);
        return this;
    }

    public abstract void loadContents(NBTTagCompound var1) throws BptError;

    public abstract void saveContents(NBTTagCompound var1);

    public abstract void readFromWorld(IBuilderContext var1, TileEntity var2, BlockPos var3);

    public abstract ItemStack getStack();

    public void readEntitiesFromWorld(IBuilderContext context, TileEntity anchorTile) {
    }
}

