/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IPathProvider;
import buildcraft.core.DefaultProps;
import buildcraft.core.LaserData;
import buildcraft.core.TileMarker;
import buildcraft.core.lib.utils.Utils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;

public class TilePathMarker
extends TileMarker
implements IPathProvider {
    private static ArrayList<TilePathMarker> availableMarkers = new ArrayList();
    public int x0;
    public int y0;
    public int z0;
    public int x1;
    public int y1;
    public int z1;
    public boolean loadLink0 = false;
    public boolean loadLink1 = false;
    public LaserData[] lasers = new LaserData[2];
    public boolean tryingToConnect = false;
    public TilePathMarker[] links = new TilePathMarker[2];

    public boolean isFullyConnected() {
        return this.lasers[0] != null && this.lasers[1] != null;
    }

    public boolean isLinkedTo(TilePathMarker pathMarker) {
        return this.links[0] == pathMarker || this.links[1] == pathMarker;
    }

    public void connect(TilePathMarker marker, LaserData laser) {
        if (this.lasers[0] == null) {
            this.lasers[0] = laser;
            this.links[0] = marker;
        } else if (this.lasers[1] == null) {
            this.lasers[1] = laser;
            this.links[1] = marker;
        }
        if (this.isFullyConnected()) {
            availableMarkers.remove(this);
        }
    }

    public void createLaserAndConnect(TilePathMarker pathMarker) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        Vec3 point5 = new Vec3(0.5, 0.5, 0.5);
        LaserData laser = new LaserData(Utils.convert((Vec3i)this.field_174879_c).func_178787_e(point5), Utils.convert((Vec3i)pathMarker.field_174879_c).func_178787_e(point5));
        LaserData laser2 = new LaserData(laser.head, laser.tail);
        laser2.isVisible = false;
        this.connect(pathMarker, laser);
        pathMarker.connect(this, laser2);
    }

    private TilePathMarker findNearestAvailablePathMarker() {
        TilePathMarker nearestAvailable = null;
        double nearestDistance = 0.0;
        for (TilePathMarker available : availableMarkers) {
            double distance;
            if (available == this || available == this.links[0] || available == this.links[1] || available.func_145831_w().field_73011_w.func_177502_q() != this.func_145831_w().field_73011_w.func_177502_q() || (distance = this.field_174879_c.func_177951_i((Vec3i)available.field_174879_c)) > (double)(DefaultProps.MARKER_RANGE * DefaultProps.MARKER_RANGE) || nearestAvailable != null && !(distance < nearestDistance)) continue;
            nearestAvailable = available;
            nearestDistance = distance;
        }
        return nearestAvailable;
    }

    @Override
    public void tryConnection() {
        if (this.field_145850_b.field_72995_K || this.isFullyConnected()) {
            return;
        }
        this.tryingToConnect = !this.tryingToConnect;
        this.sendNetworkUpdate();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.tryingToConnect) {
            TilePathMarker nearestPathMarker = this.findNearestAvailablePathMarker();
            if (nearestPathMarker != null) {
                this.createLaserAndConnect(nearestPathMarker);
            }
            this.tryingToConnect = false;
            this.sendNetworkUpdate();
            this.func_145831_w().func_147458_c(this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p(), this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
        }
    }

    @Override
    public List<BlockPos> getPath() {
        HashSet<BlockPos> visitedPaths = new HashSet<BlockPos>();
        ArrayList<BlockPos> res = new ArrayList<BlockPos>();
        TilePathMarker nextTile = this;
        while (nextTile != null) {
            visitedPaths.add(nextTile.field_174879_c);
            res.add(nextTile.field_174879_c);
            if (nextTile.links[0] != null && !visitedPaths.contains(nextTile.links[0].field_174879_c)) {
                nextTile = nextTile.links[0];
                continue;
            }
            if (nextTile.links[1] != null && !visitedPaths.contains(nextTile.links[1].field_174879_c)) {
                nextTile = nextTile.links[1];
                continue;
            }
            nextTile = null;
        }
        return res;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        if (this.links[0] != null) {
            this.links[0].unlink(this);
        }
        if (this.links[1] != null) {
            this.links[1].unlink(this);
        }
        availableMarkers.remove(this);
        this.tryingToConnect = false;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.field_145850_b.field_72995_K && !this.isFullyConnected()) {
            availableMarkers.add(this);
        }
        if (this.loadLink0) {
            TileEntity e0 = this.field_145850_b.func_175625_s(new BlockPos(this.x0, this.y0, this.z0));
            if (this.links[0] != e0 && this.links[1] != e0 && e0 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e0);
            }
            this.loadLink0 = false;
        }
        if (this.loadLink1) {
            TileEntity e1 = this.field_145850_b.func_175625_s(new BlockPos(this.x1, this.y1, this.z1));
            if (this.links[0] != e1 && this.links[1] != e1 && e1 instanceof TilePathMarker) {
                this.createLaserAndConnect((TilePathMarker)e1);
            }
            this.loadLink1 = false;
        }
        this.sendNetworkUpdate();
    }

    private void unlink(TilePathMarker tile) {
        if (this.links[0] == tile) {
            this.lasers[0] = null;
            this.links[0] = null;
        }
        if (this.links[1] == tile) {
            this.lasers[1] = null;
            this.links[1] = null;
        }
        if (!(this.isFullyConnected() || availableMarkers.contains(this) || this.field_145850_b.field_72995_K)) {
            availableMarkers.add(this);
        }
        this.sendNetworkUpdate();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("x0")) {
            this.x0 = nbttagcompound.func_74762_e("x0");
            this.y0 = nbttagcompound.func_74762_e("y0");
            this.z0 = nbttagcompound.func_74762_e("z0");
            this.loadLink0 = true;
        }
        if (nbttagcompound.func_74764_b("x1")) {
            this.x1 = nbttagcompound.func_74762_e("x1");
            this.y1 = nbttagcompound.func_74762_e("y1");
            this.z1 = nbttagcompound.func_74762_e("z1");
            this.loadLink1 = true;
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        if (this.links[0] != null) {
            nbttagcompound.func_74768_a("x0", this.links[0].field_174879_c.func_177958_n());
            nbttagcompound.func_74768_a("y0", this.links[0].field_174879_c.func_177956_o());
            nbttagcompound.func_74768_a("z0", this.links[0].field_174879_c.func_177952_p());
        }
        if (this.links[1] != null) {
            nbttagcompound.func_74768_a("x1", this.links[1].field_174879_c.func_177958_n());
            nbttagcompound.func_74768_a("y1", this.links[1].field_174879_c.func_177956_o());
            nbttagcompound.func_74768_a("z1", this.links[1].field_174879_c.func_177952_p());
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        availableMarkers.remove(this);
    }

    public static void clearAvailableMarkersList() {
        availableMarkers.clear();
    }

    public static void clearAvailableMarkersList(World w) {
        Iterator<TilePathMarker> it = availableMarkers.iterator();
        while (it.hasNext()) {
            TilePathMarker t = it.next();
            if (t.func_145831_w().field_73011_w.func_177502_q() == w.field_73011_w.func_177502_q()) continue;
            it.remove();
        }
    }

    @Override
    public void readData(ByteBuf data) {
        boolean previousState = this.tryingToConnect;
        short flags = data.readUnsignedByte();
        if ((flags & 1) != 0) {
            this.lasers[0] = new LaserData();
            this.lasers[0].readData(data);
        } else {
            this.lasers[0] = null;
        }
        if ((flags & 2) != 0) {
            this.lasers[1] = new LaserData();
            this.lasers[1].readData(data);
        } else {
            this.lasers[1] = null;
        }
        boolean bl = this.tryingToConnect = (flags & 4) != 0;
        if (previousState != this.tryingToConnect) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    @Override
    public void writeData(ByteBuf data) {
        int flags = (this.lasers[0] != null ? 1 : 0) | (this.lasers[1] != null ? 2 : 0) | (this.tryingToConnect ? 4 : 0);
        data.writeByte(flags);
        if (this.lasers[0] != null) {
            this.lasers[0].writeData(data);
        }
        if (this.lasers[1] != null) {
            this.lasers[1].writeData(data);
        }
    }

    @Override
    public void removeFromWorld() {
        List<BlockPos> path = this.getPath();
        for (BlockPos b : path) {
            BuildCraftCore.pathMarkerBlock.func_176226_b(this.field_145850_b, b, BuildCraftCore.pathMarkerBlock.func_176223_P(), 0);
            this.field_145850_b.func_175698_g(b);
        }
    }
}

