/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.items.IMapLocation;
import buildcraft.core.TileMarker;
import buildcraft.core.lib.block.BlockBuildCraft;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockMarker
extends BlockBuildCraft {
    public BlockMarker() {
        this(false);
    }

    protected BlockMarker(boolean on) {
        super(Material.field_151594_q, FACING_6_PROP, on ? LED_DONE : null);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)FACING_6_PROP, (Comparable)EnumFacing.UP));
        this.func_149715_a(0.5f);
        this.func_149711_c(0.0f);
    }

    public static boolean canPlaceTorch(World world, BlockPos pos, EnumFacing side) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block.func_149662_c() || block.isSideSolid((IBlockAccess)world, pos, side);
    }

    @Override
    public AxisAlignedBB getBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        double w = 0.15;
        double h = 0.65;
        EnumFacing dir = (EnumFacing)state.func_177229_b((IProperty)FACING_6_PROP);
        switch (dir) {
            case DOWN: {
                return new AxisAlignedBB(0.5 - w, 1.0 - h, 0.5 - w, 0.5 + w, 1.0, 0.5 + w);
            }
            case UP: {
                return new AxisAlignedBB(0.5 - w, 0.0, 0.5 - w, 0.5 + w, h, 0.5 + w);
            }
            case SOUTH: {
                return new AxisAlignedBB(0.5 - w, 0.5 - w, 0.0, 0.5 + w, 0.5 + w, h);
            }
            case NORTH: {
                return new AxisAlignedBB(0.5 - w, 0.5 - w, 1.0 - h, 0.5 + w, 0.5 + w, 1.0);
            }
            case EAST: {
                return new AxisAlignedBB(0.0, 0.5 - w, 0.5 - w, h, 0.5 + w, 0.5 + w);
            }
        }
        return new AxisAlignedBB(1.0 - h, 0.5 - w, 0.5 - w, 1.0, 0.5 + w, 0.5 + w);
    }

    public boolean func_149703_v() {
        return false;
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileMarker();
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing face, float hitX, float hitY, float hitZ) {
        if (super.func_180639_a(world, pos, state, player, face, hitX, hitY, hitZ)) {
            return true;
        }
        if (player.field_71071_by.func_70448_g() != null && player.field_71071_by.func_70448_g().func_77973_b() instanceof IMapLocation) {
            return false;
        }
        if (player.func_70093_af()) {
            return false;
        }
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMarker) {
            ((TileMarker)tile).tryConnection();
            return true;
        }
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public void func_176204_a(World world, BlockPos pos, IBlockState state, Block block) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileMarker) {
            ((TileMarker)tile).updateSignals();
        }
        this.dropTorchIfCantStay(world, pos, state);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return BlockMarker.canPlaceTorch(world, pos.func_177967_a(side, -1), side);
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        super.func_176213_c(world, pos, state);
        this.dropTorchIfCantStay(world, pos, state);
    }

    private void dropTorchIfCantStay(World world, BlockPos pos, IBlockState state) {
        EnumFacing side = (EnumFacing)state.func_177229_b((IProperty)FACING_6_PROP);
        if (!this.func_176198_a(world, pos, side)) {
            this.func_176226_b(world, pos, state, 0);
            world.func_175698_g(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public EnumWorldBlockLayer func_180664_k() {
        return EnumWorldBlockLayer.CUTOUT;
    }
}

