/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.statements;

import buildcraft.api.filler.FillerManager;
import buildcraft.api.filler.IFillerPattern;
import buildcraft.api.statements.IActionExternal;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.builders.TileFiller;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.statements.BCStatement;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ActionFiller
extends BCStatement
implements IActionExternal {
    private static final Map<FillerPattern, ActionFiller> actions = Maps.newHashMap();
    public final FillerPattern pattern;

    public static void resetMap() {
        actions.clear();
        for (IFillerPattern pattern : FillerManager.registry.getPatterns()) {
            FillerPattern fil = (FillerPattern)pattern;
            actions.put(fil, new ActionFiller(fil));
        }
    }

    public static ActionFiller getForPattern(FillerPattern pattern) {
        return actions.get(pattern);
    }

    private ActionFiller(FillerPattern pattern) {
        super("filler:" + pattern.getUniqueTag());
        this.pattern = pattern;
        this.setBuildCraftLocation("core", "filler/patterns/" + pattern.type.func_176610_l());
    }

    @Override
    public String getDescription() {
        return "Pattern: " + this.pattern.getDescription();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getGuiSprite() {
        return this.pattern.getGuiSprite();
    }

    @Override
    public int minParameters() {
        return this.pattern.minParameters();
    }

    @Override
    public int maxParameters() {
        return this.pattern.maxParameters();
    }

    @Override
    public IStatementParameter createParameter(int index) {
        return this.pattern.createParameter(index);
    }

    @Override
    public void actionActivate(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        if (target instanceof TileFiller) {
            ((TileFiller)target).setPattern(this.pattern, true);
            ((TileFiller)target).patternParameters = parameters;
        }
    }
}

