/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.gui;

import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.Template;
import buildcraft.core.lib.world.FakeWorld;
import buildcraft.core.lib.world.FakeWorldManager;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.init.Blocks;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.input.Mouse;

public abstract class GuiBlueprintBase
extends GuiScreen {
    protected final BlueprintBase blueprint;
    private final FakeWorldManager fakeWorld;
    private float scroll = 16.0f;
    private BlockPos offset = new BlockPos(0, 0, 0);
    private double mouseX = 0.0;
    private double mouseY = 0.0;
    private boolean hasRendered = false;

    public GuiBlueprintBase(BlueprintBase blueprint) {
        this.blueprint = blueprint;
        FakeWorld world = blueprint instanceof Blueprint ? new FakeWorld((Blueprint)blueprint) : new FakeWorld((Template)blueprint, Blocks.field_150336_V.func_176223_P());
        this.fakeWorld = new FakeWorldManager(world);
        this.field_146297_k = Minecraft.func_71410_x();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void openGui(GuiOpenEvent event) {
        if (event.gui != this) {
            this.field_146297_k.field_71417_B.func_74373_b();
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_146280_a(Minecraft mc, int width, int height) {
        super.func_146280_a(mc, width, height);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        if (!this.hasRendered) {
            this.field_146297_k.field_71417_B.func_74372_a();
            this.hasRendered = true;
        }
        this.fakeWorld.renderWorld(this.mouseX, this.mouseY, this.scroll, this.offset);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        double deltaWheel = Mouse.getEventDWheel() / 64;
        this.scroll = (float)((double)this.scroll - deltaWheel);
        if (this.scroll < 2.0f) {
            this.scroll = (float)((double)this.scroll + deltaWheel);
        }
        double sensitivity = (double)this.field_146297_k.field_71474_y.field_74341_c * 0.6 + 0.2;
        sensitivity *= sensitivity * sensitivity * 0.8;
        this.mouseX += (double)Mouse.getEventDX() * sensitivity;
        this.mouseY += (double)Mouse.getEventDY() * sensitivity;
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        EnumFacing currentLookFace = EnumFacing.func_176733_a((double)this.mouseX);
        if (keyCode == this.field_146297_k.field_71474_y.field_74351_w.func_151463_i()) {
            this.offset = this.offset.func_177972_a(currentLookFace.func_176734_d());
        } else if (keyCode == this.field_146297_k.field_71474_y.field_74368_y.func_151463_i()) {
            this.offset = this.offset.func_177972_a(currentLookFace);
        } else if (keyCode == this.field_146297_k.field_71474_y.field_74370_x.func_151463_i()) {
            this.offset = this.offset.func_177972_a(currentLookFace.func_176746_e());
        } else if (keyCode == this.field_146297_k.field_71474_y.field_74366_z.func_151463_i()) {
            this.offset = this.offset.func_177972_a(currentLookFace.func_176746_e().func_176734_d());
        } else if (GuiBlueprintBase.func_146271_m() && !GuiBlueprintBase.func_146272_n()) {
            this.offset = this.offset.func_177977_b();
        } else if (GuiBlueprintBase.func_146272_n() && !GuiBlueprintBase.func_146271_m()) {
            this.offset = this.offset.func_177984_a();
        }
    }
}

