/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.BuildCraftCore;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.core.SafeTimeTracker;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IDebuggable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.api.transport.IPipeConnection;
import buildcraft.api.transport.IPipeTile;
import buildcraft.builders.EntityMechanicalArm;
import buildcraft.builders.PatternQuarryFrame;
import buildcraft.core.Box;
import buildcraft.core.DefaultAreaProvider;
import buildcraft.core.blueprints.Blueprint;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptBuilderBlueprint;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.internal.IDropControlInventory;
import buildcraft.core.lib.RFBattery;
import buildcraft.core.lib.utils.BCStringUtils;
import buildcraft.core.lib.utils.BlockMiner;
import buildcraft.core.lib.utils.BlockUtils;
import buildcraft.core.lib.utils.Utils;
import buildcraft.core.proxy.CoreProxy;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fluids.IFluidBlock;

public class TileQuarry
extends TileAbstractBuilder
implements IHasWork,
ISidedInventory,
IDropControlInventory,
IPipeConnection,
IControllable,
IDebuggable {
    public EntityMechanicalArm arm;
    public EntityPlayer placedBy;
    protected Box box = new Box();
    private Box miningBox = new Box();
    private BlockPos target = BlockPos.field_177992_a;
    private Vec3 headPos = Utils.VEC_ZERO;
    private double speed = 0.03;
    private Stage stage = Stage.BUILDING;
    private boolean movingHorizontally;
    private boolean movingVertically;
    private float headTrajectory;
    private SafeTimeTracker updateTracker = new SafeTimeTracker(BuildCraftCore.updateFactor);
    private BptBuilderBase builder;
    private final LinkedList<int[]> visitList = Lists.newLinkedList();
    private boolean loadDefaultBoundaries = false;
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean frameProducer = true;
    private NBTTagCompound initNBT = null;
    private BlockMiner miner;
    private int ledState;
    private int buildCallsS = 0;
    private int buildCallsF = 0;

    public TileQuarry() {
        this.box.kind = Box.Kind.STRIPES;
        this.setBattery(new RFBattery((int)(20480.0f * BuildCraftCore.miningMultiplier), (int)(1000.0f * BuildCraftCore.miningMultiplier), 0));
    }

    public void createUtilsIfNeeded() {
        if (!this.field_145850_b.field_72995_K && this.builder == null) {
            if (!this.box.isInitialized()) {
                this.setBoundaries(this.loadDefaultBoundaries);
            }
            this.initializeBlueprintBuilder();
        }
        if (this.getStage() != Stage.BUILDING) {
            AxisAlignedBB union;
            this.box.isVisible = false;
            if (this.arm == null) {
                this.createArm();
            }
            if (this.miningBox == null || !this.miningBox.isInitialized()) {
                this.miningBox = new Box(this.box.min(), this.box.max());
                this.miningBox.contract(1);
                this.miningBox.setMin(Utils.withValue(this.miningBox.min(), EnumFacing.Axis.Y, 0));
                this.miningBox.setMax(this.miningBox.max().func_177982_a(0, 1, 0));
            }
            if (this.findTarget(false) && !(union = this.miningBox.getBoundingBox().func_111270_a(this.box.getBoundingBox())).func_72318_a(this.headPos)) {
                this.headPos = Utils.withValue(this.headPos, EnumFacing.Axis.Y, (double)(this.miningBox.max().func_177956_o() - 2));
                BlockPos nearestPos = this.miningBox.closestInsideTo(Utils.convertFloor(this.headPos));
                this.headPos = Utils.convert((Vec3i)nearestPos);
            }
        } else {
            this.box.isVisible = true;
        }
    }

    private void createArm() {
        Vec3 vec = Utils.convert((Vec3i)this.box.min()).func_178787_e(Utils.vec3(0.75));
        vec = vec.func_178787_e(Utils.convert(EnumFacing.UP, (double)this.box.size().func_177956_o() - 1.5));
        double width = (float)(this.box.size().func_177958_n() - 2) + 0.5f;
        double height = (float)(this.box.size().func_177952_p() - 2) + 0.5f;
        this.field_145850_b.func_72838_d((Entity)new EntityMechanicalArm(this.field_145850_b, vec, width, height, this));
    }

    public void setArm(EntityMechanicalArm arm) {
        this.arm = arm;
    }

    public boolean areChunksLoaded() {
        if (BuildCraftBuilders.quarryLoadsChunks) {
            return true;
        }
        return Utils.checkChunksExist(this.field_145850_b, this.box.min(), this.box.max());
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            if (this.getStage() != Stage.DONE) {
                this.moveHead(this.speed);
            }
            return;
        }
        if (this.getStage() == Stage.DONE) {
            if (this.mode == IControllable.Mode.Loop) {
                this.setStage(Stage.IDLE);
            } else {
                return;
            }
        }
        if (!this.areChunksLoaded()) {
            return;
        }
        if (this.mode == IControllable.Mode.Off && this.getStage() != Stage.MOVING) {
            return;
        }
        this.createUtilsIfNeeded();
        if (this.getStage() == Stage.BUILDING) {
            if (this.builder != null && !this.builder.isDone(this)) {
                if (this.builder.buildNextSlot(this.field_145850_b, this)) {
                    ++this.buildCallsS;
                } else {
                    ++this.buildCallsF;
                }
            } else {
                this.setStage(Stage.IDLE);
            }
        } else if (this.getStage() == Stage.DIGGING) {
            this.dig();
        } else {
            if (this.getStage() == Stage.IDLE) {
                this.idling();
                return;
            }
            if (this.stage == Stage.MOVING) {
                int energyUsed = this.getBattery().useEnergy(20, (int)Math.ceil(20.0 + (double)this.getBattery().getEnergyStored() / 10.0), false);
                if (energyUsed >= 20) {
                    this.speed = 0.1 + (double)((float)energyUsed / 2000.0f);
                    if (this.field_145850_b.func_72896_J() && (double)this.field_145850_b.func_175645_m(Utils.convertFloor(this.headPos)).func_177956_o() < this.headPos.field_72448_b) {
                        this.speed *= 0.7;
                    }
                    this.moveHead(this.speed);
                } else {
                    this.speed = 0.0;
                }
            }
        }
        if (this.updateTracker.markTimeIfDelay(this.field_145850_b)) {
            this.sendNetworkUpdate();
        }
    }

    protected void dig() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.miner == null) {
            this.stage = Stage.IDLE;
            return;
        }
        int rfTaken = this.miner.acceptEnergy(this.getBattery().getEnergyStored());
        this.getBattery().useEnergy(rfTaken, rfTaken, false);
        if (this.miner.hasMined()) {
            double[] head = this.getHead();
            AxisAlignedBB axis = new AxisAlignedBB(head[0] - 2.0, head[1] - 2.0, head[2] - 2.0, head[0] + 3.0, head[1] + 3.0, head[2] + 3.0);
            List result = this.field_145850_b.func_72872_a(EntityItem.class, axis);
            for (EntityItem entity : result) {
                if (entity.field_70128_L) continue;
                ItemStack mineable = entity.func_92059_d();
                if (mineable.field_77994_a <= 0) continue;
                CoreProxy.proxy.removeEntity((Entity)entity);
                this.miner.mineStack(mineable);
            }
            this.setStage(Stage.IDLE);
            this.miner = null;
            return;
        }
        if (!this.findFrame()) {
            this.initializeBlueprintBuilder();
            this.stage = Stage.BUILDING;
        } else if (this.miner.hasFailed()) {
            this.setStage(Stage.IDLE);
            this.miner = null;
        }
    }

    protected boolean findFrame() {
        return this.field_145850_b.func_180495_p(this.box.min()).func_177230_c() == BuildCraftBuilders.frameBlock;
    }

    protected void idling() {
        if (!this.findTarget(true)) {
            if (this.arm != null && this.box != null) {
                this.setTarget(new BlockPos(this.box.min().func_177958_n() + 1, this.field_174879_c.func_177956_o() + 2, this.box.min().func_177952_p() + 1));
            }
            this.setStage(Stage.DONE);
        } else {
            this.setStage(Stage.MOVING);
        }
        this.movingHorizontally = true;
        this.movingVertically = true;
        double[] head = this.getHead();
        int[] target = this.getTarget();
        this.headTrajectory = (float)Math.atan2((double)target[2] - head[2], (double)target[0] - head[0]);
        this.sendNetworkUpdate();
    }

    public boolean findTarget(boolean doSet) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        boolean columnVisitListIsUpdated = false;
        if (this.visitList.isEmpty()) {
            this.createColumnVisitList();
            columnVisitListIsUpdated = true;
        }
        if (!doSet) {
            return !this.visitList.isEmpty();
        }
        if (this.visitList.isEmpty()) {
            return false;
        }
        int[] nextTarget = this.visitList.removeFirst();
        if (!columnVisitListIsUpdated) {
            for (int y = nextTarget[1] + 1; y < this.func_174877_v().func_177956_o() + 3; ++y) {
                if (!this.isQuarriableBlock(new BlockPos(nextTarget[0], y, nextTarget[2]))) continue;
                this.createColumnVisitList();
                columnVisitListIsUpdated = true;
                nextTarget = null;
                break;
            }
        }
        if (columnVisitListIsUpdated && nextTarget == null && !this.visitList.isEmpty()) {
            nextTarget = this.visitList.removeFirst();
        } else if (columnVisitListIsUpdated && nextTarget == null) {
            return false;
        }
        this.setTarget(new BlockPos(nextTarget[0], nextTarget[1] + 1, nextTarget[2]));
        return true;
    }

    private void createColumnVisitList() {
        this.visitList.clear();
        boolean[][] blockedColumns = new boolean[this.builder.blueprint.size.func_177958_n() - 2][this.builder.blueprint.size.func_177952_p() - 2];
        for (int searchY = this.field_174879_c.func_177956_o() + 3; searchY >= 1; --searchY) {
            int incX;
            int endX;
            int startX;
            if (searchY % 2 == 0) {
                startX = 0;
                endX = this.builder.blueprint.size.func_177958_n() - 2;
                incX = 1;
            } else {
                startX = this.builder.blueprint.size.func_177958_n() - 3;
                endX = -1;
                incX = -1;
            }
            for (int searchX = startX; searchX != endX; searchX += incX) {
                int incZ;
                int endZ;
                int startZ;
                if (searchX % 2 == searchY % 2) {
                    startZ = 0;
                    endZ = this.builder.blueprint.size.func_177952_p() - 2;
                    incZ = 1;
                } else {
                    startZ = this.builder.blueprint.size.func_177952_p() - 3;
                    endZ = -1;
                    incZ = -1;
                }
                for (int searchZ = startZ; searchZ != endZ; searchZ += incZ) {
                    if (blockedColumns[searchX][searchZ]) continue;
                    int bx = this.box.min().func_177958_n() + searchX + 1;
                    int by = searchY;
                    int bz = this.box.min().func_177952_p() + searchZ + 1;
                    BlockPos pos = new BlockPos(bx, by, bz);
                    IBlockState state = this.field_145850_b.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (!BlockUtils.canChangeBlock(state, this.field_145850_b, pos)) {
                        blockedColumns[searchX][searchZ] = true;
                    } else if (!(BuildCraftAPI.isSoftBlock(this.field_145850_b, pos) || block instanceof BlockLiquid || block instanceof IFluidBlock)) {
                        this.visitList.add(new int[]{bx, by, bz});
                    }
                    if (this.visitList.size() <= this.builder.blueprint.size.func_177952_p() * this.builder.blueprint.size.func_177958_n() * 2) continue;
                    return;
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        if (nbttagcompound.func_74764_b("box")) {
            this.box.initialize(nbttagcompound.func_74775_l("box"));
            this.loadDefaultBoundaries = false;
        } else if (nbttagcompound.func_74764_b("xSize")) {
            int xMin = nbttagcompound.func_74762_e("xMin");
            int zMin = nbttagcompound.func_74762_e("zMin");
            int xSize = nbttagcompound.func_74762_e("xSize");
            int ySize = nbttagcompound.func_74762_e("ySize");
            int zSize = nbttagcompound.func_74762_e("zSize");
            this.box.reset();
            this.box.setMin(new BlockPos(xMin, this.field_174879_c.func_177956_o(), zMin));
            this.box.setMax(new BlockPos(xMin + xSize - 1, this.field_174879_c.func_177956_o() + ySize - 1, zMin + zSize - 1));
            this.loadDefaultBoundaries = false;
        } else {
            this.loadDefaultBoundaries = true;
        }
        int targetX = nbttagcompound.func_74762_e("targetX");
        int targetY = nbttagcompound.func_74762_e("targetY");
        int targetZ = nbttagcompound.func_74762_e("targetZ");
        this.target = new BlockPos(targetX, targetY, targetZ);
        double headPosX = nbttagcompound.func_74769_h("headPosX");
        double headPosY = nbttagcompound.func_74769_h("headPosY");
        double headPosZ = nbttagcompound.func_74769_h("headPosZ");
        this.headPos = new Vec3(headPosX, headPosY, headPosZ);
        this.initNBT = (NBTTagCompound)nbttagcompound.func_74775_l("bpt").func_74737_b();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74768_a("targetX", this.target.func_177958_n());
        nbttagcompound.func_74768_a("targetY", this.target.func_177956_o());
        nbttagcompound.func_74768_a("targetZ", this.target.func_177952_p());
        nbttagcompound.func_74780_a("headPosX", this.headPos.field_72450_a);
        nbttagcompound.func_74780_a("headPosY", this.headPos.field_72448_b);
        nbttagcompound.func_74780_a("headPosZ", this.headPos.field_72449_c);
        NBTTagCompound boxTag = new NBTTagCompound();
        this.box.writeToNBT(boxTag);
        nbttagcompound.func_74782_a("box", (NBTBase)boxTag);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.builder != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.builder.saveBuildStateToNBT(builderCpt, this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        nbttagcompound.func_74782_a("bpt", (NBTBase)bptNBT);
    }

    public void positionReached() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        BlockPos pos = this.target.func_177977_b();
        if (this.isQuarriableBlock(pos)) {
            this.miner = new BlockMiner(this.field_145850_b, this, pos);
            this.setStage(Stage.DIGGING);
        } else {
            this.setStage(Stage.IDLE);
        }
    }

    private boolean isQuarriableBlock(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        Block block = state.func_177230_c();
        return BlockUtils.canChangeBlock(state, this.field_145850_b, pos) && !BuildCraftAPI.isSoftBlock(this.field_145850_b, pos) && !(block instanceof BlockLiquid) && !(block instanceof IFluidBlock);
    }

    @Override
    public void func_145843_s() {
        if (this.chunkTicket != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
        }
        super.func_145843_s();
        this.destroy();
    }

    public void onChunkUnload() {
        this.destroy();
    }

    @Override
    public void destroy() {
        if (this.arm != null) {
            this.arm.func_70106_y();
        }
        this.arm = null;
        this.frameProducer = false;
        if (this.miner != null) {
            this.miner.invalidate();
        }
    }

    @Override
    public boolean hasWork() {
        return this.getStage() != Stage.DONE;
    }

    private Stage getStage() {
        return this.stage;
    }

    private void setStage(Stage stage) {
        this.stage = stage;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (stage == Stage.DONE) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a(BuildCraftProperties.LED_DONE, (Comparable)Boolean.valueOf(true)));
        } else if (((Boolean)state.func_177229_b(BuildCraftProperties.LED_DONE)).booleanValue()) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a(BuildCraftProperties.LED_DONE, (Comparable)Boolean.valueOf(false)));
        }
    }

    private void setBoundaries(boolean useDefaultI) {
        boolean useDefault = useDefaultI;
        if (BuildCraftBuilders.quarryLoadsChunks && this.chunkTicket == null) {
            this.chunkTicket = ForgeChunkManager.requestTicket((Object)BuildCraftBuilders.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        }
        if (this.chunkTicket != null) {
            this.chunkTicket.getModData().func_74768_a("quarryX", this.field_174879_c.func_177958_n());
            this.chunkTicket.getModData().func_74768_a("quarryY", this.field_174879_c.func_177956_o());
            this.chunkTicket.getModData().func_74768_a("quarryZ", this.field_174879_c.func_177952_p());
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.chunkTicket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4));
        }
        IAreaProvider a = null;
        if (!useDefault) {
            a = Utils.getNearbyAreaProvider(this.field_145850_b, this.field_174879_c);
        }
        if (a == null) {
            a = new DefaultAreaProvider(this.field_174879_c, this.field_174879_c.func_177971_a((Vec3i)new BlockPos(10, 4, 10)));
            useDefault = true;
        }
        int xSize = a.max().func_177958_n() - a.min().func_177958_n() + 1;
        int zSize = a.max().func_177952_p() - a.min().func_177952_p() + 1;
        if (xSize < 3 || zSize < 3 || this.chunkTicket != null && xSize * zSize >> 8 >= this.chunkTicket.getMaxChunkListDepth()) {
            if (this.placedBy != null) {
                this.placedBy.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.buildcraft.quarry.tooSmall", new Object[]{xSize, zSize, this.chunkTicket != null ? this.chunkTicket.getMaxChunkListDepth() : 0}));
            }
            a = new DefaultAreaProvider(this.field_174879_c, this.field_174879_c.func_177971_a((Vec3i)new BlockPos(10, 4, 10)));
            useDefault = true;
        }
        xSize = a.max().func_177958_n() - a.min().func_177958_n() + 1;
        int ySize = a.max().func_177956_o() - a.min().func_177956_o() + 1;
        zSize = a.max().func_177952_p() - a.min().func_177952_p() + 1;
        this.box.initialize(a);
        if (ySize < 5) {
            ySize = 5;
            this.box.setMax(Utils.withValue(this.box.max(), EnumFacing.Axis.Y, this.box.min().func_177956_o() + ySize - 1));
        }
        if (useDefault) {
            int zMin;
            int xMin;
            EnumFacing face = ((EnumFacing)this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BuildCraftProperties.BLOCK_FACING)).func_176734_d();
            switch (face) {
                case EAST: {
                    xMin = this.field_174879_c.func_177958_n() + 1;
                    zMin = this.field_174879_c.func_177952_p() - 4 - 1;
                    break;
                }
                case WEST: {
                    xMin = this.field_174879_c.func_177958_n() - 9 - 2;
                    zMin = this.field_174879_c.func_177952_p() - 4 - 1;
                    break;
                }
                case SOUTH: {
                    xMin = this.field_174879_c.func_177958_n() - 4 - 1;
                    zMin = this.field_174879_c.func_177952_p() + 1;
                    break;
                }
                default: {
                    xMin = this.field_174879_c.func_177958_n() - 4 - 1;
                    zMin = this.field_174879_c.func_177952_p() - 9 - 2;
                }
            }
            this.box.reset();
            this.box.setMin(new BlockPos(xMin, this.field_174879_c.func_177956_o(), zMin));
            this.box.setMax(new BlockPos(xMin + xSize - 1, this.field_174879_c.func_177956_o() + ySize - 1, zMin + zSize - 1));
        }
        a.removeFromWorld();
        if (this.chunkTicket != null) {
            this.forceChunkLoading(this.chunkTicket);
        }
        this.sendNetworkUpdate();
    }

    private void initializeBlueprintBuilder() {
        PatternQuarryFrame pqf = PatternQuarryFrame.INSTANCE;
        Blueprint bpt = pqf.getBlueprint(this.box, this.field_145850_b);
        this.builder = new BptBuilderBlueprint(bpt, this.field_145850_b, this.box.min());
        this.builder.setOrder(new Utils.AxisOrder(Utils.EnumAxisOrder.XZY, true, true, false));
        this.speed = 0.0;
        this.stage = Stage.BUILDING;
        this.sendNetworkUpdate();
    }

    @Override
    public void writeData(ByteBuf stream) {
        super.writeData(stream);
        this.box.writeData(stream);
        stream.writeInt(this.target.func_177958_n());
        stream.writeShort(this.target.func_177956_o());
        stream.writeInt(this.target.func_177952_p());
        stream.writeDouble(this.headPos.field_72450_a);
        stream.writeDouble(this.headPos.field_72448_b);
        stream.writeDouble(this.headPos.field_72449_c);
        stream.writeFloat((float)this.speed);
        stream.writeFloat(this.headTrajectory);
        int flags = this.stage.ordinal();
        flags |= this.movingHorizontally ? 16 : 0;
        stream.writeByte(flags |= this.movingVertically ? 32 : 0);
        this.ledState = this.getBattery().getEnergyStored() * 3 / this.getBattery().getMaxEnergyStored();
        stream.writeByte(this.ledState);
    }

    @Override
    public void readData(ByteBuf stream) {
        super.readData(stream);
        this.box.readData(stream);
        int targetX = stream.readInt();
        int targetY = stream.readUnsignedShort();
        int targetZ = stream.readInt();
        this.target = new BlockPos(targetX, targetY, targetZ);
        double headPosX = stream.readDouble();
        double headPosY = stream.readDouble();
        double headPosZ = stream.readDouble();
        this.headPos = new Vec3(headPosX, headPosY, headPosZ);
        this.speed = stream.readFloat();
        this.headTrajectory = stream.readFloat();
        short flags = stream.readUnsignedByte();
        this.setStage(Stage.values()[flags & 7]);
        this.movingHorizontally = (flags & 0x10) != 0;
        this.movingVertically = (flags & 0x20) != 0;
        this.ledState = stream.readUnsignedByte();
        this.createUtilsIfNeeded();
        if (this.arm != null) {
            this.arm.setHead(this.headPos);
            this.arm.updatePosition();
        }
    }

    @Override
    public void initialize() {
        super.initialize();
        if (!this.func_145831_w().field_72995_K && !this.box.isInitialized()) {
            this.setBoundaries(false);
        }
        this.createUtilsIfNeeded();
        if (this.initNBT != null && this.builder != null) {
            this.builder.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), this);
        }
        this.initNBT = null;
        this.sendNetworkUpdate();
    }

    public void reinitalize() {
        this.initializeBlueprintBuilder();
    }

    public int func_70302_i_() {
        return 1;
    }

    public ItemStack func_70301_a(int i) {
        if (this.frameProducer) {
            return new ItemStack((Block)BuildCraftBuilders.frameBlock);
        }
        return null;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.frameProducer) {
            return new ItemStack((Block)BuildCraftBuilders.frameBlock, j);
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
    }

    public ItemStack func_70304_b(int slot) {
        return null;
    }

    @Override
    public String getInventoryName() {
        return "";
    }

    public int func_70297_j_() {
        return 0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return true;
    }

    public void moveHead(double instantSpeed) {
        int[] target = this.getTarget();
        double[] head = this.getHead();
        if (this.movingHorizontally) {
            if (Math.abs((double)target[0] - head[0]) < instantSpeed * 2.0 && Math.abs((double)target[2] - head[2]) < instantSpeed * 2.0) {
                head[0] = target[0];
                head[2] = target[2];
                this.movingHorizontally = false;
                if (!this.movingVertically) {
                    this.positionReached();
                    head[1] = target[1];
                }
            } else {
                head[0] = head[0] + (double)MathHelper.func_76134_b((float)this.headTrajectory) * instantSpeed;
                head[2] = head[2] + (double)MathHelper.func_76126_a((float)this.headTrajectory) * instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        if (this.movingVertically) {
            if (Math.abs((double)target[1] - head[1]) < instantSpeed * 2.0) {
                head[1] = target[1];
                this.movingVertically = false;
                if (!this.movingHorizontally) {
                    this.positionReached();
                    head[0] = target[0];
                    head[2] = target[2];
                }
            } else {
                head[1] = (double)target[1] > head[1] ? head[1] + instantSpeed : head[1] - instantSpeed;
            }
            this.setHead(head[0], head[1], head[2]);
        }
        this.updatePosition();
    }

    private void updatePosition() {
        if (this.arm != null && this.field_145850_b.field_72995_K) {
            this.arm.setHead(this.headPos);
            this.arm.updatePosition();
        }
    }

    private void setHead(double x, double y, double z) {
        this.headPos = new Vec3(x, y, z);
    }

    private double[] getHead() {
        return new double[]{this.headPos.field_72450_a, this.headPos.field_72448_b, this.headPos.field_72449_c};
    }

    private int[] getTarget() {
        return new int[]{this.target.func_177958_n(), this.target.func_177956_o(), this.target.func_177952_p()};
    }

    private void setTarget(BlockPos pos) {
        this.target = pos;
    }

    public void forceChunkLoading(ForgeChunkManager.Ticket ticket) {
        if (this.chunkTicket == null) {
            this.chunkTicket = ticket;
        }
        HashSet chunks = Sets.newHashSet();
        ChunkCoordIntPair quarryChunk = new ChunkCoordIntPair(this.field_174879_c.func_177958_n() >> 4, this.field_174879_c.func_177952_p() >> 4);
        chunks.add(quarryChunk);
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)quarryChunk);
        if (this.box.isInitialized()) {
            for (int chunkX = this.box.min().func_177958_n() >> 4; chunkX <= this.box.max().func_177958_n() >> 4; ++chunkX) {
                for (int chunkZ = this.box.min().func_177952_p() >> 4; chunkZ <= this.box.max().func_177952_p() >> 4; ++chunkZ) {
                    ChunkCoordIntPair chunk = new ChunkCoordIntPair(chunkX, chunkZ);
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
                    chunks.add(chunk);
                }
            }
        }
        if (this.placedBy != null && !(this.placedBy instanceof FakePlayer)) {
            this.placedBy.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.buildcraft.quarry.chunkloadInfo", new Object[]{this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p(), chunks.size()}));
        }
    }

    public boolean func_145818_k_() {
        return false;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.func_174877_v() == null) {
            return null;
        }
        return new Box(this).extendToEncompass(this.box).extendToEncompass(this.miningBox).getBoundingBox();
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.Off || mode == IControllable.Mode.On || mode == IControllable.Mode.Loop;
    }

    @Override
    public boolean doDrop() {
        return false;
    }

    @Override
    public IPipeConnection.ConnectOverride overridePipeConnection(IPipeTile.PipeType type, EnumFacing with) {
        if (with == this.field_145850_b.func_180495_p(this.field_174879_c).func_177229_b(BuildCraftProperties.BLOCK_FACING)) {
            return IPipeConnection.ConnectOverride.DISCONNECT;
        }
        return type == IPipeTile.PipeType.ITEM ? IPipeConnection.ConnectOverride.CONNECT : IPipeConnection.ConnectOverride.DEFAULT;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[0];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return false;
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        TileQuarry server = CoreProxy.proxy.getServerTile(this);
        left.add("");
        left.add("  - IsServer = " + (server != this));
        left.add("  - Stage = " + (Object)((Object)server.getStage()));
        left.add("  - Mode = " + (Object)((Object)server.mode));
        if (server.builder == null) {
            left.add("  - Builder = null");
        } else {
            left.add("  - Builder");
            left.add("    - IsDone = " + server.builder.isDone(server));
            left.add("    - Min = " + BCStringUtils.vec3ToDispString((Vec3i)server.builder.min()));
            left.add("    - Max = " + BCStringUtils.vec3ToDispString((Vec3i)server.builder.max()));
            left.add("    - Successes = " + server.buildCallsS);
            left.add("    - Failures = " + server.buildCallsF);
        }
        if (server.box == null || !server.box.isInitialized()) {
            left.add("  - BuildingBox = null");
        } else {
            left.add("  - BuildingBox");
            left.add("    - Min = " + BCStringUtils.vec3ToDispString((Vec3i)server.box.min()));
            left.add("    - Max = " + BCStringUtils.vec3ToDispString((Vec3i)server.box.max()));
        }
        if (server.miningBox == null || !server.miningBox.isInitialized()) {
            left.add("  - MiningBox = null");
        } else {
            left.add("  - MiningBox");
            left.add("    - Min = " + BCStringUtils.vec3ToDispString((Vec3i)server.miningBox.min()));
            left.add("    - Max = " + BCStringUtils.vec3ToDispString((Vec3i)server.miningBox.max()));
        }
        left.add("  - Head = " + BCStringUtils.vec3ToDispString(server.headPos));
        left.add("  - Target = " + BCStringUtils.vec3ToDispString((Vec3i)server.target));
    }

    private static enum Stage {
        BUILDING,
        DIGGING,
        MOVING,
        IDLE,
        DONE;

    }
}

