/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.IAreaProvider;
import buildcraft.api.filler.FillerManager;
import buildcraft.api.properties.BuildCraftProperties;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.tiles.IControllable;
import buildcraft.api.tiles.IHasWork;
import buildcraft.core.Box;
import buildcraft.core.blueprints.BptBuilderTemplate;
import buildcraft.core.builders.TileAbstractBuilder;
import buildcraft.core.builders.patterns.FillerPattern;
import buildcraft.core.builders.patterns.PatternNone;
import buildcraft.core.lib.inventory.SimpleInventory;
import buildcraft.core.lib.network.command.CommandWriter;
import buildcraft.core.lib.network.command.ICommandReceiver;
import buildcraft.core.lib.network.command.PacketCommand;
import buildcraft.core.lib.utils.NetworkUtils;
import buildcraft.core.lib.utils.Utils;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3i;
import net.minecraftforge.fml.relauncher.Side;

public class TileFiller
extends TileAbstractBuilder
implements IHasWork,
IControllable,
ICommandReceiver,
IStatementContainer {
    private static int POWER_ACTIVATION = 500;
    public FillerPattern currentPattern = PatternNone.INSTANCE;
    public IStatementParameter[] patternParameters;
    private int patternLocked;
    private BptBuilderTemplate currentTemplate;
    private final Box box = new Box();
    private boolean done = false;
    private boolean excavate = true;
    private SimpleInventory inv = new SimpleInventory(27, "Filler", 64);
    private NBTTagCompound initNBT = null;

    public TileFiller() {
        this.setControlMode(IControllable.Mode.On);
        this.inv.addListener(this);
        this.box.kind = Box.Kind.STRIPES;
        this.initPatternParameters();
    }

    public boolean isExcavate() {
        return this.excavate;
    }

    @Override
    public void initialize() {
        super.initialize();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        IAreaProvider a = Utils.getNearbyAreaProvider(this.field_145850_b, this.field_174879_c);
        if (a != null) {
            this.box.initialize(a);
            a.removeFromWorld();
            this.sendNetworkUpdate();
        }
        if (this.currentTemplate == null) {
            this.initTemplate();
        }
        if (this.initNBT != null && this.currentTemplate != null) {
            this.currentTemplate.loadBuildStateToNBT(this.initNBT.func_74775_l("builderState"), this);
        }
        this.initNBT = null;
    }

    private void initTemplate() {
        if (this.currentPattern != null && this.box.size().func_177951_i((Vec3i)BlockPos.field_177992_a) > 0.0) {
            this.currentTemplate = this.currentPattern.getTemplateBuilder(this.box, this.func_145831_w(), this.patternParameters);
            this.currentTemplate.blueprint.excavate = this.excavate;
        }
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.patternLocked > 0) {
            --this.patternLocked;
        }
        if (this.mode == IControllable.Mode.Off) {
            return;
        }
        if (!this.box.isInitialized()) {
            return;
        }
        if (this.getBattery().getEnergyStored() < POWER_ACTIVATION) {
            return;
        }
        boolean oldDone = this.isDone();
        if (this.isDone()) {
            if (this.mode == IControllable.Mode.Loop) {
                this.setDone(false);
            } else {
                return;
            }
        }
        if (this.currentTemplate == null) {
            this.initTemplate();
        }
        if (this.currentTemplate != null) {
            this.currentTemplate.buildNextSlot(this.field_145850_b, this);
            if (this.currentTemplate.isDone(this)) {
                this.setDone(true);
                this.currentTemplate = null;
            }
        }
        if (oldDone != this.isDone()) {
            this.sendNetworkUpdate();
        }
    }

    public final int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inv.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amount) {
        return this.inv.func_70298_a(slot, amount);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inv.func_70299_a(slot, stack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inv.func_70304_b(slot);
    }

    @Override
    public String getInventoryName() {
        return "Filler";
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inv.readFromNBT(nbt);
        if (nbt.func_74764_b("pattern")) {
            this.currentPattern = (FillerPattern)FillerManager.registry.getPattern(nbt.func_74779_i("pattern"));
        }
        if (this.currentPattern == null) {
            this.currentPattern = PatternNone.INSTANCE;
        }
        if (nbt.func_74764_b("pp")) {
            this.readParametersFromNBT(nbt.func_74775_l("pp"));
        } else {
            this.initPatternParameters();
        }
        if (nbt.func_74764_b("box")) {
            this.box.initialize(nbt.func_74775_l("box"));
        }
        this.done = nbt.func_74767_n("done");
        this.excavate = nbt.func_74764_b("excavate") ? nbt.func_74767_n("excavate") : true;
        this.initNBT = (NBTTagCompound)nbt.func_74775_l("bpt").func_74737_b();
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inv.writeToNBT(nbt);
        if (this.currentPattern != null) {
            nbt.func_74778_a("pattern", this.currentPattern.getUniqueTag());
        }
        NBTTagCompound boxStore = new NBTTagCompound();
        this.box.writeToNBT(boxStore);
        nbt.func_74782_a("box", (NBTBase)boxStore);
        nbt.func_74757_a("done", this.done);
        nbt.func_74757_a("excavate", this.excavate);
        NBTTagCompound bptNBT = new NBTTagCompound();
        if (this.currentTemplate != null) {
            NBTTagCompound builderCpt = new NBTTagCompound();
            this.currentTemplate.saveBuildStateToNBT(builderCpt, this);
            bptNBT.func_74782_a("builderState", (NBTBase)builderCpt);
        }
        nbt.func_74782_a("bpt", (NBTBase)bptNBT);
        NBTTagCompound ppNBT = new NBTTagCompound();
        this.writeParametersToNBT(ppNBT);
        nbt.func_74782_a("pp", (NBTBase)ppNBT);
    }

    public int func_70297_j_() {
        return this.inv.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public void func_145843_s() {
        super.func_145843_s();
        this.destroy();
    }

    private void initPatternParameters() {
        this.patternParameters = new IStatementParameter[this.currentPattern.maxParameters()];
        for (int i = 0; i < this.currentPattern.minParameters(); ++i) {
            this.patternParameters[i] = this.currentPattern.createParameter(i);
        }
    }

    public boolean setPattern(FillerPattern pattern, boolean lock) {
        if (pattern != null && this.currentPattern != pattern) {
            this.currentPattern = pattern;
            this.currentTemplate = null;
            this.patternLocked = lock ? 2 : 0;
            this.setDone(false);
            this.initPatternParameters();
            this.sendNetworkUpdate();
            return true;
        }
        if (pattern != null && lock) {
            this.patternLocked = 2;
        }
        return false;
    }

    public boolean isPatternLocked() {
        return this.patternLocked > 0;
    }

    private void writeParametersToNBT(NBTTagCompound nbt) {
        IStatementParameter[] patternParameters = this.patternParameters;
        nbt.func_74774_a("length", (byte)(patternParameters != null ? patternParameters.length : 0));
        if (patternParameters != null) {
            for (int i = 0; i < patternParameters.length; ++i) {
                if (patternParameters[i] == null) continue;
                NBTTagCompound patternData = new NBTTagCompound();
                patternData.func_74778_a("kind", patternParameters[i].getUniqueTag());
                patternParameters[i].writeToNBT(patternData);
                nbt.func_74782_a("p" + i, (NBTBase)patternData);
            }
        }
    }

    private void readParametersFromNBT(NBTTagCompound nbt) {
        IStatementParameter[] patternParameters = new IStatementParameter[nbt.func_74771_c("length")];
        for (int i = 0; i < patternParameters.length; ++i) {
            if (!nbt.func_74764_b("p" + i)) continue;
            NBTTagCompound patternData = nbt.func_74775_l("p" + i);
            patternParameters[i] = StatementManager.createParameter(patternData.func_74779_i("kind"));
            patternParameters[i].readFromNBT(patternData);
        }
        this.patternParameters = patternParameters;
    }

    @Override
    public void writeData(ByteBuf data) {
        super.writeData(data);
        this.box.writeData(data);
        data.writeByte((this.done ? 1 : 0) | (this.excavate ? 2 : 0) | (this.isPatternLocked() ? 4 : 0));
        NetworkUtils.writeUTF(data, this.currentPattern.getUniqueTag());
        NBTTagCompound parameterData = new NBTTagCompound();
        this.writeParametersToNBT(parameterData);
        NetworkUtils.writeNBT(data, parameterData);
    }

    @Override
    public void readData(ByteBuf data) {
        super.readData(data);
        this.box.readData(data);
        short flags = data.readUnsignedByte();
        this.done = (flags & 1) > 0;
        this.excavate = (flags & 2) > 0;
        this.patternLocked = (flags & 4) > 0 ? 2 : 0;
        FillerPattern pattern = (FillerPattern)FillerManager.registry.getPattern(NetworkUtils.readUTF(data));
        NBTTagCompound parameterData = NetworkUtils.readNBT(data);
        this.readParametersFromNBT(parameterData);
        if (this.setPattern(pattern, this.isPatternLocked())) {
            this.field_145850_b.func_175689_h(this.field_174879_c);
        }
    }

    @Override
    public boolean hasWork() {
        return !this.isDone() && this.mode != IControllable.Mode.Off;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return true;
    }

    public void rpcSetPatternFromString(final String name) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setPattern", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NetworkUtils.writeUTF(data, name);
            }
        }));
    }

    @Override
    public void receiveCommand(String command, Side side, Object sender, ByteBuf stream) {
        super.receiveCommand(command, side, sender, stream);
        if (side.isServer()) {
            if ("setPattern".equals(command)) {
                if (this.isPatternLocked()) {
                    return;
                }
                String name = NetworkUtils.readUTF(stream);
                this.setPattern((FillerPattern)FillerManager.registry.getPattern(name), false);
                this.done = false;
            } else if ("setParameters".equals(command)) {
                if (this.isPatternLocked()) {
                    return;
                }
                NBTTagCompound patternData = NetworkUtils.readNBT(stream);
                this.readParametersFromNBT(patternData);
                this.currentTemplate = null;
                this.done = false;
            } else if ("setFlags".equals(command)) {
                this.excavate = stream.readBoolean();
                this.currentTemplate = null;
                this.sendNetworkUpdate();
                this.done = false;
            }
        }
    }

    @Override
    public Box getBox() {
        return this.box;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new Box(this).extendToEncompass(this.box).expand(50).getBoundingBox();
    }

    @Override
    public boolean isBuildingMaterialSlot(int i) {
        return true;
    }

    @Override
    public boolean acceptsControlMode(IControllable.Mode mode) {
        return mode == IControllable.Mode.On || mode == IControllable.Mode.Off || mode == IControllable.Mode.Loop;
    }

    @Override
    public TileEntity getTile() {
        return this;
    }

    public void rpcSetParameter(int i, IStatementParameter patternParameter) {
        BuildCraftCore.instance.sendToServer(new PacketCommand(this, "setParameters", new CommandWriter(){

            @Override
            public void write(ByteBuf data) {
                NBTTagCompound parameterData = new NBTTagCompound();
                TileFiller.this.writeParametersToNBT(parameterData);
                NetworkUtils.writeNBT(data, parameterData);
            }
        }));
    }

    private boolean isDone() {
        return this.done;
    }

    private void setDone(boolean done) {
        this.done = done;
        if (this.field_145850_b != null) {
            this.field_145850_b.func_175656_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177226_a(BuildCraftProperties.LED_DONE, (Comparable)Boolean.valueOf(done)));
        }
    }

    public void setExcavate(boolean excavate) {
        this.excavate = excavate;
    }
}

