/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.BuildCraftBuilders;
import buildcraft.api.library.LibraryTypeHandler;
import buildcraft.api.library.LibraryTypeHandlerNBT;
import buildcraft.builders.ItemBlueprint;
import buildcraft.builders.ItemBlueprintStandard;
import buildcraft.builders.ItemBlueprintTemplate;
import buildcraft.core.blueprints.BlueprintBase;
import buildcraft.core.blueprints.LibraryId;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LibraryBlueprintTypeHandler
extends LibraryTypeHandlerNBT {
    private final boolean isBlueprint;

    public LibraryBlueprintTypeHandler(boolean isBlueprint) {
        super(isBlueprint ? "bpt" : "tpl");
        this.isBlueprint = isBlueprint;
    }

    @Override
    public boolean isHandler(ItemStack stack, LibraryTypeHandler.HandlerType type) {
        if (this.isBlueprint) {
            return stack.func_77973_b() instanceof ItemBlueprintStandard && (type == LibraryTypeHandler.HandlerType.LOAD || ItemBlueprint.isContentReadable(stack));
        }
        return stack.func_77973_b() instanceof ItemBlueprintTemplate && (type == LibraryTypeHandler.HandlerType.LOAD || ItemBlueprint.isContentReadable(stack));
    }

    @Override
    public int getTextColor() {
        return this.isBlueprint ? 3166336 : 0;
    }

    @Override
    public String getName(ItemStack stack) {
        LibraryId id = ItemBlueprint.getId(stack);
        return id != null ? id.name : "<<CORRUPT>>";
    }

    @Override
    public ItemStack load(ItemStack stack, NBTTagCompound compound) {
        BlueprintBase blueprint = BlueprintBase.loadBluePrint((NBTTagCompound)compound.func_74737_b());
        blueprint.id.name = compound.func_74779_i("__filename");
        blueprint.id.extension = this.getOutputExtension();
        BuildCraftBuilders.serverDB.add(blueprint.id, compound);
        return blueprint.getStack();
    }

    @Override
    public boolean store(ItemStack stack, NBTTagCompound compound) {
        LibraryId id = ItemBlueprint.getId(stack);
        if (id == null) {
            return false;
        }
        NBTTagCompound nbt = BuildCraftBuilders.serverDB.load(id);
        if (nbt == null) {
            return false;
        }
        for (Object o : nbt.func_150296_c()) {
            compound.func_74782_a((String)o, nbt.func_74781_a((String)o));
        }
        id.write(compound);
        return true;
    }
}

