/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftFactory;
import buildcraft.BuildCraftMod;
import buildcraft.api.blueprints.BuilderAPI;
import buildcraft.api.blueprints.SchematicTile;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumColor;
import buildcraft.api.facades.FacadeAPI;
import buildcraft.api.gates.GateExpansions;
import buildcraft.api.gates.IGateExpansion;
import buildcraft.api.lists.ListRegistry;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.ITriggerInternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.api.transport.ICustomPipeConnection;
import buildcraft.api.transport.PipeConnectionAPI;
import buildcraft.api.transport.PipeManager;
import buildcraft.api.transport.PipeWire;
import buildcraft.core.BCCreativeTab;
import buildcraft.core.BCRegistry;
import buildcraft.core.CompatHooks;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.PowerMode;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.lib.items.ItemBuildCraft;
import buildcraft.core.lib.network.base.ChannelHandler;
import buildcraft.core.lib.network.base.PacketHandler;
import buildcraft.core.lib.utils.ColorUtils;
import buildcraft.core.lib.utils.ModelHelper;
import buildcraft.transport.BlockFilteredBuffer;
import buildcraft.transport.BlockGenericPipe;
import buildcraft.transport.FacadePluggable;
import buildcraft.transport.IDiamondPipe;
import buildcraft.transport.IMCHandlerTransport;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGateCopier;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.ItemPipeWire;
import buildcraft.transport.LensFilterHandler;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeActionProvider;
import buildcraft.transport.PipeColoringRecipe;
import buildcraft.transport.PipeEventBus;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.PipeTriggerProvider;
import buildcraft.transport.TileFilteredBuffer;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportGuiHandler;
import buildcraft.transport.TransportPipes_BC8;
import buildcraft.transport.TransportProxy;
import buildcraft.transport.TransportSiliconRecipes;
import buildcraft.transport.WireIconProvider;
import buildcraft.transport.block.BlockPipe;
import buildcraft.transport.client.model.FacadeItemModel;
import buildcraft.transport.client.model.GateItemModel;
import buildcraft.transport.client.model.LensPluggableModel;
import buildcraft.transport.client.model.ModelPowerAdapter;
import buildcraft.transport.client.model.PipeBlockModel;
import buildcraft.transport.client.model.PipeItemModel;
import buildcraft.transport.client.model.PlugPluggableModel;
import buildcraft.transport.client.render.PipeTransportRendererFluids;
import buildcraft.transport.gates.GateDefinition;
import buildcraft.transport.gates.GateExpansionLightSensor;
import buildcraft.transport.gates.GateExpansionPulsar;
import buildcraft.transport.gates.GateExpansionRedstoneFader;
import buildcraft.transport.gates.GateExpansionTimer;
import buildcraft.transport.gates.GatePluggable;
import buildcraft.transport.gates.ItemGate;
import buildcraft.transport.network.PacketFluidUpdate;
import buildcraft.transport.network.PacketPipeTransportItemStack;
import buildcraft.transport.network.PacketPipeTransportItemStackRequest;
import buildcraft.transport.network.PacketPipeTransportTraveler;
import buildcraft.transport.network.PacketPowerUpdate;
import buildcraft.transport.pipes.PipeFluidsClay;
import buildcraft.transport.pipes.PipeFluidsCobblestone;
import buildcraft.transport.pipes.PipeFluidsDiamond;
import buildcraft.transport.pipes.PipeFluidsEmerald;
import buildcraft.transport.pipes.PipeFluidsGold;
import buildcraft.transport.pipes.PipeFluidsIron;
import buildcraft.transport.pipes.PipeFluidsQuartz;
import buildcraft.transport.pipes.PipeFluidsSandstone;
import buildcraft.transport.pipes.PipeFluidsStone;
import buildcraft.transport.pipes.PipeFluidsVoid;
import buildcraft.transport.pipes.PipeFluidsWood;
import buildcraft.transport.pipes.PipeItemsClay;
import buildcraft.transport.pipes.PipeItemsCobblestone;
import buildcraft.transport.pipes.PipeItemsDaizuli;
import buildcraft.transport.pipes.PipeItemsDiamond;
import buildcraft.transport.pipes.PipeItemsEmerald;
import buildcraft.transport.pipes.PipeItemsEmzuli;
import buildcraft.transport.pipes.PipeItemsGold;
import buildcraft.transport.pipes.PipeItemsIron;
import buildcraft.transport.pipes.PipeItemsLapis;
import buildcraft.transport.pipes.PipeItemsObsidian;
import buildcraft.transport.pipes.PipeItemsQuartz;
import buildcraft.transport.pipes.PipeItemsSandstone;
import buildcraft.transport.pipes.PipeItemsStone;
import buildcraft.transport.pipes.PipeItemsStripes;
import buildcraft.transport.pipes.PipeItemsVoid;
import buildcraft.transport.pipes.PipeItemsWood;
import buildcraft.transport.pipes.PipePowerCobblestone;
import buildcraft.transport.pipes.PipePowerDiamond;
import buildcraft.transport.pipes.PipePowerEmerald;
import buildcraft.transport.pipes.PipePowerGold;
import buildcraft.transport.pipes.PipePowerIron;
import buildcraft.transport.pipes.PipePowerQuartz;
import buildcraft.transport.pipes.PipePowerSandstone;
import buildcraft.transport.pipes.PipePowerStone;
import buildcraft.transport.pipes.PipePowerWood;
import buildcraft.transport.pipes.PipeStructureCobblestone;
import buildcraft.transport.pluggable.ItemLens;
import buildcraft.transport.pluggable.ItemPlug;
import buildcraft.transport.pluggable.ItemPowerAdapter;
import buildcraft.transport.pluggable.LensPluggable;
import buildcraft.transport.pluggable.PlugPluggable;
import buildcraft.transport.pluggable.PowerAdapterPluggable;
import buildcraft.transport.schematics.BptPipeFiltered;
import buildcraft.transport.schematics.BptPipeRotatable;
import buildcraft.transport.schematics.SchematicPipe;
import buildcraft.transport.statements.ActionEnergyPulsar;
import buildcraft.transport.statements.ActionExtractionPreset;
import buildcraft.transport.statements.ActionParameterSignal;
import buildcraft.transport.statements.ActionPipeColor;
import buildcraft.transport.statements.ActionPipeDirection;
import buildcraft.transport.statements.ActionPowerLimiter;
import buildcraft.transport.statements.ActionRedstoneFaderOutput;
import buildcraft.transport.statements.ActionSignalOutput;
import buildcraft.transport.statements.ActionSingleEnergyPulse;
import buildcraft.transport.statements.ActionValve;
import buildcraft.transport.statements.TriggerClockTimer;
import buildcraft.transport.statements.TriggerLightSensor;
import buildcraft.transport.statements.TriggerParameterSignal;
import buildcraft.transport.statements.TriggerPipeContents;
import buildcraft.transport.statements.TriggerPipeSignal;
import buildcraft.transport.statements.TriggerRedstoneFaderInput;
import buildcraft.transport.stripes.PipeExtensionListener;
import buildcraft.transport.stripes.StripesHandlerArrow;
import buildcraft.transport.stripes.StripesHandlerBucket;
import buildcraft.transport.stripes.StripesHandlerDispenser;
import buildcraft.transport.stripes.StripesHandlerEntityInteract;
import buildcraft.transport.stripes.StripesHandlerHoe;
import buildcraft.transport.stripes.StripesHandlerMinecartDestroy;
import buildcraft.transport.stripes.StripesHandlerPipeWires;
import buildcraft.transport.stripes.StripesHandlerPipes;
import buildcraft.transport.stripes.StripesHandlerPlaceBlock;
import buildcraft.transport.stripes.StripesHandlerPlant;
import buildcraft.transport.stripes.StripesHandlerRightClick;
import buildcraft.transport.stripes.StripesHandlerShears;
import buildcraft.transport.stripes.StripesHandlerUse;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.RecipeSorter;
import net.minecraftforge.oredict.ShapedOreRecipe;

@Mod(version="7.2.7", modid="BuildCraft|Transport", name="Buildcraft Transport", dependencies="required-after:BuildCraft|Core@7.2.7", acceptedMinecraftVersions="[1.8.9]")
public class BuildCraftTransport
extends BuildCraftMod {
    public static final boolean NEPTUNE_TESTING = "7.2.7".contains("@");
    @Mod.Instance(value="BuildCraft|Transport")
    public static BuildCraftTransport instance;
    public static float pipeDurability;
    public static int pipeFluidsBaseFlowRate;
    public static boolean facadeTreatBlacklistAsWhitelist;
    public static boolean additionalWaterproofingRecipe;
    public static boolean facadeForceNonLaserRecipe;
    public static boolean showAllFacadesCreative;
    public static BlockGenericPipe genericPipeBlock;
    public static BlockFilteredBuffer filteredBufferBlock;
    public static BlockPipe pipeBlock;
    public static Item pipeWaterproof;
    public static ItemGate pipeGate;
    public static Item pipeWire;
    public static Item plugItem;
    public static ItemLens lensItem;
    public static Item powerAdapterItem;
    public static Item pipeStructureCobblestone;
    public static Item gateCopier;
    public static ItemFacade facadeItem;
    public static Item pipeItemsWood;
    public static Item pipeItemsEmerald;
    public static Item pipeItemsStone;
    public static Item pipeItemsCobblestone;
    public static Item pipeItemsIron;
    public static Item pipeItemsQuartz;
    public static Item pipeItemsGold;
    public static Item pipeItemsDiamond;
    public static Item pipeItemsObsidian;
    public static Item pipeItemsLapis;
    public static Item pipeItemsDaizuli;
    public static Item pipeItemsVoid;
    public static Item pipeItemsSandstone;
    public static Item pipeItemsEmzuli;
    public static Item pipeItemsStripes;
    public static Item pipeItemsClay;
    public static Item pipeFluidsWood;
    public static Item pipeFluidsCobblestone;
    public static Item pipeFluidsStone;
    public static Item pipeFluidsQuartz;
    public static Item pipeFluidsIron;
    public static Item pipeFluidsGold;
    public static Item pipeFluidsVoid;
    public static Item pipeFluidsSandstone;
    public static Item pipeFluidsEmerald;
    public static Item pipeFluidsDiamond;
    public static Item pipeFluidsClay;
    public static Item pipePowerWood;
    public static Item pipePowerCobblestone;
    public static Item pipePowerStone;
    public static Item pipePowerQuartz;
    public static Item pipePowerIron;
    public static Item pipePowerGold;
    public static Item pipePowerDiamond;
    public static Item pipePowerEmerald;
    public static Item pipePowerSandstone;
    public static String[] facadeBlacklist;
    public static ITriggerInternal triggerLightSensorBright;
    public static ITriggerInternal triggerLightSensorDark;
    public static ITriggerInternal[] triggerPipe;
    public static ITriggerInternal[] triggerPipeWireActive;
    public static ITriggerInternal[] triggerPipeWireInactive;
    public static ITriggerInternal[] triggerTimer;
    public static ITriggerInternal[] triggerRedstoneLevel;
    public static IActionInternal[] actionPipeWire;
    public static IActionInternal actionEnergyPulser;
    public static IActionInternal actionSingleEnergyPulse;
    public static IActionInternal[] actionPipeColor;
    public static IActionInternal[] actionPipeDirection;
    public static IActionInternal[] actionPowerLimiter;
    public static IActionInternal[] actionRedstoneLevel;
    public static IActionInternal actionExtractionPresetRed;
    public static IActionInternal actionExtractionPresetBlue;
    public static IActionInternal actionExtractionPresetGreen;
    public static IActionInternal actionExtractionPresetYellow;
    public static IActionInternal[] actionValve;
    public static boolean debugPrintFacadeList;
    public static float gateCostMultiplier;
    public static PipeExtensionListener pipeExtensionListener;
    private static LinkedList<PipeRecipe> pipeRecipes;
    private static ChannelHandler transportChannelHandler;
    public PipeIconProvider pipeIconProvider = new PipeIconProvider();
    public WireIconProvider wireIconProvider = new WireIconProvider();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        new BCCreativeTab("pipes");
        if (NEPTUNE_TESTING) {
            new BCCreativeTab("neptune");
        }
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            new BCCreativeTab("gates");
        }
        try {
            void var2_6;
            BuildCraftCore.mainConfigManager.register("experimental.kinesisLossMode", "lossless", "Allowed values: lossless, absolute, percentage. Defaults to lossless.", ConfigManager.RestartRequirement.WORLD);
            BuildCraftCore.mainConfigManager.register("experimental.kinesisCanExplode", false, "Can kinesis pipes explode when over their RF/t rating?", ConfigManager.RestartRequirement.NONE);
            BuildCraftCore.mainConfigManager.register("general.pipes.hardness", DefaultProps.PIPES_DURABILITY, "How hard to break should a pipe be?", ConfigManager.RestartRequirement.NONE);
            BuildCraftCore.mainConfigManager.register("general.pipes.baseFluidRate", DefaultProps.PIPES_FLUIDS_BASE_FLOW_RATE, "What should the base flow rate of a fluid pipe be?", ConfigManager.RestartRequirement.GAME).setMinValue(1).setMaxValue(40);
            BuildCraftCore.mainConfigManager.register("debug.printFacadeList", false, "Print a list of all registered facades.", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.facadeShowAllInCreative", true, "Should all BC facades be shown in Creative/NEI, or just a few carefully chosen ones?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.slimeballWaterproofRecipe", false, "Should I enable an alternate Waterproof recipe, based on slimeballs?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("power.gateCostMultiplier", 1.0, "What should be the multiplier of all gate power costs?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.facadeBlacklist", new String[]{((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150378_br)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150349_c)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150362_t)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150361_u)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150428_aP)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150374_bv)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150474_ac)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150418_aU)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150379_bu)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150334_T)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150373_bw)).toString(), ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)Blocks.field_150360_v)).toString()}, "What block types should be blacklisted from being a facade?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.facadeBlacklistAsWhitelist", false, "Should the blacklist be treated as a whitelist instead?", ConfigManager.RestartRequirement.GAME);
            BuildCraftCore.mainConfigManager.register("general.pipes.facadeNoLaserRecipe", false, "Should non-laser (crafting table) facade recipes be forced?", ConfigManager.RestartRequirement.GAME);
            this.reloadConfig(ConfigManager.RestartRequirement.GAME);
            if (showAllFacadesCreative) {
                new BCCreativeTab("facades");
            }
            filteredBufferBlock = new BlockFilteredBuffer();
            BCRegistry.INSTANCE.registerBlock(filteredBufferBlock.func_149663_c("filteredBufferBlock"), false);
            pipeWaterproof = new ItemBuildCraft();
            pipeWaterproof.func_77655_b("pipeWaterproof");
            BCRegistry.INSTANCE.registerItem(pipeWaterproof, false);
            genericPipeBlock = (BlockGenericPipe)CompatHooks.INSTANCE.getBlock(BlockGenericPipe.class);
            BCRegistry.INSTANCE.registerBlock(genericPipeBlock.func_149663_c("pipeBlock"), ItemBlock.class, true);
            pipeItemsWood = BuildCraftTransport.buildPipe(PipeItemsWood.class, "plankWood", "blockGlassColorless", "plankWood");
            pipeItemsEmerald = BuildCraftTransport.buildPipe(PipeItemsEmerald.class, "gemEmerald", "blockGlassColorless", "gemEmerald");
            pipeItemsCobblestone = BuildCraftTransport.buildPipe(PipeItemsCobblestone.class, "cobblestone", "blockGlassColorless", "cobblestone");
            pipeItemsStone = BuildCraftTransport.buildPipe(PipeItemsStone.class, "stone", "blockGlassColorless", "stone");
            pipeItemsQuartz = BuildCraftTransport.buildPipe(PipeItemsQuartz.class, "blockQuartz", "blockGlassColorless", "blockQuartz");
            pipeItemsIron = BuildCraftTransport.buildPipe(PipeItemsIron.class, "ingotIron", "blockGlassColorless", "ingotIron");
            pipeItemsGold = BuildCraftTransport.buildPipe(PipeItemsGold.class, "ingotGold", "blockGlassColorless", "ingotGold");
            pipeItemsDiamond = BuildCraftTransport.buildPipe(PipeItemsDiamond.class, "gemDiamond", "blockGlassColorless", "gemDiamond");
            pipeItemsObsidian = BuildCraftTransport.buildPipe(PipeItemsObsidian.class, Blocks.field_150343_Z, "blockGlassColorless", Blocks.field_150343_Z);
            pipeItemsLapis = BuildCraftTransport.buildPipe(PipeItemsLapis.class, "blockLapis", "blockGlassColorless", "blockLapis");
            pipeItemsDaizuli = BuildCraftTransport.buildPipe(PipeItemsDaizuli.class, "blockLapis", "blockGlassColorless", "gemDiamond");
            pipeItemsSandstone = BuildCraftTransport.buildPipe(PipeItemsSandstone.class, Blocks.field_150322_A, "blockGlassColorless", Blocks.field_150322_A);
            pipeItemsVoid = BuildCraftTransport.buildPipe(PipeItemsVoid.class, "dyeBlack", "blockGlassColorless", "dustRedstone");
            pipeItemsEmzuli = BuildCraftTransport.buildPipe(PipeItemsEmzuli.class, "blockLapis", "blockGlassColorless", "gemEmerald");
            pipeItemsStripes = BuildCraftTransport.buildPipe(PipeItemsStripes.class, "gearGold", "blockGlassColorless", "gearGold");
            pipeItemsClay = BuildCraftTransport.buildPipe(PipeItemsClay.class, Blocks.field_150435_aG, "blockGlassColorless", Blocks.field_150435_aG);
            pipeFluidsWood = BuildCraftTransport.buildPipe(PipeFluidsWood.class, pipeWaterproof, pipeItemsWood);
            pipeFluidsCobblestone = BuildCraftTransport.buildPipe(PipeFluidsCobblestone.class, pipeWaterproof, pipeItemsCobblestone);
            pipeFluidsStone = BuildCraftTransport.buildPipe(PipeFluidsStone.class, pipeWaterproof, pipeItemsStone);
            pipeFluidsQuartz = BuildCraftTransport.buildPipe(PipeFluidsQuartz.class, pipeWaterproof, pipeItemsQuartz);
            pipeFluidsIron = BuildCraftTransport.buildPipe(PipeFluidsIron.class, pipeWaterproof, pipeItemsIron);
            pipeFluidsGold = BuildCraftTransport.buildPipe(PipeFluidsGold.class, pipeWaterproof, pipeItemsGold);
            pipeFluidsEmerald = BuildCraftTransport.buildPipe(PipeFluidsEmerald.class, pipeWaterproof, pipeItemsEmerald);
            pipeFluidsDiamond = BuildCraftTransport.buildPipe(PipeFluidsDiamond.class, pipeWaterproof, pipeItemsDiamond);
            pipeFluidsSandstone = BuildCraftTransport.buildPipe(PipeFluidsSandstone.class, pipeWaterproof, pipeItemsSandstone);
            pipeFluidsVoid = BuildCraftTransport.buildPipe(PipeFluidsVoid.class, pipeWaterproof, pipeItemsVoid);
            pipeFluidsClay = BuildCraftTransport.buildPipe(PipeFluidsClay.class, pipeWaterproof, pipeItemsClay);
            pipePowerWood = BuildCraftTransport.buildPipe(PipePowerWood.class, "dustRedstone", pipeItemsWood);
            pipePowerCobblestone = BuildCraftTransport.buildPipe(PipePowerCobblestone.class, "dustRedstone", pipeItemsCobblestone);
            pipePowerStone = BuildCraftTransport.buildPipe(PipePowerStone.class, "dustRedstone", pipeItemsStone);
            pipePowerQuartz = BuildCraftTransport.buildPipe(PipePowerQuartz.class, "dustRedstone", pipeItemsQuartz);
            pipePowerIron = BuildCraftTransport.buildPipe(PipePowerIron.class, "dustRedstone", pipeItemsIron);
            pipePowerGold = BuildCraftTransport.buildPipe(PipePowerGold.class, "dustRedstone", pipeItemsGold);
            pipePowerDiamond = BuildCraftTransport.buildPipe(PipePowerDiamond.class, "dustRedstone", pipeItemsDiamond);
            pipePowerEmerald = BuildCraftTransport.buildPipe(PipePowerEmerald.class, "dustRedstone", pipeItemsEmerald);
            pipePowerSandstone = BuildCraftTransport.buildPipe(PipePowerSandstone.class, "dustRedstone", pipeItemsSandstone);
            pipeStructureCobblestone = BuildCraftTransport.buildPipe(PipeStructureCobblestone.class, Blocks.field_150347_e, Blocks.field_150351_n, Blocks.field_150347_e);
            pipeWire = new ItemPipeWire();
            BCRegistry.INSTANCE.registerItem(pipeWire, false);
            PipeWire.item = pipeWire;
            pipeGate = new ItemGate();
            pipeGate.func_77655_b("pipeGate");
            BCRegistry.INSTANCE.registerItem(pipeGate, false);
            facadeItem = new ItemFacade();
            facadeItem.func_77655_b("pipeFacade");
            BCRegistry.INSTANCE.registerItem(facadeItem, false);
            FacadeAPI.facadeItem = facadeItem;
            plugItem = new ItemPlug();
            plugItem.func_77655_b("pipePlug");
            BCRegistry.INSTANCE.registerItem(plugItem, false);
            lensItem = new ItemLens();
            lensItem.func_77655_b("pipeLens");
            BCRegistry.INSTANCE.registerItem(lensItem, false);
            powerAdapterItem = new ItemPowerAdapter();
            powerAdapterItem.func_77655_b("pipePowerAdapter");
            BCRegistry.INSTANCE.registerItem(powerAdapterItem, false);
            gateCopier = new ItemGateCopier();
            BCRegistry.INSTANCE.registerItem(gateCopier, false);
            for (TriggerPipeContents.PipeContents pipeContents : TriggerPipeContents.PipeContents.values()) {
                BuildCraftTransport.triggerPipe[pipeContents.ordinal()] = new TriggerPipeContents(pipeContents);
            }
            for (PipeWire pipeWire : PipeWire.values()) {
                BuildCraftTransport.triggerPipeWireActive[pipeWire.ordinal()] = new TriggerPipeSignal(true, pipeWire);
                BuildCraftTransport.triggerPipeWireInactive[pipeWire.ordinal()] = new TriggerPipeSignal(false, pipeWire);
                BuildCraftTransport.actionPipeWire[pipeWire.ordinal()] = new ActionSignalOutput(pipeWire);
            }
            for (TriggerClockTimer.Time time : TriggerClockTimer.Time.VALUES) {
                BuildCraftTransport.triggerTimer[time.ordinal()] = new TriggerClockTimer(time);
            }
            boolean bl = false;
            while (var2_6 < triggerRedstoneLevel.length) {
                BuildCraftTransport.triggerRedstoneLevel[var2_6] = new TriggerRedstoneFaderInput((int)(var2_6 + true));
                BuildCraftTransport.actionRedstoneLevel[var2_6] = new ActionRedstoneFaderOutput((int)(var2_6 + true));
                ++var2_6;
            }
            for (EnumDyeColor enumDyeColor : EnumDyeColor.values()) {
                BuildCraftTransport.actionPipeColor[enumDyeColor.ordinal()] = new ActionPipeColor(enumDyeColor);
            }
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                BuildCraftTransport.actionPipeDirection[enumFacing.ordinal()] = new ActionPipeDirection(enumFacing);
            }
            for (ActionValve.ValveState valveState : ActionValve.ValveState.VALUES) {
                BuildCraftTransport.actionValve[valveState.ordinal()] = new ActionValve(valveState);
            }
            for (PowerMode powerMode : PowerMode.VALUES) {
                BuildCraftTransport.actionPowerLimiter[powerMode.ordinal()] = new ActionPowerLimiter(powerMode);
            }
            triggerLightSensorBright = new TriggerLightSensor(true);
            triggerLightSensorDark = new TriggerLightSensor(false);
        }
        finally {
            BuildCraftCore.mainConfiguration.save();
        }
        InterModComms.registerHandler(new IMCHandlerTransport());
        if (NEPTUNE_TESTING) {
            pipeBlock = new BlockPipe();
            pipeBlock.func_149663_c("pipeBlockNeptune");
            BCRegistry.INSTANCE.registerBlock(pipeBlock, null, true);
            TransportPipes_BC8.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        transportChannelHandler = new ChannelHandler();
        MinecraftForge.EVENT_BUS.register((Object)this);
        transportChannelHandler.registerPacketType(PacketFluidUpdate.class);
        transportChannelHandler.registerPacketType(PacketPipeTransportItemStack.class);
        transportChannelHandler.registerPacketType(PacketPipeTransportItemStackRequest.class);
        transportChannelHandler.registerPacketType(PacketPipeTransportTraveler.class);
        transportChannelHandler.registerPacketType(PacketPowerUpdate.class);
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-TRANSPORT", new io.netty.channel.ChannelHandler[]{transportChannelHandler, new PacketHandler()});
        TransportProxy.proxy.registerTileEntities();
        BuilderAPI.schematicRegistry.registerSchematicBlock(genericPipeBlock, SchematicPipe.class, new Object[0]);
        BuilderAPI.schematicRegistry.registerSchematicBlock(filteredBufferBlock, SchematicTile.class, new Object[0]);
        new BptPipeRotatable(pipeItemsWood);
        new BptPipeRotatable(pipeFluidsWood);
        new BptPipeRotatable(pipeItemsIron);
        new BptPipeRotatable(pipeFluidsIron);
        new BptPipeRotatable(pipeItemsEmerald);
        new BptPipeRotatable(pipeFluidsEmerald);
        new BptPipeRotatable(pipeItemsDaizuli);
        new BptPipeRotatable(pipeItemsEmzuli);
        for (Item item : BlockGenericPipe.pipes.keySet()) {
            Class<? extends Pipe<?>> klazz = BlockGenericPipe.pipes.get(item);
            if (!IDiamondPipe.class.isAssignableFrom(klazz)) continue;
            new BptPipeFiltered(item);
        }
        PipeEventBus.registerGlobalHandler(new LensFilterHandler());
        BCCreativeTab.get("pipes").setIcon(new ItemStack(pipeItemsDiamond, 1));
        if (NEPTUNE_TESTING) {
            BCCreativeTab.get("neptune").setIcon(new ItemStack(Items.field_151105_aU));
        }
        if (showAllFacadesCreative) {
            BCCreativeTab.get("facades").setIcon(facadeItem.getFacadeForBlock(Blocks.field_150336_V.func_176223_P()));
        }
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            BCCreativeTab.get("gates").setIcon(ItemGate.makeGateItem(GateDefinition.GateMaterial.DIAMOND, GateDefinition.GateLogic.AND));
        }
        StatementManager.registerParameterClass(TriggerParameterSignal.class);
        StatementManager.registerParameterClass(ActionParameterSignal.class);
        StatementManager.registerTriggerProvider(new PipeTriggerProvider());
        StatementManager.registerActionProvider(new PipeActionProvider());
        PipeManager.registerStripesHandler(new StripesHandlerRightClick(), Short.MIN_VALUE);
        PipeManager.registerStripesHandler(new StripesHandlerDispenser(), -49152);
        PipeManager.registerStripesHandler(new StripesHandlerPlant(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerBucket(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerArrow(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerShears(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerPipes(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerPipeWires(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerEntityInteract(), 0);
        PipeManager.registerStripesHandler(new StripesHandlerPlaceBlock(), -65536);
        PipeManager.registerStripesHandler(new StripesHandlerUse(), -131072);
        PipeManager.registerStripesHandler(new StripesHandlerHoe(), 0);
        StripesHandlerDispenser.items.add(ItemMinecart.class);
        StripesHandlerRightClick.items.add(Items.field_151110_aK);
        StripesHandlerRightClick.items.add(Items.field_151126_ay);
        StripesHandlerRightClick.items.add(Items.field_151062_by);
        StripesHandlerUse.items.add(Items.field_151152_bP);
        PipeManager.registerStripesHandler(new StripesHandlerMinecartDestroy(), 0);
        PipeManager.registerPipePluggable(FacadePluggable.class, "facade");
        PipeManager.registerPipePluggable(GatePluggable.class, "gate");
        PipeManager.registerPipePluggable(LensPluggable.class, "lens");
        PipeManager.registerPipePluggable(PlugPluggable.class, "plug");
        PipeManager.registerPipePluggable(PowerAdapterPluggable.class, "powerAdapter");
        GateExpansions.registerExpansion(GateExpansionPulsar.INSTANCE);
        GateExpansions.registerExpansion(GateExpansionTimer.INSTANCE);
        GateExpansions.registerExpansion(GateExpansionRedstoneFader.INSTANCE);
        GateExpansions.registerExpansion(GateExpansionLightSensor.INSTANCE, new ItemStack((Block)Blocks.field_150453_bW));
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftTransport.loadRecipes();
        }
        TransportProxy.proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new TransportGuiHandler());
        ICustomPipeConnection smallerBlockConnection = (world, pos, face, state) -> face == EnumFacing.UP ? 0.0f : 0.125f;
        PipeConnectionAPI.registerConnection((Block)Blocks.field_150486_ae, smallerBlockConnection);
        PipeConnectionAPI.registerConnection(Blocks.field_150447_bR, smallerBlockConnection);
        PipeConnectionAPI.registerConnection((Block)Blocks.field_150438_bZ, smallerBlockConnection);
        if (NEPTUNE_TESTING) {
            TransportPipes_BC8.init();
        }
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        facadeItem.initialize();
        if (debugPrintFacadeList) {
            try {
                PrintWriter writer = new PrintWriter("FacadeDebug.txt", "UTF-8");
                writer.println("*** REGISTERED FACADES ***");
                for (ItemStack stack : ItemFacade.allFacades) {
                    if (facadeItem.getBlockStatesForFacade(stack).length <= 0) continue;
                    writer.println(facadeItem.getBlockStatesForFacade(stack)[0]);
                }
                writer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (NEPTUNE_TESTING) {
            TransportPipes_BC8.postInit();
        }
        ListRegistry.itemClassAsType.add(ItemPipe.class);
        ListRegistry.itemClassAsType.add(ItemGate.class);
        ListRegistry.itemClassAsType.add(ItemFacade.class);
        ListRegistry.itemClassAsType.add(ItemPipeWire.class);
    }

    public void reloadConfig(ConfigManager.RestartRequirement restartType) {
        if (restartType == ConfigManager.RestartRequirement.GAME) {
            facadeTreatBlacklistAsWhitelist = BuildCraftCore.mainConfigManager.get("general.pipes.facadeBlacklistAsWhitelist").getBoolean();
            facadeBlacklist = BuildCraftCore.mainConfigManager.get("general.pipes.facadeBlacklist").getStringList();
            gateCostMultiplier = (float)BuildCraftCore.mainConfigManager.get("power.gateCostMultiplier").getDouble();
            additionalWaterproofingRecipe = BuildCraftCore.mainConfigManager.get("general.pipes.slimeballWaterproofRecipe").getBoolean();
            debugPrintFacadeList = BuildCraftCore.mainConfigManager.get("debug.printFacadeList").getBoolean();
            pipeFluidsBaseFlowRate = BuildCraftCore.mainConfigManager.get("general.pipes.baseFluidRate").getInt();
            facadeForceNonLaserRecipe = BuildCraftCore.mainConfigManager.get("general.pipes.facadeNoLaserRecipe").getBoolean();
            showAllFacadesCreative = BuildCraftCore.mainConfigManager.get("general.pipes.facadeShowAllInCreative").getBoolean();
            this.reloadConfig(ConfigManager.RestartRequirement.WORLD);
        } else if (restartType == ConfigManager.RestartRequirement.WORLD) {
            PipeTransportPower.lossMode = PipeTransportPower.LossMode.LOSSLESS;
            String lossMode = BuildCraftCore.mainConfigManager.get("experimental.kinesisLossMode").getString();
            if (lossMode != null && lossMode.length() > 0) {
                for (PipeTransportPower.LossMode mode : PipeTransportPower.LossMode.values()) {
                    if (!mode.name().toLowerCase().equals(lossMode.toLowerCase())) continue;
                    PipeTransportPower.lossMode = mode;
                    break;
                }
            }
            this.reloadConfig(ConfigManager.RestartRequirement.NONE);
        } else {
            PipeTransportPower.canExplode = BuildCraftCore.mainConfigManager.get("experimental.kinesisCanExplode").getBoolean();
            pipeDurability = (float)BuildCraftCore.mainConfigManager.get("general.pipes.hardness").getDouble();
            if (BuildCraftCore.mainConfiguration.hasChanged()) {
                BuildCraftCore.mainConfiguration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("BuildCraft|Core".equals(event.modID)) {
            this.reloadConfig(event.isWorldRunning ? ConfigManager.RestartRequirement.NONE : ConfigManager.RestartRequirement.WORLD);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureHook(TextureStitchEvent.Pre event) {
        for (ItemPipe i : BlockGenericPipe.pipes.keySet()) {
            Pipe<?> dummyPipe = BlockGenericPipe.createPipe(i);
            if (dummyPipe == null) continue;
            dummyPipe.getIconProvider().registerIcons(event.map);
        }
        WireIconProvider.registerIcons(event.map);
        for (GateDefinition.GateMaterial gateMaterial : GateDefinition.GateMaterial.VALUES) {
            gateMaterial.registerBlockIcon(event.map);
        }
        for (Enum enum_ : GateDefinition.GateLogic.VALUES) {
            ((GateDefinition.GateLogic)enum_).registerBlockIcon(event.map);
        }
        for (IGateExpansion expansion : GateExpansions.getExpansions()) {
            expansion.textureStitch(event.map);
        }
        TriggerParameterSignal.registerIcons(event);
        ActionParameterSignal.registerIcons(event);
    }

    @Mod.EventHandler
    public void serverLoading(FMLServerStartingEvent event) {
        pipeExtensionListener = new PipeExtensionListener();
        MinecraftForge.EVENT_BUS.register((Object)pipeExtensionListener);
    }

    @Mod.EventHandler
    public void serverUnloading(FMLServerStoppingEvent event) {
        for (WorldServer w : DimensionManager.getWorlds()) {
            pipeExtensionListener.tick(new TickEvent.WorldTickEvent(Side.SERVER, TickEvent.Phase.END, (World)w));
        }
        MinecraftForge.EVENT_BUS.unregister((Object)pipeExtensionListener);
        pipeExtensionListener = null;
    }

    public static void loadRecipes() {
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 2)});
        if (additionalWaterproofingRecipe) {
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(pipeWaterproof, 1), (Object[])new Object[]{new ItemStack(Items.field_151123_aH)});
        }
        for (PipeRecipe pipe : pipeRecipes) {
            if (pipe.isShapeless) {
                BCRegistry.INSTANCE.addShapelessRecipe(pipe.result, pipe.input);
                continue;
            }
            BCRegistry.INSTANCE.addCraftingRecipe(pipe.result, pipe.input);
        }
        GameRegistry.addRecipe((IRecipe)new PipeColoringRecipe());
        RecipeSorter.register((String)"buildcraft:pipecoloring", PipeColoringRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"after:minecraft:shapeless");
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)filteredBufferBlock, 1), "wdw", "wcw", "wpw", Character.valueOf('w'), "plankWood", Character.valueOf('d'), pipeItemsDiamond, Character.valueOf('c'), "chestWood", Character.valueOf('p'), Blocks.field_150331_J);
        GameRegistry.addRecipe((IRecipe)new ItemFacade.FacadeRecipe(facadeItem));
        RecipeSorter.register((String)"facadeTurningHelper", ItemFacade.FacadeRecipe.class, (RecipeSorter.Category)RecipeSorter.Category.SHAPELESS, (String)"");
        GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(plugItem, 4), (Object[])new Object[]{new ItemStack(pipeStructureCobblestone)});
        GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(powerAdapterItem, 4), new Object[]{"scs", "sbs", "sas", Character.valueOf('s'), pipeStructureCobblestone, Character.valueOf('a'), Items.field_151137_ax, Character.valueOf('b'), "gearStone", Character.valueOf('c'), "ingotGold"}));
        if (Loader.isModLoaded((String)"BuildCraft|Silicon")) {
            TransportSiliconRecipes.loadSiliconRecipes();
        } else {
            BCLog.logger.warn("**********************************************");
            BCLog.logger.warn("*   You are using the BuildCraft Transport   *");
            BCLog.logger.warn("*  module WITHOUT the Silicon module. Gates  *");
            BCLog.logger.warn("*           will not be available.           *");
            BCLog.logger.warn("**********************************************");
            for (int i = 0; i < 16; ++i) {
                String dye = ColorUtils.getOreDictionaryName(15 - i);
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)lensItem, 8, i), new Object[]{"OSO", "SGS", "OSO", Character.valueOf('O'), "ingotIron", Character.valueOf('S'), dye, Character.valueOf('G'), "blockGlass"}));
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack((Item)lensItem, 8, i + 16), new Object[]{"OSO", "SGS", "OSO", Character.valueOf('O'), Blocks.field_150411_aY, Character.valueOf('S'), dye, Character.valueOf('G'), "blockGlass"}));
            }
        }
    }

    public static void loadComplexRefiningRecipes() {
        for (PipeRecipe pipe : pipeRecipes) {
            Object[] newInput = new Object[pipe.input.length];
            System.arraycopy(pipe.input, 0, newInput, 0, pipe.input.length);
            boolean changed = false;
            for (int i = 0; i < newInput.length; ++i) {
                Object o = newInput[i];
                if (!"blockGlassColorless".equals(o)) continue;
                newInput[i] = BuildCraftFactory.plasticSheetItem;
            }
            if (!changed) continue;
            if (pipe.isShapeless) {
                BCRegistry.INSTANCE.addShapelessRecipe(pipe.result, newInput);
                continue;
            }
            BCRegistry.INSTANCE.addCraftingRecipe(pipe.result, newInput);
        }
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    public static Item buildPipe(Class<? extends Pipe<?>> clas, Object ... ingredients) {
        return BuildCraftTransport.buildPipe(clas, BCCreativeTab.get("pipes"), ingredients);
    }

    @Deprecated
    public static Item buildPipe(Class<? extends Pipe<?>> clas, String descr, BCCreativeTab creativeTab, Object ... ingredients) {
        return BuildCraftTransport.buildPipe(clas, creativeTab, ingredients);
    }

    public static Item buildPipe(Class<? extends Pipe<?>> clas, BCCreativeTab creativeTab, Object ... ingredients) {
        ItemPipe res;
        block6: {
            block5: {
                if (!BCRegistry.INSTANCE.isEnabled("pipes", clas.getSimpleName())) {
                    return null;
                }
                res = BlockGenericPipe.registerPipe(clas, creativeTab);
                res.func_77655_b(clas.getSimpleName());
                for (Object o : ingredients) {
                    if (o != null) continue;
                    return res;
                }
                if (ingredients.length != 3) break block5;
                for (int i = 0; i < 17; ++i) {
                    PipeRecipe recipe = new PipeRecipe();
                    Object glass = i == 0 ? ingredients[1] : "blockGlass" + EnumColor.fromId(15 - (i - 1)).func_176610_l();
                    recipe.result = new ItemStack((Item)res, 8, i);
                    recipe.input = new Object[]{"ABC", Character.valueOf('A'), ingredients[0], Character.valueOf('B'), glass, Character.valueOf('C'), ingredients[2]};
                    pipeRecipes.add(recipe);
                }
                break block6;
            }
            if (ingredients.length != 2) break block6;
            for (int i = 0; i < 17; ++i) {
                PipeRecipe recipe = new PipeRecipe();
                Object left = ingredients[0];
                Object right = ingredients[1];
                if (ingredients[1] instanceof ItemPipe) {
                    right = new ItemStack((Item)right, 1, i);
                }
                recipe.isShapeless = true;
                recipe.result = new ItemStack((Item)res, 1, i);
                recipe.input = new Object[]{left, right};
                pipeRecipes.add(recipe);
                if (!(ingredients[1] instanceof ItemPipe) || clas == PipeStructureCobblestone.class) continue;
                PipeRecipe uncraft = new PipeRecipe();
                uncraft.isShapeless = true;
                uncraft.input = new Object[]{recipe.result};
                uncraft.result = (ItemStack)right;
                pipeRecipes.add(uncraft);
            }
        }
        return res;
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileGenericPipe.class.getCanonicalName());
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileFilteredBuffer.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        BCLog.logger.info("Transport|Remap " + System.identityHashCode(event));
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            String name = mapping.name;
            BCLog.logger.info("        - " + name);
            if (mapping.type == GameRegistry.Type.ITEM && mapping.name.equals("BuildCraft|Transport:robotStation")) {
                mapping.remap((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("BuildCraft|Robotics:robotStation")));
            }
            if (!mapping.resourceLocation.func_110624_b().equals("BuildCraft|Transport") || !mapping.name.toLowerCase(Locale.ROOT).contains("pipe")) continue;
            mapping.remap((Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(mapping.name.replace("item.", ""))));
            BCLog.logger.info("          - remapped pipe");
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelBakeEvent event) {
        ModelResourceLocation mrl = new ModelResourceLocation("buildcrafttransport:pipeBlock");
        event.modelRegistry.func_82595_a((Object)mrl, (Object)new PipeBlockModel());
        PipeTransportRendererFluids.INSTANCE.modelBake();
        for (ItemPipe itemPipe : BlockGenericPipe.pipes.keySet()) {
            for (int i = 0; i < 17; ++i) {
                mrl = ModelHelper.getItemResourceLocation(itemPipe, "_" + i);
                event.modelRegistry.func_82595_a((Object)mrl, (Object)PipeItemModel.create(itemPipe, i));
            }
        }
        if (lensItem != null) {
            for (int i = 0; i < 34; ++i) {
                mrl = ModelHelper.getItemResourceLocation(lensItem, "_" + i);
                event.modelRegistry.func_82595_a((Object)mrl, (Object)LensPluggableModel.create(lensItem, i));
            }
        }
        if (plugItem != null) {
            mrl = ModelHelper.getItemResourceLocation(plugItem, "");
            event.modelRegistry.func_82595_a((Object)mrl, (Object)PlugPluggableModel.create());
        }
        if (powerAdapterItem != null) {
            mrl = ModelHelper.getItemResourceLocation(powerAdapterItem, "");
            event.modelRegistry.func_82595_a((Object)mrl, (Object)ModelPowerAdapter.create());
        }
        if (pipeGate != null) {
            mrl = ModelHelper.getItemResourceLocation(pipeGate, "");
            event.modelRegistry.func_82595_a((Object)mrl, (Object)GateItemModel.INSTANCE);
        }
        if (facadeItem != null) {
            mrl = ModelHelper.getItemResourceLocation(facadeItem, "");
            event.modelRegistry.func_82595_a((Object)mrl, (Object)FacadeItemModel.INSTANCE);
        }
    }

    static {
        triggerPipe = new ITriggerInternal[TriggerPipeContents.PipeContents.values().length];
        triggerPipeWireActive = new ITriggerInternal[PipeWire.values().length];
        triggerPipeWireInactive = new ITriggerInternal[PipeWire.values().length];
        triggerTimer = new ITriggerInternal[TriggerClockTimer.Time.VALUES.length];
        triggerRedstoneLevel = new ITriggerInternal[15];
        actionPipeWire = new ActionSignalOutput[PipeWire.values().length];
        actionEnergyPulser = new ActionEnergyPulsar();
        actionSingleEnergyPulse = new ActionSingleEnergyPulse();
        actionPipeColor = new IActionInternal[16];
        actionPipeDirection = new IActionInternal[16];
        actionPowerLimiter = new IActionInternal[7];
        actionRedstoneLevel = new IActionInternal[15];
        actionExtractionPresetRed = new ActionExtractionPreset(EnumColor.RED);
        actionExtractionPresetBlue = new ActionExtractionPreset(EnumColor.BLUE);
        actionExtractionPresetGreen = new ActionExtractionPreset(EnumColor.GREEN);
        actionExtractionPresetYellow = new ActionExtractionPreset(EnumColor.YELLOW);
        actionValve = new IActionInternal[4];
        debugPrintFacadeList = false;
        gateCostMultiplier = 1.0f;
        pipeRecipes = new LinkedList();
    }

    private static class PipeRecipe {
        boolean isShapeless = false;
        ItemStack result;
        Object[] input;

        private PipeRecipe() {
        }
    }
}

