/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.IBuildCraftMod;
import buildcraft.core.DefaultProps;
import buildcraft.core.lib.network.base.Packet;
import buildcraft.core.lib.utils.Utils;
import com.google.common.collect.Maps;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.Vec3;
import net.minecraft.util.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

public class BuildCraftMod
implements IBuildCraftMod {
    private static final Executor packetSender = Executors.newSingleThreadExecutor();
    public EnumMap<Side, FMLEmbeddedChannel> channels;
    protected Map<String, Property> options = Maps.newHashMap();

    private static void addSendRequest(SendRequest request) {
        packetSender.execute(request);
    }

    public void sendToPlayers(Packet packet, World world, BlockPos pos, int maxDistance) {
        BuildCraftMod.addSendRequest(new LocationSendRequest(packet, world.field_73011_w.func_177502_q(), Utils.convertMiddle((Vec3i)pos), maxDistance));
    }

    public void sendToPlayersNear(Packet packet, TileEntity tile, int maxDistance) {
        this.sendToPlayers(packet, tile.func_145831_w(), tile.func_174877_v(), maxDistance);
    }

    public void sendToPlayersNear(Packet packet, TileEntity tile) {
        this.sendToPlayersNear(packet, tile, DefaultProps.NETWORK_UPDATE_RANGE);
    }

    public void sendToWorld(Packet packet, World world) {
        BuildCraftMod.addSendRequest(new WorldSendRequest(packet, world.field_73011_w.func_177502_q()));
    }

    public void sendToEntity(Packet packet, Entity entity) {
        BuildCraftMod.addSendRequest(new EntitySendRequest(packet, entity, DefaultProps.NETWORK_UPDATE_RANGE));
    }

    public void sendToPlayer(EntityPlayer player, Packet packet) {
        BuildCraftMod.addSendRequest(new PlayerSendRequest(packet, player));
    }

    public void sendToAll(Packet packet) {
        BuildCraftMod.addSendRequest(new AllSendRequest(packet));
    }

    public void sendToServer(Packet packet) {
        if (packet.tempWorld == null) {
            NullPointerException npe = new NullPointerException("The packet's world was null! Cannot send this! (Client)");
            BCLog.logger.fatal("// Blame AlexIIL", (Throwable)npe);
            throw npe;
        }
        try {
            this.channels.get(Side.CLIENT).attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
            this.channels.get(Side.CLIENT).writeOutbound(new Object[]{packet});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Property getOption(String name) {
        if (this.options.containsKey(name)) {
            return this.options.get(name);
        }
        return null;
    }

    public void putOption(String name, Property value) {
        this.options.put(name, value);
    }

    class AllSendRequest
    extends SendRequest {
        AllSendRequest(Packet packet) {
            super(packet);
        }

        @Override
        void editAttributes(FMLEmbeddedChannel channel) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        }
    }

    class LocationSendRequest
    extends SendRequest {
        final int dimensionId;
        final int maxDistance;
        final Vec3 pos;

        LocationSendRequest(Packet packet, int dimensionId, Vec3 pos, int distance) {
            super(packet);
            this.dimensionId = dimensionId;
            this.pos = pos;
            this.maxDistance = distance * distance;
        }

        @Override
        void editAttributes(FMLEmbeddedChannel channel) {
            NetworkRegistry.TargetPoint point = new NetworkRegistry.TargetPoint(this.dimensionId, this.pos.field_72450_a, this.pos.field_72448_b, this.pos.field_72449_c, (double)this.maxDistance);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)point);
        }
    }

    class WorldSendRequest
    extends SendRequest {
        final int dimensionId;

        WorldSendRequest(Packet packet, int dimensionId) {
            super(packet);
            this.dimensionId = dimensionId;
        }

        @Override
        void editAttributes(FMLEmbeddedChannel channel) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)this.dimensionId);
        }
    }

    class EntitySendRequest
    extends LocationSendRequest {
        Entity entity;

        EntitySendRequest(Packet packet, Entity entity, int maxDistance) {
            super(packet, entity.field_70170_p.field_73011_w.func_177502_q(), Utils.getVec(entity), maxDistance);
            this.entity = entity;
        }
    }

    class PlayerSendRequest
    extends SendRequest {
        EntityPlayer player;

        PlayerSendRequest(Packet packet, EntityPlayer player) {
            super(packet);
            this.player = player;
        }

        @Override
        void editAttributes(FMLEmbeddedChannel channel) {
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
            channel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)this.player);
        }
    }

    abstract class SendRequest
    implements Runnable {
        final Packet packet;
        final BuildCraftMod source;

        SendRequest(Packet packet) {
            this.packet = packet;
            this.source = BuildCraftMod.this;
            if (packet.tempWorld == null) {
                NullPointerException npe = new NullPointerException("The packet's world was null! Cannot send this!");
                BCLog.logger.fatal("// Blame AlexIIL", (Throwable)npe);
                throw npe;
            }
            if (packet.dimensionId == -2147483638) {
                IllegalArgumentException iae = new IllegalArgumentException("The packet had an invalid dimension ID! Cannot send this!");
                BCLog.logger.fatal("// Blame AlexIIL", (Throwable)iae);
                throw iae;
            }
        }

        @Override
        public final void run() {
            try {
                FMLEmbeddedChannel channel = this.source.channels.get(Side.SERVER);
                this.editAttributes(channel);
                channel.writeOutbound(new Object[]{this.packet});
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        abstract void editAttributes(FMLEmbeddedChannel var1);
    }
}

