/*
 * Decompiled with CFR 0.152.
 */
package buildcraft;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftMod;
import buildcraft.api.core.BCLog;
import buildcraft.api.core.JavaTools;
import buildcraft.api.core.StackKey;
import buildcraft.api.enums.EnumEnergyStage;
import buildcraft.api.enums.EnumSpring;
import buildcraft.api.fuels.BuildcraftFuelRegistry;
import buildcraft.api.recipes.BuildcraftRecipeRegistry;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementManager;
import buildcraft.core.BCRegistry;
import buildcraft.core.DefaultProps;
import buildcraft.core.InterModComms;
import buildcraft.core.config.ConfigManager;
import buildcraft.core.lib.client.sprite.SpriteColourMapper;
import buildcraft.core.lib.engines.TileEngineBase;
import buildcraft.core.lib.fluids.FluidDefinition;
import buildcraft.core.lib.network.base.ChannelHandler;
import buildcraft.core.lib.network.base.PacketHandler;
import buildcraft.core.lib.utils.ModelHelper;
import buildcraft.energy.EnergyGuiHandler;
import buildcraft.energy.EnergyProxy;
import buildcraft.energy.IMCHandlerEnergy;
import buildcraft.energy.TileEngineCreative;
import buildcraft.energy.TileEngineIron;
import buildcraft.energy.TileEngineStone;
import buildcraft.energy.fuels.CoolantManager;
import buildcraft.energy.fuels.FuelManager;
import buildcraft.energy.statements.EnergyStatementProvider;
import buildcraft.energy.statements.TriggerCoolantBelowThreshold;
import buildcraft.energy.statements.TriggerEngineHeat;
import buildcraft.energy.statements.TriggerFuelBelowThreshold;
import buildcraft.energy.worldgen.BiomeGenOilDesert;
import buildcraft.energy.worldgen.BiomeGenOilOcean;
import buildcraft.energy.worldgen.BiomeInitializer;
import buildcraft.energy.worldgen.OilPopulate;
import com.google.common.base.Throwables;
import java.util.Locale;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.ModelRotation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.Achievement;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.IFlexibleBakedModel;
import net.minecraftforge.client.model.IModelState;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLMissingMappingsEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

@Mod(name="BuildCraft Energy", version="7.2.7", useMetadata=false, modid="BuildCraft|Energy", dependencies="required-after:BuildCraft|Core@7.2.7", acceptedMinecraftVersions="[1.8.9]")
public class BuildCraftEnergy
extends BuildCraftMod {
    @Mod.Instance(value="BuildCraft|Energy")
    public static BuildCraftEnergy instance;
    public static boolean spawnOilSprings;
    public static BiomeGenOilDesert biomeOilDesert;
    public static BiomeGenOilOcean biomeOilOcean;
    public static FluidDefinition oil;
    public static FluidDefinition fuel;
    public static FluidDefinition redPlasma;
    public static Achievement engineAchievement2;
    public static Achievement engineAchievement3;
    public static boolean canOilBurn;
    public static boolean isOilDense;
    public static double oilWellScalar;
    public static ITriggerExternal triggerBlueEngineHeat;
    public static ITriggerExternal triggerGreenEngineHeat;
    public static ITriggerExternal triggerYellowEngineHeat;
    public static ITriggerExternal triggerRedEngineHeat;
    public static ITriggerExternal triggerEngineOverheat;
    public static ITriggerExternal triggerFuelBelow25;
    public static ITriggerExternal triggerFuelBelow50;
    public static ITriggerExternal triggerCoolantBelow25;
    public static ITriggerExternal triggerCoolantBelow50;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        BuildcraftFuelRegistry.fuel = FuelManager.INSTANCE;
        BuildcraftFuelRegistry.coolant = CoolantManager.INSTANCE;
        int oilDesertBiomeId = BuildCraftCore.mainConfigManager.register("worldgen.biomes", "biomeOilDesert", DefaultProps.BIOME_OIL_DESERT, "The id for the Oil Desert biome", ConfigManager.RestartRequirement.GAME).getInt();
        int oilOceanBiomeId = BuildCraftCore.mainConfigManager.register("worldgen.biomes", "biomeOilOcean", DefaultProps.BIOME_OIL_OCEAN, "The id for the Oil Ocean biome", ConfigManager.RestartRequirement.GAME).getInt();
        BuildCraftCore.mainConfigManager.register("worldgen.spawnOilSprings", true, "Should I spawn oil springs?", ConfigManager.RestartRequirement.GAME);
        BuildCraftCore.mainConfigManager.register("worldgen.oilWellGenerationRate", 1.0, "How high should be the probability of an oil well generating?", ConfigManager.RestartRequirement.NONE);
        this.setBiomeList(OilPopulate.INSTANCE.surfaceDepositBiomes, BuildCraftCore.mainConfigManager.register("worldgen.biomes", "increasedOilIDs", new String[]{BiomeDictionary.Type.SANDY.toString(), BiomeGenBase.field_76768_g.field_76791_y}, "IDs or Biome Types (e.g. SANDY,OCEAN) of biomes that should have increased oil generation rates.", ConfigManager.RestartRequirement.GAME));
        this.setBiomeList(OilPopulate.INSTANCE.excessiveBiomes, BuildCraftCore.mainConfigManager.register("worldgen.biomes", "excessiveOilIDs", new String[0], "IDs or Biome Types (e.g. SANDY,OCEAN) of biomes that should have GREATLY increased oil generation rates.", ConfigManager.RestartRequirement.GAME));
        this.setBiomeList(OilPopulate.INSTANCE.excludedBiomes, BuildCraftCore.mainConfigManager.register("worldgen.biomes", "excludeOilIDs", new String[]{BiomeGenBase.field_76779_k.field_76791_y, BiomeGenBase.field_76778_j.field_76791_y}, "IDs or Biome Types (e.g. SANDY,OCEAN) of biomes that are excluded from generating oil.", ConfigManager.RestartRequirement.GAME));
        BuildCraftCore.mainConfigManager.register("general", "fuel.oil.combustion", Float.valueOf(1.0f), "adjust energy value of Oil in Combustion Engines", ConfigManager.RestartRequirement.GAME);
        BuildCraftCore.mainConfigManager.register("general", "fuel.fuel.combustion", Float.valueOf(1.0f), "adjust energy value of Fuel in Combustion Engines", ConfigManager.RestartRequirement.GAME);
        BuildCraftCore.mainConfigManager.register("general", "fuel.oil.combustion.energyOutput", 30, "adjust output energy by Oil in Combustion Engines", ConfigManager.RestartRequirement.GAME);
        BuildCraftCore.mainConfigManager.register("general", "fuel.fuel.combustion.energyOutput", 60, "adjust output energy by Fuel in Combustion Engines", ConfigManager.RestartRequirement.GAME);
        BuildCraftCore.mainConfiguration.save();
        BiomeGenBase[] biomeGenArray = BiomeGenBase.func_150565_n();
        if (oilDesertBiomeId > 0) {
            if (oilDesertBiomeId >= biomeGenArray.length || biomeGenArray[oilDesertBiomeId] != null) {
                oilDesertBiomeId = this.findUnusedBiomeID("oilDesert");
                BuildCraftCore.mainConfiguration.get("worldgen.biomes", "biomeOilDesert", oilDesertBiomeId).set(oilDesertBiomeId);
                BuildCraftCore.mainConfiguration.save();
            }
            biomeOilDesert = BiomeGenOilDesert.makeBiome(oilDesertBiomeId);
        }
        if (oilOceanBiomeId > 0) {
            if (oilOceanBiomeId >= biomeGenArray.length || biomeGenArray[oilOceanBiomeId] != null) {
                oilOceanBiomeId = this.findUnusedBiomeID("oilOcean");
                BuildCraftCore.mainConfiguration.get("worldgen.biomes", "biomeOilOcean", oilOceanBiomeId).set(oilOceanBiomeId);
                BuildCraftCore.mainConfiguration.save();
            }
            biomeOilOcean = BiomeGenOilOcean.makeBiome(oilOceanBiomeId);
        }
        if (!Loader.isModLoaded((String)"BuildCraft|Factory") || !BuildCraftCore.DEVELOPER_MODE) {
            oil = new FluidDefinition("oil", 800, 10000, true);
            BuildCraftEnergy.oil.block.func_149713_g(8);
            BuildCraftEnergy.oil.fluid.setColour(0x505050, 328965);
            BuildCraftEnergy.oil.block.setFlammability(0);
            BuildCraftCore.mainConfigManager.register("general.oilCanBurn", true, "Should oil burn when lit on fire?", ConfigManager.RestartRequirement.NONE);
            BuildCraftCore.mainConfigManager.register("general.oilIsDense", false, "Should oil be dense and push enties up?", ConfigManager.RestartRequirement.NONE);
            fuel = new FluidDefinition("fuel", 1000, 1000, true);
            BuildCraftEnergy.fuel.block.setFlammable(true).setFlammability(5).setParticleColor(0.7f, 0.7f, 0.0f);
            BuildCraftEnergy.fuel.fluid.setColour(0xFFFF30, 14995200);
            EnumSpring.OIL.canGen = spawnOilSprings = BuildCraftCore.mainConfigManager.get("worldgen.spawnOilSprings").getBoolean(true);
            EnumSpring.OIL.liquidBlock = BuildCraftEnergy.oil.block.func_176223_P();
        }
        if (BuildCraftCore.DEVELOPER_MODE) {
            redPlasma = new FluidDefinition("redplasma", 10000, 10000, false);
            BuildCraftEnergy.redPlasma.fluid.setLuminosity(30);
            BuildCraftEnergy.redPlasma.block.setFlammable(false).setParticleColor(0.9f, 0.0f, 0.0f);
        }
        BuildCraftCore.engineBlock.registerTile(TileEngineStone.class, 1, "tile.engineStone");
        BuildCraftCore.engineBlock.registerTile(TileEngineIron.class, 2, "tile.engineIron");
        BuildCraftCore.engineBlock.registerTile(TileEngineCreative.class, 3, "tile.engineCreative");
        InterModComms.registerHandler(new IMCHandlerEnergy());
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void reloadConfig(ConfigManager.RestartRequirement restartType) {
        if (restartType == ConfigManager.RestartRequirement.GAME) {
            this.reloadConfig(ConfigManager.RestartRequirement.WORLD);
        } else if (restartType == ConfigManager.RestartRequirement.WORLD) {
            this.reloadConfig(ConfigManager.RestartRequirement.NONE);
        } else {
            oilWellScalar = BuildCraftCore.mainConfigManager.get("worldgen.oilWellGenerationRate").getDouble();
            if (!Loader.isModLoaded((String)"BuildCraft|Factory") || !BuildCraftCore.DEVELOPER_MODE) {
                canOilBurn = BuildCraftCore.mainConfigManager.get("general.oilCanBurn").getBoolean();
                isOilDense = BuildCraftCore.mainConfigManager.get("general.oilIsDense").getBoolean();
                BuildCraftEnergy.oil.block.setFlammable(canOilBurn).setDense(isOilDense);
            }
            if (BuildCraftCore.mainConfiguration.hasChanged()) {
                BuildCraftCore.mainConfiguration.save();
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.PostConfigChangedEvent event) {
        if ("BuildCraft|Core".equals(event.modID)) {
            this.reloadConfig(event.isWorldRunning ? ConfigManager.RestartRequirement.NONE : ConfigManager.RestartRequirement.WORLD);
        }
    }

    private void setBiomeList(Set<Integer> list, Property configuration) {
        for (String id : configuration.getStringList()) {
            String strippedId = JavaTools.stripSurroundingQuotes(id.trim());
            if (strippedId.length() <= 0) continue;
            if (strippedId.matches("-?\\d+(\\.\\d+)?")) {
                try {
                    list.add(Integer.parseInt(strippedId));
                }
                catch (NumberFormatException ex) {
                    BCLog.logger.log(Level.WARN, configuration.getName() + ": Could not find biome id: " + strippedId + " ; Skipping!");
                }
                continue;
            }
            boolean found = false;
            String biomeName = strippedId.toUpperCase();
            for (BiomeDictionary.Type t : BiomeDictionary.Type.values()) {
                String biomeType = t.name().toUpperCase();
                for (BiomeGenBase b : BiomeDictionary.getBiomesForType((BiomeDictionary.Type)t)) {
                    if (!b.field_76791_y.toUpperCase().equals(biomeName) && !biomeType.toUpperCase().equals(biomeName)) continue;
                    list.add(b.field_76756_M);
                    found = true;
                }
            }
            if (found) continue;
            BCLog.logger.log(Level.WARN, configuration.getName() + ": Could not find biome id: " + strippedId + " ; Skipping!");
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        this.channels = NetworkRegistry.INSTANCE.newChannel("BC-ENERGY", new io.netty.channel.ChannelHandler[]{new ChannelHandler(), new PacketHandler()});
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new EnergyGuiHandler());
        StatementManager.registerTriggerProvider(new EnergyStatementProvider());
        if (BuildCraftCore.loadDefaultRecipes) {
            BuildCraftEnergy.loadRecipes();
        }
        this.reloadConfig(ConfigManager.RestartRequirement.GAME);
        BuildcraftRecipeRegistry.refinery.addRecipe("buildcraft:fuel", new FluidStack((Fluid)BuildCraftEnergy.oil.fluid, 1), new FluidStack((Fluid)BuildCraftEnergy.fuel.fluid, 1), 120, 1);
        double fuelOilMultiplier = BuildCraftCore.mainConfigManager.get("general", "fuel.oil.combustion").getDouble();
        double fuelFuelMultiplier = BuildCraftCore.mainConfigManager.get("general", "fuel.fuel.combustion").getDouble();
        int fuelOilEnergyOutput = BuildCraftCore.mainConfigManager.get("general", "fuel.oil.combustion.energyOutput").getInt();
        int fuelFuelEnergyOutput = BuildCraftCore.mainConfigManager.get("general", "fuel.fuel.combustion.energyOutput").getInt();
        if (!Loader.isModLoaded((String)"BuildCraft|Factory") || !BuildCraftCore.DEVELOPER_MODE) {
            BuildcraftFuelRegistry.fuel.addFuel(BuildCraftEnergy.oil.fluid, fuelOilEnergyOutput, (int)(5000.0 * fuelOilMultiplier));
            BuildcraftFuelRegistry.fuel.addFuel(BuildCraftEnergy.fuel.fluid, fuelFuelEnergyOutput, (int)(25000.0 * fuelFuelMultiplier));
        }
        BuildcraftFuelRegistry.coolant.addCoolant(FluidRegistry.WATER, 0.0023f);
        BuildcraftFuelRegistry.coolant.addSolidCoolant(StackKey.stack(Blocks.field_150432_aD), StackKey.fluid(FluidRegistry.WATER), 1.5f);
        BuildcraftFuelRegistry.coolant.addSolidCoolant(StackKey.stack(Blocks.field_150403_cj), StackKey.fluid(FluidRegistry.WATER), 2.0f);
        EnergyProxy.proxy.registerBlockRenderers();
        EnergyProxy.proxy.registerTileEntities();
        engineAchievement2 = BuildCraftCore.achievementManager.registerAchievement(new Achievement("buildcraft|energy:achievement.stirlingEngine", "engineAchievement2", 3, -2, new ItemStack((Block)BuildCraftCore.engineBlock, 1, 1), BuildCraftCore.engineRedstoneAchievement));
        engineAchievement3 = BuildCraftCore.achievementManager.registerAchievement(new Achievement("buildcraft|energy:achievement.combustionEngine", "engineAchievement3", 5, -2, new ItemStack((Block)BuildCraftCore.engineBlock, 1, 2), engineAchievement2));
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        if (BuildCraftCore.modifyWorld) {
            MinecraftForge.EVENT_BUS.register((Object)OilPopulate.INSTANCE);
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new BiomeInitializer());
        }
    }

    public static void loadRecipes() {
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)BuildCraftCore.engineBlock, 1, 1), "www", " g ", "GpG", Character.valueOf('w'), "cobblestone", Character.valueOf('g'), "blockGlass", Character.valueOf('G'), "gearStone", Character.valueOf('p'), Blocks.field_150331_J);
        BCRegistry.INSTANCE.addCraftingRecipe(new ItemStack((Block)BuildCraftCore.engineBlock, 1, 2), "www", " g ", "GpG", Character.valueOf('w'), "ingotIron", Character.valueOf('g'), "blockGlass", Character.valueOf('G'), "gearIron", Character.valueOf('p'), Blocks.field_150331_J);
    }

    private int findUnusedBiomeID(String biomeName) {
        for (int i = 1; i < 256; ++i) {
            if (BiomeGenBase.func_150565_n()[i] != null) continue;
            int freeBiomeID = i;
            return freeBiomeID;
        }
        throw new RuntimeException("You have run out of free Biome ID spaces for " + biomeName);
    }

    @Mod.EventHandler
    public void processIMCRequests(FMLInterModComms.IMCEvent event) {
        InterModComms.processIMC(event);
    }

    @Mod.EventHandler
    public void whiteListAppliedEnergetics(FMLInitializationEvent event) {
        FMLInterModComms.sendMessage((String)"appliedenergistics2", (String)"whitelist-spatial", (String)TileEngineBase.class.getCanonicalName());
    }

    @Mod.EventHandler
    public void remap(FMLMissingMappingsEvent event) {
        Throwable error = null;
        BCLog.logger.info("Energy|Remap " + System.identityHashCode(event));
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            try {
                String name = mapping.name;
                String domain = mapping.resourceLocation.func_110624_b().toLowerCase(Locale.ROOT);
                String path = mapping.resourceLocation.func_110623_a().toLowerCase(Locale.ROOT);
                BCLog.logger.info("        - " + name + " " + mapping.type + " [" + domain + "][" + path + "]");
                if (name.equals("BuildCraft|Energy:engineBlock")) {
                    if (mapping.type == GameRegistry.Type.BLOCK) {
                        mapping.remap((Block)BuildCraftCore.engineBlock);
                    } else if (mapping.type == GameRegistry.Type.ITEM) {
                        mapping.remap(Item.func_150898_a((Block)BuildCraftCore.engineBlock));
                    }
                }
                if (domain.equals("buildcraft|energy")) {
                    if (path.contains("_")) continue;
                    if (path.endsWith("oil") && !Loader.isModLoaded((String)"BuildCraft|Factory")) {
                        if (mapping.type == GameRegistry.Type.BLOCK) {
                            mapping.remap((Block)BuildCraftEnergy.oil.block);
                        } else if (mapping.type == GameRegistry.Type.ITEM) {
                            if (path.contains("bucket") && BuildCraftEnergy.oil.bucket != null) {
                                mapping.remap((Item)BuildCraftEnergy.oil.bucket);
                            } else if (path.contains("block")) {
                                mapping.ignore();
                            }
                        }
                        BCLog.logger.info("            " + path + " matched oil");
                        continue;
                    }
                    if (path.endsWith("fuel") && !Loader.isModLoaded((String)"BuildCraft|Factory")) {
                        if (mapping.type == GameRegistry.Type.BLOCK) {
                            mapping.remap((Block)BuildCraftEnergy.fuel.block);
                        } else if (mapping.type == GameRegistry.Type.ITEM) {
                            if (path.contains("bucket") && BuildCraftEnergy.fuel.bucket != null) {
                                mapping.remap((Item)BuildCraftEnergy.fuel.bucket);
                            } else if (path.contains("block")) {
                                mapping.ignore();
                            }
                        }
                        BCLog.logger.info("            " + path + " matched fuel");
                        continue;
                    }
                    if (path.endsWith("redplasma") && redPlasma != null) {
                        if (mapping.type == GameRegistry.Type.BLOCK) {
                            mapping.remap((Block)BuildCraftEnergy.redPlasma.block);
                        } else if (mapping.type == GameRegistry.Type.ITEM) {
                            if (path.contains("bucket")) {
                                mapping.remap((Item)BuildCraftEnergy.redPlasma.bucket);
                            } else if (path.contains("block")) {
                                mapping.ignore();
                            }
                        }
                        BCLog.logger.info("            " + path + " matched redplasma");
                        continue;
                    }
                    BCLog.logger.info("            " + path + " matched nothing");
                    continue;
                }
                BCLog.logger.info("Unknown domain " + domain);
            }
            catch (Throwable t) {
                t.printStackTrace();
                error = t;
            }
        }
        if (error != null) {
            throw Throwables.propagate(error);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerModels(ModelBakeEvent event) {
        FluidDefinition[] arr = new FluidDefinition[]{oil, fuel, redPlasma};
        if (Loader.isModLoaded((String)"BuildCraft|Factory") && BuildCraftCore.DEVELOPER_MODE) {
            arr[0] = null;
            arr[1] = null;
        }
        if (!BuildCraftCore.DEVELOPER_MODE) {
            arr[2] = null;
        }
        for (FluidDefinition def : arr) {
            if (def == null) continue;
            ModelFluid model = new ModelFluid((Fluid)def.fluid);
            IFlexibleBakedModel baked = model.bake((IModelState)ModelRotation.X0_Y0, DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
            ModelResourceLocation loc = ModelHelper.getBlockResourceLocation((Block)def.block);
            event.modelRegistry.func_82595_a((Object)loc, (Object)baked);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void textureStitchPre(TextureStitchEvent.Pre event) {
        FluidDefinition[] arr = new FluidDefinition[]{oil, fuel, redPlasma};
        if (Loader.isModLoaded((String)"BuildCraft|Factory") && BuildCraftCore.DEVELOPER_MODE) {
            arr[0] = null;
            arr[1] = null;
        }
        if (!BuildCraftCore.DEVELOPER_MODE) {
            arr[2] = null;
        }
        for (FluidDefinition def : arr) {
            if (def == null) continue;
            int heat = def.fluid.getHeatValue();
            String from = "buildcraftenergy:blocks/fluids/heat_" + heat;
            SpriteColourMapper mapper = new SpriteColourMapper(def.fluid, from + "_still", true);
            event.map.setTextureEntry(def.fluid.getStill().toString(), (TextureAtlasSprite)mapper);
            mapper = new SpriteColourMapper(def.fluid, from + "_flow", false);
            event.map.setTextureEntry(def.fluid.getFlowing().toString(), (TextureAtlasSprite)mapper);
        }
    }

    static {
        spawnOilSprings = true;
        oilWellScalar = 1.0;
        triggerBlueEngineHeat = new TriggerEngineHeat(EnumEnergyStage.BLUE);
        triggerGreenEngineHeat = new TriggerEngineHeat(EnumEnergyStage.GREEN);
        triggerYellowEngineHeat = new TriggerEngineHeat(EnumEnergyStage.YELLOW);
        triggerRedEngineHeat = new TriggerEngineHeat(EnumEnergyStage.RED);
        triggerEngineOverheat = new TriggerEngineHeat(EnumEnergyStage.OVERHEAT);
        triggerFuelBelow25 = new TriggerFuelBelowThreshold(0.25f);
        triggerFuelBelow50 = new TriggerFuelBelowThreshold(0.5f);
        triggerCoolantBelow25 = new TriggerCoolantBelowThreshold(0.25f);
        triggerCoolantBelow50 = new TriggerCoolantBelowThreshold(0.5f);
        FluidRegistry.enableUniversalBucket();
    }
}

