/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.config.Constants;
import mezz.jei.config.KeyBindings;
import mezz.jei.gui.Focus;
import mezz.jei.gui.IRecipeGuiLogic;
import mezz.jei.gui.RecipeGuiLogic;
import mezz.jei.gui.RecipeLayout;
import mezz.jei.gui.RecipeTransferButton;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.input.IShowsRecipeFocuses;
import mezz.jei.input.InputHandler;
import mezz.jei.transfer.RecipeTransferUtil;
import mezz.jei.util.StringUtil;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.config.GuiButtonExt;
import net.minecraftforge.fml.client.config.HoverChecker;
import org.lwjgl.input.Mouse;

public class RecipesGui
extends GuiScreen
implements IShowsRecipeFocuses {
    private static final int borderPadding = 8;
    private static final int innerPadding = 5;
    private static final int textPadding = 5;
    private static final int buttonWidth = 13;
    private static final int buttonHeight = 12;
    private int titleHeight;
    private int headerHeight;
    private final IRecipeGuiLogic logic = new RecipeGuiLogic();
    @Nonnull
    private final List<RecipeLayout> recipeLayouts = new ArrayList<RecipeLayout>();
    private String pageString;
    private String title;
    private ResourceLocation backgroundTexture;
    private HoverChecker titleHoverChecker;
    private GuiButton nextRecipeCategory;
    private GuiButton previousRecipeCategory;
    private GuiButton nextPage;
    private GuiButton previousPage;
    @Nullable
    private GuiScreen parentScreen;
    private int xSize;
    private int ySize;
    private int guiLeft;
    private int guiTop;

    public RecipesGui() {
        this.field_146297_k = Minecraft.func_71410_x();
    }

    public int getGuiLeft() {
        return this.guiLeft;
    }

    public int getXSize() {
        return this.xSize;
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.xSize = 176;
        if (this.field_146295_m > 300) {
            this.ySize = 256;
            this.backgroundTexture = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackgroundTall.png");
        } else {
            this.ySize = 166;
            this.backgroundTexture = new ResourceLocation(Constants.RESOURCE_DOMAIN, "textures/gui/recipeBackground.png");
        }
        this.guiLeft = (this.field_146294_l - this.xSize) / 2;
        this.guiTop = (this.field_146295_m - this.ySize) / 2;
        this.titleHeight = this.field_146289_q.field_78288_b + 8;
        this.headerHeight = this.titleHeight + this.field_146289_q.field_78288_b + 5;
        int rightButtonX = this.guiLeft + this.xSize - 8 - 13;
        int leftButtonX = this.guiLeft + 8;
        int recipeClassButtonTop = this.guiTop + 8 - 2;
        this.nextRecipeCategory = new GuiButtonExt(2, rightButtonX, recipeClassButtonTop, 13, 12, ">");
        this.previousRecipeCategory = new GuiButtonExt(3, leftButtonX, recipeClassButtonTop, 13, 12, "<");
        int pageButtonTop = this.guiTop + this.titleHeight + 3;
        this.nextPage = new GuiButtonExt(4, rightButtonX, pageButtonTop, 13, 12, ">");
        this.previousPage = new GuiButtonExt(5, leftButtonX, pageButtonTop, 13, 12, "<");
        this.addButtons();
        this.updateLayout();
    }

    private void addButtons() {
        this.field_146292_n.add(this.nextRecipeCategory);
        this.field_146292_n.add(this.previousRecipeCategory);
        this.field_146292_n.add(this.nextPage);
        this.field_146292_n.add(this.previousPage);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        Focus focus;
        this.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        GlStateManager.func_179084_k();
        RecipesGui.func_73734_a((int)(this.guiLeft + 8 + 13), (int)(this.guiTop + 8 - 2), (int)(this.guiLeft + this.xSize - 8 - 13), (int)(this.guiTop + 8 + 10), (int)0x30000000);
        RecipesGui.func_73734_a((int)(this.guiLeft + 8 + 13), (int)(this.guiTop + this.titleHeight + 5 - 2), (int)(this.guiLeft + this.xSize - 8 - 13), (int)(this.guiTop + this.titleHeight + 5 + 10), (int)0x30000000);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        StringUtil.drawCenteredString(this.field_146289_q, this.title, this.xSize, this.guiLeft, this.guiTop + 8, Color.WHITE.getRGB(), true);
        StringUtil.drawCenteredString(this.field_146289_q, this.pageString, this.xSize, this.guiLeft, this.guiTop + this.titleHeight + 5, Color.WHITE.getRGB(), true);
        this.nextRecipeCategory.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.previousRecipeCategory.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.nextPage.func_146112_a(this.field_146297_k, mouseX, mouseY);
        this.previousPage.func_146112_a(this.field_146297_k, mouseX, mouseY);
        RecipeLayout hovered = null;
        for (RecipeLayout recipeWidget : this.recipeLayouts) {
            if (recipeWidget.isMouseOver(mouseX, mouseY)) {
                hovered = recipeWidget;
                continue;
            }
            recipeWidget.draw(this.field_146297_k, mouseX, mouseY);
        }
        if (hovered != null) {
            hovered.draw(this.field_146297_k, mouseX, mouseY);
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY) && (focus = this.logic.getFocus()) != null && !focus.isBlank()) {
            String showAllRecipesString = Translator.translateToLocal("jei.tooltip.show.all.recipes");
            TooltipRenderer.drawHoveringText(this.field_146297_k, showAllRecipesString, mouseX, mouseY);
        }
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(this.backgroundTexture);
        int x = (this.field_146294_l - this.xSize) / 2;
        int y = (this.field_146295_m - this.ySize) / 2;
        this.field_73735_i = 0.0f;
        this.func_73729_b(x, y, 0, 0, this.xSize, this.ySize);
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        return this.field_146297_k.field_71462_r == this && mouseX >= this.guiLeft && mouseY >= this.guiTop && mouseX < this.guiLeft + this.xSize && mouseY < this.guiTop + this.ySize;
    }

    @Override
    @Nullable
    public Focus getFocusUnderMouse(int mouseX, int mouseY) {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return null;
        }
        for (RecipeLayout recipeLayouts : this.recipeLayouts) {
            Focus focus = recipeLayouts.getFocusUnderMouse(mouseX, mouseY);
            if (focus == null) continue;
            return focus;
        }
        return null;
    }

    @Override
    public boolean canSetFocusWithMouse() {
        return true;
    }

    public void func_146274_d() throws IOException {
        int y;
        int x = Mouse.getEventX() * this.field_146294_l / this.field_146297_k.field_71443_c;
        if (this.isMouseOver(x, y = this.field_146295_m - Mouse.getEventY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1)) {
            int scrollDelta = Mouse.getEventDWheel();
            if (scrollDelta < 0) {
                this.logic.nextPage();
                this.updateLayout();
                return;
            }
            if (scrollDelta > 0) {
                this.logic.previousPage();
                this.updateLayout();
                return;
            }
        }
        super.func_146274_d();
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (!this.isMouseOver(mouseX, mouseY)) {
            return;
        }
        if (this.titleHoverChecker.checkHover(mouseX, mouseY)) {
            if (this.logic.setCategoryFocus()) {
                this.updateLayout();
            }
        } else {
            for (RecipeLayout recipeLayout : this.recipeLayouts) {
                if (!recipeLayout.handleClick(this.field_146297_k, mouseX, mouseY, mouseButton)) continue;
                return;
            }
        }
        super.func_73864_a(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (InputHandler.isInventoryCloseKey(keyCode) || InputHandler.isInventoryToggleKey(keyCode)) {
            this.close();
        } else if (keyCode == KeyBindings.recipeBack.func_151463_i()) {
            this.back();
        }
    }

    private void open() {
        if (this.field_146297_k.field_71462_r != this) {
            this.parentScreen = this.field_146297_k.field_71462_r;
        }
        this.field_146297_k.func_147108_a((GuiScreen)this);
    }

    private void close() {
        if (this.parentScreen != null) {
            this.field_146297_k.func_147108_a(this.parentScreen);
            this.parentScreen = null;
        } else {
            this.field_146297_k.field_71439_g.func_71053_j();
        }
        this.logic.clearHistory();
    }

    public void showRecipes(@Nonnull Focus focus) {
        focus.setMode(Focus.Mode.OUTPUT);
        if (this.logic.setFocus(focus)) {
            this.open();
        }
    }

    public void showUses(@Nonnull Focus focus) {
        focus.setMode(Focus.Mode.INPUT);
        if (this.logic.setFocus(focus)) {
            this.open();
        }
    }

    public void showCategories(@Nonnull List<String> recipeCategoryUids) {
        if (this.logic.setCategoryFocus(recipeCategoryUids)) {
            this.open();
        }
    }

    public void back() {
        if (this.logic.back()) {
            this.updateLayout();
        }
    }

    protected void func_146284_a(@Nonnull GuiButton guibutton) {
        boolean updateLayout = true;
        if (guibutton.field_146127_k == this.nextPage.field_146127_k) {
            this.logic.nextPage();
        } else if (guibutton.field_146127_k == this.previousPage.field_146127_k) {
            this.logic.previousPage();
        } else if (guibutton.field_146127_k == this.nextRecipeCategory.field_146127_k) {
            this.logic.nextRecipeCategory();
        } else if (guibutton.field_146127_k == this.previousRecipeCategory.field_146127_k) {
            this.logic.previousRecipeCategory();
        } else if (guibutton.field_146127_k >= 100) {
            int recipeIndex = guibutton.field_146127_k - 100;
            RecipeLayout recipeLayout = this.recipeLayouts.get(recipeIndex);
            boolean maxTransfer = GuiScreen.func_146272_n();
            Container container = this.getParentContainer();
            if (container != null && RecipeTransferUtil.transferRecipe(container, recipeLayout, (EntityPlayer)this.field_146297_k.field_71439_g, maxTransfer)) {
                this.close();
                updateLayout = false;
            }
        } else {
            updateLayout = false;
        }
        if (updateLayout) {
            this.updateLayout();
        }
    }

    private void updateLayout() {
        IRecipeCategory recipeCategory = this.logic.getRecipeCategory();
        if (recipeCategory == null) {
            return;
        }
        IDrawable recipeBackground = recipeCategory.getBackground();
        int recipesPerPage = Math.max(1, (this.ySize - this.headerHeight) / (recipeBackground.getHeight() + 5));
        int recipeXOffset = this.guiLeft + (this.xSize - recipeBackground.getWidth()) / 2;
        int recipeSpacing = (this.ySize - this.headerHeight - recipesPerPage * recipeBackground.getHeight()) / (recipesPerPage + 1);
        this.logic.setRecipesPerPage(recipesPerPage);
        this.title = recipeCategory.getTitle();
        int titleWidth = this.field_146289_q.func_78256_a(this.title);
        int titleX = this.guiLeft + (this.xSize - titleWidth) / 2;
        int titleY = this.guiTop + 8;
        this.titleHoverChecker = new HoverChecker(titleY, titleY + this.field_146289_q.field_78288_b, titleX, titleX + titleWidth, 0);
        int spacingY = recipeBackground.getHeight() + recipeSpacing;
        this.recipeLayouts.clear();
        this.recipeLayouts.addAll(this.logic.getRecipeWidgets(recipeXOffset, this.guiTop + this.headerHeight + recipeSpacing, spacingY));
        this.addRecipeTransferButtons(this.recipeLayouts);
        this.nextPage.field_146124_l = this.previousPage.field_146124_l = this.logic.hasMultiplePages();
        this.nextRecipeCategory.field_146124_l = this.previousRecipeCategory.field_146124_l = this.logic.hasMultipleCategories();
        this.pageString = this.logic.getPageString();
    }

    private void addRecipeTransferButtons(List<RecipeLayout> recipeLayouts) {
        this.field_146292_n.clear();
        this.addButtons();
        EntityPlayerSP player = this.field_146297_k.field_71439_g;
        Container container = this.getParentContainer();
        for (RecipeLayout recipeLayout : recipeLayouts) {
            RecipeTransferButton button = recipeLayout.getRecipeTransferButton();
            button.init(container, recipeLayout, (EntityPlayer)player);
            this.field_146292_n.add(button);
        }
    }

    @Nullable
    public GuiScreen getParentScreen() {
        return this.parentScreen;
    }

    @Nullable
    private Container getParentContainer() {
        if (this.parentScreen instanceof GuiContainer) {
            return ((GuiContainer)this.parentScreen).field_147002_h;
        }
        return null;
    }
}

