/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ISidedFunction;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class WorldHelper {
    private static final ISidedFunction<World, Float> getSunBrightness = new ISidedFunction<World, Float>(){

        @Override
        public Float applyServer(World world) {
            float f = world.func_72826_c(0.0f);
            float f1 = 1.0f - (MathHelper.func_76134_b((float)(f * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
            f1 = MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
            f1 = 1.0f - f1;
            f1 = (float)((double)f1 * (1.0 - (double)(world.func_72867_j(0.0f) * 5.0f) / 16.0));
            f1 = (float)((double)f1 * (1.0 - (double)(world.func_72819_i(0.0f) * 5.0f) / 16.0));
            return Float.valueOf(f1 * 0.8f + 0.2f);
        }

        @Override
        public Float applyClient(World world) {
            return Float.valueOf(world.func_72971_b(0.0f));
        }
    };

    public static float getSunBrightness(World world) {
        if (world.field_73011_w.func_177495_o()) {
            return 0.0f;
        }
        return ExtraUtils2.proxy.apply(getSunBrightness, world).floatValue();
    }

    public static float getMoonBrightness(World world) {
        float f = world.func_72826_c(0.0f);
        float f1 = -(MathHelper.func_76134_b((float)(f * (float)Math.PI * 2.0f)) * 2.0f + 0.2f);
        return MathHelper.func_76131_a((float)f1, (float)0.0f, (float)1.0f);
    }

    public static boolean isFullMoon(World world) {
        return world.func_130001_d() >= 0.9f;
    }

    public static TileEntity getTileEntityThreadSafe(World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        Map map = chunk.func_177434_r();
        TileEntity tileEntity = (TileEntity)map.get(pos);
        if (tileEntity == null || tileEntity.func_145837_r()) {
            return null;
        }
        return tileEntity;
    }
}

