/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import net.minecraft.util.MathHelper;

public class LightMathHelper {
    static float[] APPROX_SQRT = new float[4096];

    public static float approxSqrt(float v, float r) {
        if (v <= 0.0f) {
            return 0.0f;
        }
        if (v >= r) {
            return 1.0f;
        }
        return APPROX_SQRT[(int)(v / r * 4096.0f) & 0xFFF];
    }

    public static float[] norm(float a, float b, float c) {
        float a2 = a * a;
        float b2 = b * b;
        float c2 = c * c;
        float r = a2 + b2 + c2;
        return new float[]{LightMathHelper.approxSqrt(a2, r) * Math.signum(a), LightMathHelper.approxSqrt(b2, r) * Math.signum(b), LightMathHelper.approxSqrt(c2, r) * Math.signum(c)};
    }

    public static float partialDist(float x, float y, float z, float r) {
        return LightMathHelper.approxSqrt(x * x + y * y + z * z, r * r);
    }

    static {
        for (int i = 0; i < APPROX_SQRT.length; ++i) {
            LightMathHelper.APPROX_SQRT[i] = MathHelper.func_76129_c((float)((float)i / 4096.0f));
        }
    }
}

