/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import com.rwtema.extrautils2.api.IWrench;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemStackHelper {
    public static ItemStack addLore(ItemStack a, String ... lore) {
        NBTTagCompound tag = a.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        if (!tag.func_150297_b("display", 10)) {
            tag.func_74782_a("display", (NBTBase)new NBTTagCompound());
        }
        NBTTagList l = new NBTTagList();
        for (String s : lore) {
            l.func_74742_a((NBTBase)new NBTTagString(s));
        }
        tag.func_74775_l("display").func_74782_a("Lore", (NBTBase)l);
        a.func_77982_d(tag);
        return a;
    }

    public static void addBlockStates(String oreDictName, HashSet<IBlockState> stateList) {
        List ores = OreDictionary.getOres((String)oreDictName);
        for (ItemStack ore : ores) {
            ItemStackHelper.addBlockStates(ore, stateList);
        }
    }

    public static void addBlockStates(ItemStack stack, HashSet<IBlockState> stateList) {
        Item item = stack.func_77973_b();
        if (!(item instanceof ItemBlock)) {
            return;
        }
        Block block = ((ItemBlock)item).func_179223_d();
        for (IBlockState iBlockState : block.func_176194_O().func_177619_a()) {
            int itemDamage;
            if (block.hasTileEntity(iBlockState) || (itemDamage = stack.func_77952_i()) != Short.MAX_VALUE && itemDamage != block.func_180651_a(iBlockState)) continue;
            stateList.add(iBlockState);
        }
    }

    public static boolean holdingWrench(EntityPlayer player) {
        return ItemStackHelper.isWrench(player.func_70694_bm());
    }

    public static boolean isWrench(ItemStack wrench) {
        return wrench != null && wrench.hasCapability(IWrench.CAPABILITY, null);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInfoWidth(List<String> list, ItemStack stack, String data) {
        ItemStackHelper.addInfoWidth(list, stack, data, 180);
    }

    @SideOnly(value=Side.CLIENT)
    public static void addInfoWidth(List<String> list, ItemStack stack, String data, int weight) {
        FontRenderer fontRenderer;
        FontRenderer fontRenderer2 = fontRenderer = stack == null || stack.func_77973_b() == null ? null : stack.func_77973_b().getFontRenderer(stack);
        if (fontRenderer == null) {
            fontRenderer = Minecraft.func_71410_x().field_71466_p;
        }
        list.addAll(fontRenderer.func_78271_c(data, weight));
    }
}

