/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.helpers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;

public class DescribeHelper {
    public static void addDescription(List<String> list, String name, Object object) {
        DescribeHelper.addDescription(list, name + " = ");
        DescribeHelper.addDescription(list, object, 1);
    }

    public static void addDescription(List<String> list, Object object) {
        DescribeHelper.addDescription(list, object, 0);
    }

    public static void addDescription(List<String> list, Object object, int i) {
        if (object == null) {
            list.add("[null]");
        } else if (object instanceof String) {
            StringBuilder builder = new StringBuilder();
            for (int j = 0; j < i; ++j) {
                builder.append('\t');
            }
            builder.append(object);
            list.add(builder.toString());
        } else if (object instanceof Iterable) {
            if (object instanceof Collection) {
                DescribeHelper.addDescription(list, (Object)(object.getClass().getSimpleName() + "_(size = " + ((Collection)object).size() + "){"), i);
            } else {
                DescribeHelper.addDescription(list, (Object)(object.getClass().getSimpleName() + " {"), i);
            }
            for (Object o : (Iterable)object) {
                DescribeHelper.addDescription(list, o, i + 1);
            }
        } else if (object instanceof Map) {
            DescribeHelper.addDescription(list, (Object)(object.getClass().getSimpleName() + "_(size = " + ((Map)object).size() + "){"), i);
            for (Map.Entry entry : ((Map)object).entrySet()) {
                DescribeHelper.addDescription(list, entry.getKey(), i + 1);
                DescribeHelper.addDescription(list, (Object)"=", i + 1);
                DescribeHelper.addDescription(list, entry.getValue(), i + 1);
            }
            DescribeHelper.addDescription(list, (Object)"}", i);
        } else if (object instanceof ForgeChunkManager.Ticket) {
            ForgeChunkManager.Ticket ticket = (ForgeChunkManager.Ticket)object;
            DescribeHelper.addDescription(list, (Object)("Ticket[Player: " + ticket.getPlayerName() + " World:" + ticket.world.field_73011_w.func_177502_q() + "]"), i);
            DescribeHelper.addDescription(list, (Object)ticket.getChunkList().toString(), i);
        } else if (object instanceof World) {
            World world = (World)object;
            DescribeHelper.addDescription(list, "World[Dim:" + world.field_73011_w.func_177502_q() + " isRemote:" + world.field_72995_K + "]");
        } else {
            String s = object.toString();
            int hash = object.hashCode();
            String s2 = object.getClass().getName() + "@" + Integer.toHexString(hash);
            if (s.equals(s2)) {
                DescribeHelper.addDescription(list, (Object)(object.getClass().getSimpleName() + ":" + hash), i);
            } else {
                DescribeHelper.addDescription(list, (Object)(object.getClass().getSimpleName() + ":" + s), i);
            }
        }
    }
}

