/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagString;
import net.minecraftforge.common.util.INBTSerializable;

public class NBTSerializable {

    public static class Boolean
    implements INBTSerializable<NBTTagByte> {
        public boolean value;

        public Boolean(boolean value) {
            this.value = value;
        }

        public NBTTagByte serializeNBT() {
            return new NBTTagByte(this.value ? (byte)1 : 0);
        }

        public void deserializeNBT(NBTTagByte nbt) {
            this.value = nbt.func_150290_f() != 0;
        }
    }

    public static class Double
    implements INBTSerializable<NBTTagDouble> {
        public double value;

        public Double(double value) {
            this.value = value;
        }

        public NBTTagDouble serializeNBT() {
            return new NBTTagDouble(this.value);
        }

        public void deserializeNBT(NBTTagDouble nbt) {
            this.value = nbt.func_150286_g();
        }
    }

    public static class Float
    implements INBTSerializable<NBTTagFloat> {
        public float value;

        public Float() {
        }

        public Float(float value) {
            this.value = value;
        }

        public NBTTagFloat serializeNBT() {
            return new NBTTagFloat(this.value);
        }

        public void deserializeNBT(NBTTagFloat nbt) {
            this.value = nbt.func_150288_h();
        }
    }

    public static class Int
    implements INBTSerializable<NBTTagInt> {
        public int value;

        public Int(int value) {
            this.value = value;
        }

        public Int() {
        }

        public NBTTagInt serializeNBT() {
            return new NBTTagInt(this.value);
        }

        public void deserializeNBT(NBTTagInt nbt) {
            this.value = nbt.func_150287_d();
        }
    }

    public static class Text
    implements INBTSerializable<NBTTagString> {
        @Nonnull
        String s;

        public Text(@Nonnull String s) {
            this.s = s;
        }

        public NBTTagString serializeNBT() {
            return new NBTTagString(this.s);
        }

        public void deserializeNBT(NBTTagString nbt) {
            this.s = nbt.func_150285_a_();
        }
    }
}

