/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.datastructures;

import com.google.common.base.Throwables;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.utils.helpers.NBTCopyHelper;
import java.io.IOException;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class ItemRef {
    public static final ItemRef NULL = new NullRef();
    String localName;

    private ItemRef() {
    }

    public static ItemRef read(PacketBuffer buffer) {
        byte b = buffer.readByte();
        switch (b) {
            default: {
                return NULL;
            }
            case 1: {
                return Simple.readFromPacket(buffer);
            }
            case 2: {
                return Meta.readFromPacket(buffer);
            }
            case 3: {
                return SimpleNBT.readFromPacket(buffer);
            }
            case 4: 
        }
        return MetaNBT.readFromPacket(buffer);
    }

    public static ItemRef wrap(ItemStack stack) {
        if (stack == null) {
            return NULL;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return NULL;
        }
        if (item.func_77614_k() || item.func_77645_m()) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                return new Meta(item, stack.func_77952_i());
            }
            return new MetaNBT(item, stack.func_77952_i(), nbt);
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return new Simple(item);
        }
        return new SimpleNBT(item, nbt);
    }

    public ItemStack createItemStack(int amount) {
        ItemStack itemStack = new ItemStack(this.getItem(), amount, this.getMeta());
        itemStack.func_77982_d(this.getTagCompound());
        return itemStack;
    }

    public abstract Item getItem();

    public abstract int getMeta();

    public abstract NBTTagCompound getTagCompound();

    public abstract int getTagHash();

    public void write(PacketBuffer buffer) {
        this.writeToPacket(buffer);
    }

    protected abstract void writeToPacket(PacketBuffer var1);

    public abstract boolean equalsItemStack(ItemStack var1);

    public String getDisplayName() {
        if (this.localName != null) {
            return this.localName;
        }
        ItemStack itemStack = this.createItemStack(1);
        this.localName = itemStack.func_82833_r();
        return this.localName;
    }

    public int getMaxStackSize() {
        return this.createItemStack(1).func_77976_d();
    }

    private static class NullRef
    extends ItemRef {
        private NullRef() {
        }

        @Override
        public int getMaxStackSize() {
            return 0;
        }

        @Override
        public ItemStack createItemStack(int amount) {
            return null;
        }

        @Override
        public String getDisplayName() {
            return "[Null]";
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        @Override
        public Item getItem() {
            return null;
        }

        @Override
        public int getMeta() {
            return 0;
        }

        @Override
        public NBTTagCompound getTagCompound() {
            return null;
        }

        @Override
        public int getTagHash() {
            return 0;
        }

        @Override
        protected void writeToPacket(PacketBuffer buffer) {
            buffer.writeByte(0);
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return stack == null || stack.func_77973_b() == null;
        }
    }

    private static final class MetaNBT
    extends SimpleNBT {
        private final int meta;

        public MetaNBT(@Nonnull Item item, int meta, @Nonnull NBTTagCompound tag) {
            super(item, tag);
            this.meta = meta;
        }

        public MetaNBT(@Nonnull Item item, int meta, @Nonnull NBTTagCompound tag, int tagHash) {
            super(item, tag, tagHash);
            this.meta = meta;
        }

        public static ItemRef readFromPacket(PacketBuffer buffer) {
            Item item = Item.func_150899_d((int)buffer.readUnsignedShort());
            short meta = buffer.readShort();
            int tagHash = buffer.readInt();
            NBTTagCompound nbt = buffer.readNBT();
            if (item == null) {
                return NULL;
            }
            return new MetaNBT(item, meta, nbt, tagHash);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Class<?> aClass = o.getClass();
            if (aClass == ItemStack.class) {
                ItemStack stack = (ItemStack)o;
                return this.equalsItemStack(stack);
            }
            if (this.getClass() != aClass) {
                return false;
            }
            MetaNBT metaNBT = (MetaNBT)o;
            return this.meta == metaNBT.meta && this.tagHash == metaNBT.tagHash && this.item == metaNBT.item && this.tagEquals(metaNBT.tag);
        }

        @Override
        public int getMeta() {
            return this.meta;
        }

        @Override
        public int hashCode() {
            int result = System.identityHashCode(this.item) + 1;
            result = 31 * result + this.tagHash;
            result = 31 * result + this.meta;
            return result;
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return stack != null && this.item == stack.func_77973_b() && this.meta == stack.func_77952_i() && stack.func_77942_o() && this.tagEquals(stack.func_77978_p());
        }

        @Override
        protected void writeToPacket(PacketBuffer buffer) {
            buffer.writeByte(4);
            buffer.writeShort(Item.func_150891_b((Item)this.item));
            buffer.writeShort(this.meta);
            this.writeNBT(buffer);
        }
    }

    private static class SimpleNBT
    extends ItemRef {
        @Nonnull
        protected final Item item;
        @Nonnull
        protected final NBTTagCompound tag;
        protected final int tagHash;
        byte[] packetBytes = null;

        public SimpleNBT(@Nonnull Item item, @Nonnull NBTTagCompound tag) {
            this.item = item;
            NBTCopyHelper.ResultNBT resultNBT = NBTCopyHelper.copyAndHashNBT(tag);
            this.tag = resultNBT.copy;
            this.tagHash = resultNBT.hash;
        }

        public SimpleNBT(@Nonnull Item item, @Nonnull NBTTagCompound tag, int tagHash) {
            this.item = item;
            this.tag = tag;
            this.tagHash = tagHash;
        }

        public static ItemRef readFromPacket(PacketBuffer buffer) {
            Item item = Item.func_150899_d((int)buffer.readUnsignedShort());
            int tagHash = buffer.readInt();
            NBTTagCompound nbt = buffer.readNBT();
            if (item == null) {
                return NULL;
            }
            return new SimpleNBT(item, nbt, tagHash);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Class<?> aClass = o.getClass();
            if (aClass == ItemStack.class) {
                ItemStack stack = (ItemStack)o;
                return this.equalsItemStack(stack);
            }
            if (SimpleNBT.class != aClass) {
                return false;
            }
            SimpleNBT simpleNbt = (SimpleNBT)o;
            return this.item == simpleNbt.item && this.tagHash == simpleNbt.tagHash && this.tagEquals(simpleNbt.tag);
        }

        public boolean tagEquals(NBTTagCompound otherTag) {
            return this.tag == otherTag || NBTCopyHelper.equalNBT(this.tag, otherTag);
        }

        public int hashCode() {
            return System.identityHashCode(this.item) * 31 + this.tagHash;
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return stack != null && this.item == stack.func_77973_b() && stack.func_77942_o() && this.tagEquals(stack.func_77978_p());
        }

        @Override
        @Nonnull
        public Item getItem() {
            return this.item;
        }

        @Override
        public int getMeta() {
            return 0;
        }

        @Override
        public NBTTagCompound getTagCompound() {
            return this.tag;
        }

        @Override
        public int getTagHash() {
            return this.tagHash;
        }

        @Override
        protected void writeToPacket(PacketBuffer buffer) {
            buffer.writeByte(3);
            buffer.writeShort(Item.func_150891_b((Item)this.item));
            this.writeNBT(buffer);
        }

        protected void writeNBT(PacketBuffer buffer) {
            buffer.writeInt(this.tagHash);
            if (this.packetBytes == null) {
                try {
                    this.packetBytes = PacketBuffer.compress(this.tag);
                }
                catch (IOException e) {
                    throw Throwables.propagate((Throwable)e);
                }
                if (this.packetBytes == null) {
                    buffer.writeShort(0);
                    return;
                }
            }
            buffer.writeShort(this.packetBytes.length);
            buffer.writeBytes(this.packetBytes);
        }
    }

    private static final class Meta
    extends ItemRef {
        @Nonnull
        private final Item item;
        private final int meta;

        public Meta(@Nonnull Item item, int meta) {
            this.item = item;
            this.meta = meta;
        }

        public static ItemRef readFromPacket(PacketBuffer buffer) {
            Item item = Item.func_150899_d((int)buffer.readShort());
            short damage = buffer.readShort();
            if (item == null) {
                return NULL;
            }
            return new Meta(item, damage);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Class<?> aClass = o.getClass();
            if (aClass == ItemStack.class) {
                ItemStack itemStack = (ItemStack)o;
                return this.equalsItemStack(itemStack);
            }
            if (Meta.class != aClass) {
                return false;
            }
            Meta meta = (Meta)o;
            return this.meta == meta.meta && this.item == meta.item;
        }

        public int hashCode() {
            int result = System.identityHashCode(this.item);
            result = 31 * result + this.meta;
            return result;
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return stack != null && this.item == stack.func_77973_b() && this.meta == stack.func_77952_i() && !stack.func_77942_o();
        }

        @Override
        @Nonnull
        public Item getItem() {
            return this.item;
        }

        @Override
        public int getMeta() {
            return this.meta;
        }

        @Override
        public NBTTagCompound getTagCompound() {
            return null;
        }

        @Override
        public int getTagHash() {
            return 0;
        }

        @Override
        protected void writeToPacket(PacketBuffer buffer) {
            buffer.writeByte(2);
            buffer.writeShort(Item.func_150891_b((Item)this.item));
            buffer.writeShort(this.meta);
        }
    }

    private static final class Simple
    extends ItemRef {
        @Nonnull
        private final Item item;

        public Simple(@Nonnull Item item) {
            this.item = item;
        }

        public static ItemRef readFromPacket(PacketBuffer buffer) {
            Item item = Item.func_150899_d((int)buffer.readUnsignedShort());
            if (item == null) {
                return NULL;
            }
            return new Simple(item);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null) {
                return false;
            }
            Class<?> aClass = o.getClass();
            if (aClass == ItemStack.class) {
                ItemStack stack = (ItemStack)o;
                return this.equalsItemStack(stack);
            }
            if (Simple.class != aClass) {
                return false;
            }
            Simple simple = (Simple)o;
            return this.item == simple.item;
        }

        public int hashCode() {
            return System.identityHashCode(this.item);
        }

        @Override
        @Nonnull
        public Item getItem() {
            return this.item;
        }

        @Override
        public int getMeta() {
            return 0;
        }

        @Override
        public NBTTagCompound getTagCompound() {
            return null;
        }

        @Override
        public int getTagHash() {
            return 0;
        }

        @Override
        protected void writeToPacket(PacketBuffer buffer) {
            buffer.writeByte(1);
            buffer.writeShort(Item.func_150891_b((Item)this.item));
        }

        @Override
        public boolean equalsItemStack(ItemStack stack) {
            return stack != null && this.item == stack.func_77973_b() && !stack.func_77942_o();
        }
    }
}

