/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils.blockaccess;

import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.LongHashMap;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ThreadSafeBlockAccess
implements IBlockAccess {
    public final LongHashMap<Chunk> chunkMap;
    WorldServer world;

    public ThreadSafeBlockAccess(WorldServer world) {
        this.world = world;
        this.chunkMap = world.field_73059_b.field_73244_f;
    }

    public Chunk getChunk(BlockPos pos) {
        long p_76164_1_ = ChunkCoordIntPair.func_77272_a((int)(pos.func_177958_n() >> 4), (int)(pos.func_177952_p() >> 4));
        return (Chunk)this.chunkMap.func_76164_a(p_76164_1_);
    }

    public TileEntity func_175625_s(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return null;
        }
        Map map = chunk.func_177434_r();
        TileEntity tileEntity = (TileEntity)map.get(pos);
        if (tileEntity == null || tileEntity.func_145837_r() || !pos.equals((Object)tileEntity.func_174877_v())) {
            return null;
        }
        return tileEntity;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_175626_b(BlockPos pos, int lightValue) {
        return 0;
    }

    public IBlockState func_180495_p(BlockPos pos) {
        Chunk chunk = this.getChunk(pos);
        if (chunk == null) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return chunk.func_177435_g(pos);
    }

    public boolean func_175623_d(BlockPos pos) {
        return this.func_180495_p(pos).func_177230_c().isAir((IBlockAccess)this, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public BiomeGenBase func_180494_b(BlockPos pos) {
        return BiomeGenBase.field_76767_f;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_72806_N() {
        return false;
    }

    public int func_175627_a(BlockPos pos, EnumFacing direction) {
        IBlockState iblockstate = this.func_180495_p(pos);
        return iblockstate.func_177230_c().func_176211_b((IBlockAccess)this, pos, iblockstate, direction);
    }

    @SideOnly(value=Side.CLIENT)
    public WorldType func_175624_G() {
        return this.world.func_175624_G();
    }

    public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
        Chunk chunk = this.getChunk(pos);
        if (chunk == null || chunk.func_76621_g()) {
            return _default;
        }
        return this.func_180495_p(pos).func_177230_c().isSideSolid((IBlockAccess)this, pos, side);
    }
}

