/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils;

import com.google.common.base.Throwables;
import com.rwtema.extrautils2.ExtraUtils2;
import com.rwtema.extrautils2.backend.ClientCallable;
import com.rwtema.extrautils2.utils.LogHelper;
import com.rwtema.extrautils2.utils.XURandom;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraft.util.StringTranslate;
import net.minecraftforge.fml.relauncher.FMLLaunchHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class Lang {
    private static final TreeMap<String, String> lang = ExtraUtils2.deobf_folder ? new TreeMap() : null;
    private static final HashMap<String, String> textKey = new HashMap();
    private static final int MAX_KEY_LEN = 32;
    private static final TObjectIntHashMap<String> numRandomEntries = new TObjectIntHashMap();

    public static void init() {
    }

    public static void readStream(InputStream stream, boolean safe) {
        HashMap langMap = StringTranslate.parseLangFile((InputStream)stream);
        if (safe) {
            for (Map.Entry entry : langMap.entrySet()) {
                String key = Lang.makeKey((String)entry.getValue());
                if (key.equals(entry.getKey())) continue;
                lang.put((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            lang.putAll(langMap);
        }
    }

    public static String translate(String text) {
        return Lang.translatePrefix(text);
    }

    public static String translatePrefix(String text) {
        String key = Lang.getKey(text);
        return Lang.translate(key, text);
    }

    public static String getKey(String text) {
        String key = textKey.get(text);
        if (key == null) {
            key = Lang.makeKey(text);
            textKey.put(text, key);
            if (ExtraUtils2.deobf_folder) {
                Lang.translate(key, text);
            }
        }
        return key;
    }

    private static String makeKey(String text) {
        String t = Lang.stripText(text);
        String key = "extrautils2.text." + t;
        return key;
    }

    @Nonnull
    public static String stripText(String text) {
        int n;
        String t = text.replaceAll("([^A-Za-z\\s])", "").trim();
        if ((t = t.replaceAll("\\s+", ".").toLowerCase()).length() > 32 && (n = t.indexOf(46, 32)) != -1) {
            t = t.substring(0, n);
        }
        return t;
    }

    public static String translate(String key, String _default) {
        if (StatCollector.func_94522_b((String)key)) {
            return StatCollector.func_74838_a((String)key);
        }
        Lang.initKey(key, _default);
        return _default;
    }

    public static String initKey(String key, String _default) {
        if (ExtraUtils2.deobf_folder && FMLLaunchHandler.side() == Side.CLIENT && !_default.equals(lang.get(key))) {
            lang.put(key, _default);
            Lang.createMissedFile();
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createMissedFile() {
        PrintWriter out = null;
        try {
            try {
                File file = Lang.getFile();
                if (file.getParentFile() != null && file.getParentFile().mkdirs()) {
                    LogHelper.fine("Making Translation Directory", new Object[0]);
                }
                out = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                String t = null;
                for (Map.Entry<String, String> entry : lang.entrySet()) {
                    int i = entry.getKey().indexOf(46);
                    if (i < 0) {
                        i = 1;
                    }
                    String s = entry.getKey().substring(0, i);
                    if (t != null && !t.equals(s)) {
                        out.println("");
                    }
                    t = s;
                    out.println(entry.getKey() + "=" + entry.getValue());
                }
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
        }
        catch (Exception err) {
            err.printStackTrace();
        }
    }

    private static File getFile() {
        return new File(new File(new File("."), "debug_text"), "missed_en_US.lang");
    }

    public static ChatComponentTranslation chat(String message, Object ... args) {
        String key = Lang.getKey(message);
        if (StatCollector.func_94522_b((String)key)) {
            return new ChatComponentTranslation(key, args);
        }
        return new ChatComponentTranslation(message, args);
    }

    public static String translateArgs(boolean dummy, String key, String _default, Object ... args) {
        String translate = Lang.translate(key, _default);
        try {
            return String.format(translate, args);
        }
        catch (IllegalFormatException err) {
            throw new RuntimeException("Message: \"" + _default + "\" with key : \"" + key + "\" and translation: \"" + translate + "\"", err);
        }
    }

    public static String translateArgs(String message, Object ... args) {
        String translate = Lang.translate(message);
        try {
            return String.format(translate, args);
        }
        catch (IllegalFormatException err) {
            throw new RuntimeException("Message: \"" + message + "\" with key : \"" + Lang.getKey(message) + "\" and translation: \"" + translate + "\"", err);
        }
    }

    public static String getItemName(Block block) {
        return Lang.getItemName(new ItemStack(block));
    }

    public static String getItemName(Item item) {
        return Lang.getItemName(new ItemStack(item));
    }

    public static String getItemName(ItemStack stack) {
        return stack.func_82833_r();
    }

    public static String random(String key) {
        return Lang.random(key, XURandom.rand);
    }

    public static String random(String key, Random rand) {
        int n = Lang.getNumSelections(key);
        if (n == 0) {
            return StatCollector.func_74838_a((String)key);
        }
        return StatCollector.func_74838_a((String)(key + "." + rand.nextInt(n)));
    }

    public static String random(String key, int index) {
        int n = Lang.getNumSelections(key);
        int i = Math.abs(index) % n;
        return StatCollector.func_74838_a((String)(key + "." + i));
    }

    private static int getNumSelections(String key) {
        int i;
        if (numRandomEntries.containsKey((Object)key)) {
            i = numRandomEntries.get((Object)key);
        } else {
            i = 0;
            while (StatCollector.func_94522_b((String)(key + "." + i))) {
                ++i;
            }
            numRandomEntries.put((Object)key, ++i);
        }
        return i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        if (ExtraUtils2.deobf_folder && FMLLaunchHandler.side() == Side.CLIENT) {
            try {
                FileInputStream fis = null;
                try {
                    File file = Lang.getFile();
                    fis = new FileInputStream(file);
                    Lang.readStream(fis, true);
                }
                finally {
                    if (fis != null) {
                        fis.close();
                    }
                }
            }
            catch (FileNotFoundException ignore) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ExtraUtils2.proxy.run(new ClientCallable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                @SideOnly(value=Side.CLIENT)
                public void runClient() {
                    ResourceLocation resourceLocation = new ResourceLocation("extrautils2", "lang/en_US.lang");
                    try {
                        IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(resourceLocation);
                        InputStream stream = null;
                        try {
                            stream = resource.func_110527_b();
                            Lang.readStream(stream, false);
                        }
                        finally {
                            if (stream != null) {
                                stream.close();
                            }
                        }
                    }
                    catch (IOException e) {
                        throw Throwables.propagate((Throwable)e);
                    }
                    Lang.createMissedFile();
                }
            });
        }
    }
}

