/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.utils;

import com.google.common.collect.Lists;
import com.rwtema.extrautils2.fluids.FluidWrapper;
import com.rwtema.extrautils2.fluids.IFluidInterface;
import com.rwtema.extrautils2.transfernodes.IPipeConnect;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class CapGetter<T> {
    public static CapGetter<IItemHandler> ItemHandler = new CapGetter<IItemHandler>(IItemHandler.class, new Converter<ISidedInventory, IItemHandler>(ISidedInventory.class){

        @Override
        protected IItemHandler convertInstance(ISidedInventory type, EnumFacing side) {
            return side != null ? new SidedInvWrapper(type, side) : null;
        }
    }, new Converter<IInventory, IItemHandler>(IInventory.class){

        @Override
        protected IItemHandler convertInstance(IInventory type, EnumFacing side) {
            return new InvWrapper(type);
        }
    });
    public static CapGetter<IPipeConnect> PipeConnect = new CapGetter<IPipeConnect>(IPipeConnect.class, new Converter[0]){

        @Override
        public boolean hasInterface(ICapabilityProvider provider, EnumFacing side) {
            return provider instanceof IPipeConnect && ((IPipeConnect)provider).forceConnect(side);
        }

        @Override
        public IPipeConnect getInterface(ICapabilityProvider provider, EnumFacing side) {
            return null;
        }
    };
    public static CapGetter<IFluidInterface> fluids = new CapGetter<IFluidInterface>(IFluidInterface.class, new Converter<IFluidHandler, IFluidInterface>(IFluidHandler.class){

        @Override
        public boolean canHandle(Object type, EnumFacing side) {
            if (!(type instanceof IFluidHandler)) {
                return false;
            }
            FluidTankInfo[] tankInfo = ((IFluidHandler)type).getTankInfo(side);
            return tankInfo != null && tankInfo.length > 0;
        }

        @Override
        protected IFluidInterface convertInstance(IFluidHandler type, EnumFacing side) {
            return new FluidWrapper(type, side);
        }
    });
    public static ArrayList<CapGetter<?>> caps = Lists.newArrayList((Object[])new CapGetter[]{ItemHandler, PipeConnect, fluids});
    private static IdentityHashMap<String, Capability<?>> providers = (IdentityHashMap)ObfuscationReflectionHelper.getPrivateValue(CapabilityManager.class, (Object)CapabilityManager.INSTANCE, (String[])new String[]{"providers"});
    final Class<T> clazz;
    final Converter<?, T>[] converters;
    boolean init;
    Capability<T> capability;

    public CapGetter(Class<T> clazz, Converter<?, T> ... converters) {
        this.clazz = clazz;
        this.converters = converters;
    }

    static <T> Capability<T> getCapability(Class<T> clazz) {
        String intern = clazz.getName().intern();
        return providers.get(intern);
    }

    public boolean hasInterface(ICapabilityProvider provider, EnumFacing side) {
        if (!this.init) {
            this.capability = CapGetter.getCapability(this.clazz);
            boolean bl = this.init = this.capability != null || Loader.instance().hasReachedState(LoaderState.AVAILABLE);
        }
        if (this.capability != null && provider.hasCapability(this.capability, side)) {
            return true;
        }
        if (this.clazz.isInstance(provider)) {
            return true;
        }
        for (Converter<?, T> converter : this.converters) {
            if (!converter.canHandle(provider, side)) continue;
            return true;
        }
        return false;
    }

    public T getInterface(ICapabilityProvider provider, EnumFacing side) {
        if (!this.init) {
            this.capability = CapGetter.getCapability(this.clazz);
            boolean bl = this.init = this.capability != null || Loader.instance().hasReachedState(LoaderState.AVAILABLE);
        }
        if (this.capability != null && provider.hasCapability(this.capability, side)) {
            return (T)provider.getCapability(this.capability, side);
        }
        if (this.clazz.isInstance(provider)) {
            return (T)provider;
        }
        for (Converter<?, T> converter : this.converters) {
            T convert = converter.convert(provider, side);
            if (convert == null) continue;
            return convert;
        }
        return null;
    }

    public static abstract class Converter<S, T> {
        final Class<S> toConvert;

        protected Converter(Class<S> toConvert) {
            this.toConvert = toConvert;
        }

        public T convert(Object type, EnumFacing side) {
            return this.canHandle(type, side) ? (T)this.convertInstance(type, side) : null;
        }

        public boolean canHandle(Object type, EnumFacing side) {
            return this.toConvert.isInstance(type);
        }

        protected abstract T convertInstance(S var1, EnumFacing var2);
    }
}

