/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.gui.backend.DynamicContainer;
import com.rwtema.extrautils2.gui.backend.DynamicContainerTile;
import com.rwtema.extrautils2.gui.backend.IDynamicHandler;
import com.rwtema.extrautils2.gui.backend.IWidget;
import com.rwtema.extrautils2.gui.backend.WidgetSlotItemHandler;
import com.rwtema.extrautils2.gui.backend.WidgetTextData;
import com.rwtema.extrautils2.itemhandler.InventoryHelper;
import com.rwtema.extrautils2.itemhandler.PublicWrapper;
import com.rwtema.extrautils2.itemhandler.SingleStackHandler;
import com.rwtema.extrautils2.network.PacketBuffer;
import com.rwtema.extrautils2.transfernodes.FacingHelper;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.TransferNodeBase;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.CapGetter;
import com.rwtema.extrautils2.utils.Lang;
import com.rwtema.extrautils2.utils.helpers.BlockStates;
import java.util.EnumSet;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TransferNodeItem
extends TransferNodeBase<IItemHandler>
implements IDynamicHandler {
    SingleStackHandler stack = this.registerNBT("Buffer", new SingleStackHandler(){

        @Override
        protected int getStackLimit(ItemStack stack) {
            return stack.func_77976_d();
        }

        @Override
        protected void onContentsChanged() {
            TransferNodeItem.this.holder.func_70296_d();
        }
    });

    @Override
    protected boolean shouldAdvance() {
        return !this.stack.isEmpty();
    }

    @Override
    protected void processBuffer(IItemHandler attached) {
        block6: {
            block5: {
                BlockPos offset;
                if (attached != null) break block5;
                int upgradeLevel = this.getUpgradeLevel(Upgrade.MINING);
                if (upgradeLevel <= 0) break block6;
                if (this.stack.isFull()) {
                    return;
                }
                ItemStack b = new ItemStack(Blocks.field_150347_e, upgradeLevel);
                if (!this.stack.isEmpty() && !ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack.getStack(), (ItemStack)b)) {
                    return;
                }
                World world = this.holder.func_145831_w();
                IBlockState state = world.func_180495_p(offset = this.holder.func_174877_v().func_177972_a(this.side));
                if (state != BlockStates.cobblestone) break block6;
                boolean lava = false;
                boolean water = false;
                EnumSet<EnumFacing> enumFacings = FacingHelper.horizontalOrthogonal.get(this.side);
                for (EnumFacing facing : enumFacings) {
                    IBlockState blockState = world.func_180495_p(offset.func_177972_a(facing));
                    if (blockState == BlockStates.lava_level_0) {
                        lava = true;
                        continue;
                    }
                    if (blockState != BlockStates.water_level_0) continue;
                    water = true;
                }
                if (!water || !lava) break block6;
                this.stack.insertItem(0, b, false);
                break block6;
            }
            for (int i = 0; i < attached.getSlots() && !this.stack.isFull(); ++i) {
                InventoryHelper.transferSlotAtoSlotB(attached, i, (IItemHandler)this.stack, 0, this.getMaxTransfer());
            }
        }
    }

    protected int getMaxTransfer() {
        return this.getUpgradeLevel(Upgrade.STACK_SIZE) > 0 ? 64 : 1;
    }

    @Override
    protected boolean processPosition(BlockPos pingPos, IItemHandler attached, IPipe pipe) {
        if (pipe == null) {
            return true;
        }
        int maxTransfer = this.stack.getStackLevel();
        for (EnumFacing facing : FacingHelper.getRandomFaceOrderPooled()) {
            IItemHandler capability = pipe.getCapability((IBlockAccess)this.holder.func_145831_w(), pingPos, facing, CapGetter.ItemHandler);
            if (capability == null || (maxTransfer -= InventoryHelper.transfer((IItemHandler)this.stack, 0, capability, maxTransfer, true)) != 0) continue;
            break;
        }
        if (this.stack.isEmpty()) {
            this.ping.resetPosition();
            return false;
        }
        return true;
    }

    @Override
    public boolean onActivated(EntityPlayer playerIn, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.holder.func_145831_w().field_72995_K) {
            return true;
        }
        this.holder.openGui(playerIn, this);
        return true;
    }

    @Override
    public IItemHandler getHandler(TileEntity tile) {
        return CapGetter.ItemHandler.getInterface((ICapabilityProvider)tile, this.side.func_176734_d());
    }

    @Override
    public DynamicContainer getDynamicContainer(int ID2, EntityPlayer player, World world, int x, int y, int z) {
        return new TransferNodeContainer(player);
    }

    @Override
    public <T> T getInterface(TileEntity tileEntity, CapGetter<T> capability) {
        IItemHandler handler;
        if (capability == CapGetter.ItemHandler && (handler = CapGetter.ItemHandler.getInterface((ICapabilityProvider)tileEntity, this.side.func_176734_d())) != null) {
            return (T)new PublicWrapper.Extract(handler);
        }
        return super.getInterface(tileEntity, capability);
    }

    public class TransferNodeContainer
    extends DynamicContainerTile {
        public TransferNodeContainer(EntityPlayer player) {
            super(TransferNodeItem.this.holder, 9, 64);
            this.addTitle("Transfer Node");
            int numUpgradeSlots = TransferNodeItem.this.upgradeHandler.getSlots();
            for (int i = 0; i < numUpgradeSlots; ++i) {
                this.addWidget(new WidgetSlotItemHandler((IItemHandler)TransferNodeItem.this.upgradeHandler, i, 85 + i * 18 - 9 * numUpgradeSlots, 80));
            }
            this.addWidget(new WidgetSlotItemHandler((IItemHandler)TransferNodeItem.this.stack, 0, 76, 31));
            this.addWidget((IWidget)new WidgetTextData(4, 68, 154){

                @Override
                public void addToDescription(PacketBuffer packet) {
                    packet.writeBlockPos(TransferNodeItem.this.ping.getPos());
                }

                @Override
                protected String constructText(PacketBuffer packet) {
                    BlockPos pos = packet.readBlockPos();
                    pos = pos.func_177973_b((Vec3i)TransferNodeItem.this.holder.func_174877_v());
                    return Lang.translateArgs("x = %s, y = %s, z = %s", pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }.setAlign(0));
            this.cropAndAddPlayerSlots(player.field_71071_by);
            this.validate();
        }
    }
}

