/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils2.transfernodes;

import com.rwtema.extrautils2.transfernodes.Grocket;
import com.rwtema.extrautils2.transfernodes.GrocketType;
import com.rwtema.extrautils2.transfernodes.IPipe;
import com.rwtema.extrautils2.transfernodes.IUpgradeProvider;
import com.rwtema.extrautils2.transfernodes.Ping;
import com.rwtema.extrautils2.transfernodes.TransferHelper;
import com.rwtema.extrautils2.transfernodes.Upgrade;
import com.rwtema.extrautils2.utils.CapGetter;
import gnu.trove.map.hash.TObjectIntHashMap;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ITickable;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public abstract class TransferNodeBase<T>
extends Grocket
implements ITickable {
    protected final Ping ping = this.registerNBT("ping", new Ping());
    protected int cooldown = 0;
    TObjectIntHashMap<Upgrade> upgrades;
    public ItemStackHandler upgradeHandler = this.registerNBT("upgrades", new ItemStackHandler(6){

        protected int getStackLimit(int slot, ItemStack stack) {
            if (!(stack.func_77973_b() instanceof IUpgradeProvider)) {
                return 0;
            }
            for (int i = 0; i < this.stacks.length; ++i) {
                ItemStack otherStack;
                if (i == slot || (otherStack = this.stacks[i]) == null || !ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)otherStack)) continue;
                return 0;
            }
            Upgrade upgrade = ((IUpgradeProvider)stack.func_77973_b()).getUpgrades(stack);
            if (upgrade == null) {
                return 0;
            }
            return upgrade.maxLevel;
        }

        protected void onContentsChanged(int slot) {
            TransferNodeBase.this.markDirty();
            this.loadUpgrades();
        }

        protected void onLoad() {
            this.loadUpgrades();
        }

        public void loadUpgrades() {
            TObjectIntHashMap upgradeMap = new TObjectIntHashMap(10, 0.5f, 0);
            for (ItemStack stack : this.stacks) {
                if (stack == null || !(stack.func_77973_b() instanceof IUpgradeProvider)) continue;
                upgradeMap.adjustOrPutValue((Object)((IUpgradeProvider)stack.func_77973_b()).getUpgrades(stack), stack.field_77994_a, stack.field_77994_a);
            }
            TransferNodeBase.this.upgrades = upgradeMap;
        }
    });

    public int getUpgradeLevel(Upgrade upgrade) {
        TObjectIntHashMap<Upgrade> upgrades = this.upgrades;
        if (upgrades == null) {
            return upgrade.getModifierLevel(0);
        }
        int level = upgrades.get((Object)upgrade);
        if (level < 0) {
            level = 0;
        }
        if (level > upgrade.maxLevel) {
            level = upgrade.maxLevel;
        }
        return upgrade.getModifierLevel(level);
    }

    @Override
    public GrocketType getType() {
        return GrocketType.TRANSFER_NODE_ITEMS;
    }

    public void func_73660_a() {
        if (this.holder == null) {
            return;
        }
        World world = this.holder.func_145831_w();
        if (this.ping.needsInit()) {
            this.ping.init((IBlockAccess)world, this.holder.func_174877_v(), this.side.func_176734_d());
            return;
        }
        if (this.cooldown > 0) {
            this.cooldown -= this.stepCooldown();
        }
        if (this.checkRedstone()) {
            this.cooldown = 20;
            return;
        }
        T attached = this.getAttached();
        while (this.cooldown <= 0) {
            this.cooldown += 20;
            this.processBuffer(attached);
            if (this.shouldAdvance()) {
                BlockPos pingPos = this.ping.getPos();
                if (pingPos == null) {
                    return;
                }
                if (!world.func_175667_e(pingPos)) {
                    this.ping.resetPosition();
                    return;
                }
                IPipe pipe = TransferHelper.getPipe((IBlockAccess)world, pingPos);
                if (!this.processPosition(pingPos, attached, pipe)) continue;
                this.ping.advanceSearch(pipe);
                continue;
            }
            this.ping.resetPosition();
        }
    }

    protected abstract boolean shouldAdvance();

    protected abstract void processBuffer(@Nullable T var1);

    protected abstract boolean processPosition(BlockPos var1, T var2, IPipe var3);

    private int stepCooldown() {
        return 1 + this.getUpgradeLevel(Upgrade.SPEED);
    }

    public boolean checkRedstone() {
        return this.holder.func_145831_w().func_175640_z(this.holder.func_174877_v());
    }

    public T getAttached() {
        TileEntity tile = this.holder.func_145831_w().func_175625_s(this.holder.func_174877_v().func_177972_a(this.side));
        if (tile == null) {
            return null;
        }
        T capability1 = this.getHandler(tile);
        if (capability1 != null) {
            return capability1;
        }
        return null;
    }

    public abstract T getHandler(TileEntity var1);

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        super.writeToNBT(tag);
        tag.func_74768_a("Cooldown", this.cooldown);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        super.readFromNBT(tag);
        this.cooldown = tag.func_74762_e("Cooldown");
    }

    public <S> boolean hasInterface(TileEntity tileEntity, CapGetter<S> capability) {
        return capability == CapGetter.PipeConnect || super.hasInterface(tileEntity, capability);
    }
}

